/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.task.multi.BaseMapTask;
import journeymap.client.task.multi.ITask;
import journeymap.client.task.multi.ITaskManager;
import journeymap.client.task.multi.RenderSpec;
import journeymap.client.task.multi.TaskBatch;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;

public class MapPlayerTask
extends BaseMapTask {
    private static int MAX_STALE_MILLISECONDS = 30000;
    private static int MAX_BATCH_SIZE = 32;
    private static final DecimalFormat decFormat = new DecimalFormat("##.#");
    private static volatile long lastTaskCompleted;
    private static long lastTaskTime;
    private static double lastTaskAvgChunkTime;
    private static final Cache<String, String> tempDebugLines;
    private final int maxRuntime;
    private int scheduledChunks;
    private long startNs;
    private long elapsedNs;

    private MapPlayerTask(ChunkRenderController chunkRenderController, Level world, MapType mapType, Collection<ChunkPos> chunkCoords) {
        super(chunkRenderController, world, mapType, chunkCoords, false, true, 10000);
        this.maxRuntime = JourneymapClient.getInstance().getCoreProperties().renderDelay.get() * 3000;
        this.scheduledChunks = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceNearbyRemap() {
        Class<MapPlayerTask> clazz = MapPlayerTask.class;
        synchronized (MapPlayerTask.class) {
            DataCache.INSTANCE.invalidateChunkMDCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static MapPlayerTaskBatch create(ChunkRenderController chunkRenderController, EntityDTO player) {
        long time;
        boolean surfaceAllowed = FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        boolean cavesAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        boolean topoAllowed = FeatureManager.getInstance().isAllowed(Feature.MapTopo);
        boolean biomeAllowed = FeatureManager.getInstance().isAllowed(Feature.MapBiome);
        if (!(surfaceAllowed || cavesAllowed || topoAllowed || biomeAllowed)) {
            return null;
        }
        LivingEntity playerEntity = (LivingEntity)player.entityLivingRef.get();
        if (playerEntity == null) {
            return null;
        }
        boolean underground = player.underground;
        MapType mapType = underground ? MapType.underground(player) : ((time = playerEntity.m_9236_().m_6106_().m_6792_() % 24000L) < 13800L ? MapType.day(player) : MapType.night(player));
        ArrayList<ITask> tasks = new ArrayList<ITask>(2);
        tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.m_9236_(), mapType, new ArrayList<ChunkPos>()));
        if (underground) {
            if (surfaceAllowed && JourneymapClient.getInstance().getCoreProperties().alwaysMapSurface.get().booleanValue()) {
                tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.m_9236_(), MapType.day(player), new ArrayList<ChunkPos>()));
            }
        } else if (cavesAllowed && JourneymapClient.getInstance().getCoreProperties().alwaysMapCaves.get().booleanValue()) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.m_9236_(), MapType.underground(player), new ArrayList<ChunkPos>()));
        }
        if (topoAllowed && JourneymapClient.getInstance().getCoreProperties().mapTopography.get().booleanValue()) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.m_9236_(), MapType.topo(player), new ArrayList<ChunkPos>()));
        }
        if (biomeAllowed && JourneymapClient.getInstance().getCoreProperties().mapBiome.get().booleanValue()) {
            tasks.add(new MapPlayerTask(chunkRenderController, playerEntity.m_9236_(), MapType.biome(player), new ArrayList<ChunkPos>()));
        }
        return new MapPlayerTaskBatch(tasks);
    }

    public static String[] getDebugStats() {
        try {
            CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
            boolean underground = DataCache.getPlayer().underground;
            ArrayList lines = new ArrayList(tempDebugLines.asMap().values());
            if (underground || coreProperties.alwaysMapCaves.get().booleanValue()) {
                lines.add(RenderSpec.getUndergroundSpec().getDebugStats());
            }
            if (!underground || coreProperties.alwaysMapSurface.get().booleanValue()) {
                lines.add(RenderSpec.getSurfaceSpec().getDebugStats());
            }
            if (!underground && coreProperties.mapTopography.get().booleanValue()) {
                lines.add(RenderSpec.getTopoSpec().getDebugStats());
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Throwable t) {
            logger.error((Object)t);
            return new String[0];
        }
    }

    public static void addTempDebugMessage(String key, String message) {
        if (Minecraft.m_91087_().m_293199_().m_295669_()) {
            tempDebugLines.put((Object)key, (Object)message);
        }
    }

    public static void removeTempDebugMessage(String key) {
        tempDebugLines.invalidate((Object)key);
    }

    public static String getSimpleStats() {
        RenderSpec spec;
        int primaryRenderSize = 0;
        int secondaryRenderSize = 0;
        int totalChunks = 0;
        if ((DataCache.getPlayer().underground.booleanValue() || JourneymapClient.getInstance().getCoreProperties().alwaysMapCaves.get().booleanValue()) && (spec = RenderSpec.getUndergroundSpec()) != null) {
            primaryRenderSize += spec.getPrimaryRenderSize();
            secondaryRenderSize += spec.getLastSecondaryRenderSize();
            totalChunks += spec.getLastTaskChunks();
        }
        if ((!DataCache.getPlayer().underground.booleanValue() || JourneymapClient.getInstance().getCoreProperties().alwaysMapSurface.get().booleanValue()) && (spec = RenderSpec.getSurfaceSpec()) != null) {
            primaryRenderSize += spec.getPrimaryRenderSize();
            secondaryRenderSize += spec.getLastSecondaryRenderSize();
            totalChunks += spec.getLastTaskChunks();
        }
        return Constants.getString("jm.common.renderstats", totalChunks, primaryRenderSize, secondaryRenderSize, lastTaskTime, decFormat.format(lastTaskAvgChunkTime));
    }

    public static long getlastTaskCompleted() {
        return lastTaskCompleted;
    }

    @Override
    public void initTask(Minecraft minecraft, JourneymapClient jm, File jmWorldDir, boolean threadLogging) {
        this.startNs = System.nanoTime();
        RenderSpec renderSpec = this.mapType.isUnderground() ? RenderSpec.getUndergroundSpec() : (this.mapType.isTopo() ? RenderSpec.getTopoSpec() : RenderSpec.getSurfaceSpec());
        long now = System.currentTimeMillis();
        List<ChunkPos> renderArea = renderSpec.getRenderAreaCoords();
        int maxBatchSize = renderArea.size() / 4;
        renderArea.removeIf(chunkPos -> {
            ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(chunkPos.m_45588_());
            if (chunkMD == null || !chunkMD.hasChunk() || now - chunkMD.getLastRendered(this.mapType) < 30000L) {
                return true;
            }
            if (!chunkMD.getDimension().equals(this.mapType.dimension)) {
                return true;
            }
            chunkMD.resetBlockData(this.mapType);
            return false;
        });
        if (renderArea.size() <= maxBatchSize) {
            this.chunkCoords.addAll(renderArea);
        } else {
            List<ChunkPos> list = Arrays.asList(renderArea.toArray(new ChunkPos[renderArea.size()]));
            this.chunkCoords.addAll(list.subList(0, maxBatchSize));
        }
        this.scheduledChunks = this.chunkCoords.size();
    }

    @Override
    protected void complete(int mappedChunks, boolean cancelled, boolean hadError) {
        this.elapsedNs = System.nanoTime() - this.startNs;
    }

    @Override
    public int getMaxRuntime() {
        return this.maxRuntime;
    }

    static {
        tempDebugLines = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(1500L, TimeUnit.MILLISECONDS).build();
    }

    public static class MapPlayerTaskBatch
    extends TaskBatch {
        public MapPlayerTaskBatch(List<ITask> tasks) {
            super(tasks);
        }

        @Override
        public void performTask(Minecraft mc, JourneymapClient jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
            if (mc.f_91074_ == null) {
                return;
            }
            this.startNs = System.nanoTime();
            ArrayList tasks = new ArrayList(this.taskList);
            super.performTask(mc, jm, jmWorldDir, threadLogging);
            this.elapsedNs = System.nanoTime() - this.startNs;
            lastTaskTime = TimeUnit.NANOSECONDS.toMillis(this.elapsedNs);
            lastTaskCompleted = System.currentTimeMillis();
            int chunkCount = 0;
            for (ITask task : tasks) {
                if (task instanceof MapPlayerTask) {
                    MapPlayerTask mapPlayerTask = (MapPlayerTask)task;
                    chunkCount += mapPlayerTask.scheduledChunks;
                    if (mapPlayerTask.mapType.isUnderground()) {
                        RenderSpec.getUndergroundSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                        continue;
                    }
                    if (mapPlayerTask.mapType.isTopo()) {
                        RenderSpec.getTopoSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                        continue;
                    }
                    RenderSpec.getSurfaceSpec().setLastTaskInfo(mapPlayerTask.scheduledChunks, mapPlayerTask.elapsedNs);
                    continue;
                }
                Journeymap.getLogger().warn("Unexpected task in batch: " + task);
            }
            lastTaskAvgChunkTime = (double)(this.elapsedNs / (long)Math.max(1, chunkCount)) / 1000000.0;
        }
    }

    public static class Manager
    implements ITaskManager {
        final int mapTaskDelay;
        boolean enabled;

        public Manager() {
            this.mapTaskDelay = JourneymapClient.getInstance().getCoreProperties().renderDelay.get() * 1000;
        }

        public Class<? extends BaseMapTask> getTaskClass() {
            return MapPlayerTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            this.enabled = true;
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            this.enabled = false;
        }

        @Override
        public ITask getTask(Minecraft minecraft) {
            if (this.enabled && minecraft.f_91074_.f_146801_ != EntityInLevelCallback.f_156799_ && System.currentTimeMillis() - lastTaskCompleted >= (long)this.mapTaskDelay) {
                ChunkRenderController chunkRenderController = JourneymapClient.getInstance().getChunkRenderController();
                return MapPlayerTask.create(chunkRenderController, DataCache.getPlayer());
            }
            return null;
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
        }
    }
}

