/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.service.webmap.Webmap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<MutableComponent> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(Component chat) {
        MutableComponent wrap = Component.m_237110_((String)"jm.common.chat_announcement", (Object[])new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        MutableComponent chat = Constants.getStringTextComponent(message);
        chat.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        chat.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Constants.getStringTextComponent(url))));
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceFile(String message, File file) {
        MutableComponent chat = Constants.getStringTextComponent(message);
        try {
            String path = file.getCanonicalPath();
            chat.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
            chat.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Constants.getStringTextComponent(path))));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        MutableComponent chat = Constants.getStringTextComponent(text);
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement(chat);
    }

    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getInstance().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            MutableComponent message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.f_91065_.m_93076_().m_93785_((Component)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = ((TranslatableContents)message.m_214077_()).m_237523_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, StringUtil.m_14406_((String)message.getString()));
                    throw throwable;
                }
                logLevel = ((TranslatableContents)message.m_214077_()).m_237523_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, StringUtil.m_14406_((String)message.getString()));
                continue;
            }
            logLevel = ((TranslatableContents)message.m_214077_()).m_237523_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, StringUtil.m_14406_((String)message.getString()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = JourneymapClient.getInstance().getKeyEvents().getHandler().kbFullscreenToggle.m_90863_().getString().toUpperCase();
            if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                try {
                    Webmap webServer = JourneymapClient.getInstance().getJmServer();
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    implements Component {
        String text;

        public ErrorChat(String text) {
            this.text = text;
        }

        public Style m_7383_() {
            return Style.f_131099_;
        }

        public ComponentContents m_214077_() {
            return PlainTextContents.m_307377_((String)this.text);
        }

        public List<Component> m_7360_() {
            return Lists.newArrayList();
        }

        public FormattedCharSequence m_7532_() {
            return FormattedCharSequence.f_13691_;
        }
    }
}

