/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExperiencePointsRequirement
implements WarpRequirement {
    private int points;

    public ExperiencePointsRequirement(int points) {
        this.points = Math.max(0, points);
    }

    @Override
    public boolean canAfford(Player player) {
        double xpForProgress;
        int xpForLevel = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(player.f_36078_);
        double totalXp = (double)xpForLevel + (xpForProgress = Math.floor(player.f_36080_ * (float)ExperiencePointsRequirement.getXpNeededForNextLevel(player.f_36078_)));
        return totalXp >= (double)this.points;
    }

    @Override
    public void consume(Player player) {
        player.m_6756_(-this.points);
    }

    @Override
    public void rollback(Player player) {
        player.m_6756_(this.points);
    }

    @Override
    public void appendHoverText(Player player, List<Component> tooltip) {
        if (this.points > 0) {
            tooltip.add((Component)Component.m_237110_((String)"gui.waystones.waystone_selection.xp_requirement", (Object[])new Object[]{this.points}).m_130940_(ChatFormatting.GREEN));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.points <= 0;
    }

    public static int calculateLevelCostFromExperiencePoints(int currentLevel, int xpLoss) {
        return currentLevel - ExperiencePointsRequirement.calculateLevelMinusExperiencePoints(currentLevel, xpLoss);
    }

    private static int calculateLevelMinusExperiencePoints(int currentLevel, int xpLoss) {
        int currentCumulativeXp = ExperiencePointsRequirement.getCumulativeXpNeededForLevel(currentLevel);
        int remainingXp = currentCumulativeXp - xpLoss;
        int newLevel = 0;
        int newCumulativeXp = 0;
        for (int level = 0; level <= currentLevel; ++level) {
            if (remainingXp >= (newCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level))) continue;
            newLevel = level;
            break;
        }
        return newLevel;
    }

    private static int getXpNeededForNextLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int getCumulativeXpNeededForLevel(int targetLevel) {
        int currentCumulativeXp = 0;
        for (int level = 0; level < targetLevel; ++level) {
            currentCumulativeXp += ExperiencePointsRequirement.getXpNeededForNextLevel(level);
        }
        return currentCumulativeXp;
    }

    public void setPoints(int value) {
        this.points = value;
    }

    public int getPoints() {
        return this.points;
    }
}

