/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.api.event.WaystoneTeleportEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaystoneTeleportManager {
    public static Collection<? extends Entity> findPets(Entity entity) {
        return entity.m_9236_().m_6443_(TamableAnimal.class, new AABB(entity.m_20183_()).m_82400_(10.0), pet -> entity.m_20148_().equals(pet.m_21805_()) && !pet.m_21827_() && !WaystonePermissionManager.isEntityDeniedTeleports((Entity)pet));
    }

    public static List<Mob> findLeashedAnimals(Entity player) {
        return player.m_9236_().m_6443_(Mob.class, new AABB(player.m_20183_()).m_82400_(10.0), e -> player.equals((Object)e.m_21524_()));
    }

    public static Either<List<Entity>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context) {
        MinecraftServer server = context.getEntity().m_20194_();
        if (server == null) {
            return Either.right((Object)new WaystoneTeleportError.NotOnServer());
        }
        return WaystoneTeleportManager.resolveDestination(server, context.getTargetWaystone()).flatMap(it -> WaystoneTeleportManager.doTeleport(context, it));
    }

    public static Either<List<Entity>, WaystoneTeleportError> doTeleport(WaystoneTeleportContext context, TeleportDestination destination) {
        ServerLevel sourceLevel = (ServerLevel)context.getEntity().m_9236_();
        List<Entity> teleportedEntities = WaystoneTeleportManager.teleportEntityAndAttached(context.getEntity(), context, destination);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(WaystoneTeleportManager.teleportEntityAndAttached(additionalEntity, context, destination)));
        BlockPos sourcePos = context.getEntity().m_20183_();
        ServerLevel targetLevel = (ServerLevel)destination.level();
        BlockPos targetPos = BlockPos.m_274446_((Position)destination.location());
        BlockEntity targetTileEntity = targetLevel.m_7702_(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceLevel.m_245803_(context.getEntity(), sourcePos, SoundEvents.f_12287_, SoundSource.PLAYERS, 0.01f, 1.0f);
            targetLevel.m_5594_(null, targetPos, SoundEvents.f_12287_, SoundSource.PLAYERS, 0.05f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceLevel, sourcePos, (Object)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (Object)new TeleportEffectMessage(targetPos));
        }
        return Either.left(teleportedEntities);
    }

    private static List<Entity> teleportEntityAndAttached(Entity entity, WaystoneTeleportContext context, TeleportDestination destination) {
        ArrayList<Entity> teleportedEntities = new ArrayList<Entity>();
        ServerLevel targetLevel = (ServerLevel)destination.level();
        Vec3 targetLocation = destination.location();
        Direction targetDirection = destination.direction();
        Entity mount = entity.m_20202_();
        Entity teleportedMount = null;
        if (mount != null) {
            teleportedMount = WaystoneTeleportManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<Mob> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            Entity teleportedLeashedEntity = WaystoneTeleportManager.teleportEntity((Entity)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        Entity teleportedEntity = WaystoneTeleportManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof Mob) {
                Mob teleportedLeashedMob = (Mob)teleportedLeashedEntity;
                teleportedLeashedMob.m_21463_(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetWorld, Vec3 targetPos3d, Direction direction) {
        float yaw = direction.m_122435_();
        double x = targetPos3d.f_82479_;
        double y = targetPos3d.f_82480_;
        double z = targetPos3d.f_82481_;
        if (entity instanceof ServerPlayer) {
            ChunkPos chunkPos = new ChunkPos(BlockPos.m_274561_((double)x, (double)y, (double)z));
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)entity.m_19879_());
            entity.m_8127_();
            if (((ServerPlayer)entity).m_5803_()) {
                ((ServerPlayer)entity).m_6145_(true, true);
            }
            if (targetWorld == entity.m_9236_()) {
                ((ServerPlayer)entity).f_8906_.m_9780_(x, y, z, yaw, entity.m_146909_(), Collections.emptySet());
            } else {
                ((ServerPlayer)entity).m_8999_(targetWorld, x, y, z, yaw, entity.m_146909_());
            }
            entity.m_5616_(yaw);
        } else {
            float pitch = Mth.m_14036_((float)entity.m_146909_(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.m_9236_()) {
                entity.m_7678_(x, y, z, yaw, pitch);
                entity.m_5616_(yaw);
            } else {
                entity.m_19877_();
                Entity oldEntity = entity;
                entity = entity.m_6095_().m_20615_((Level)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.m_20361_(oldEntity);
                entity.m_7678_(x, y, z, yaw, pitch);
                entity.m_5616_(yaw);
                oldEntity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.m_143334_(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).m_21255_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entity.m_6853_(true);
        }
        if (entity instanceof PathfinderMob) {
            ((PathfinderMob)entity).m_21573_().m_26573_();
        }
        WaystoneTeleportManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    private static Either<TeleportDestination, WaystoneTeleportError> resolveDestination(MinecraftServer server, Waystone waystone) {
        ResourceLocation waystoneType;
        ServerLevel level = server.m_129880_(waystone.getDimension());
        if (level == null) {
            return Either.right((Object)new WaystoneTeleportError.InvalidDimension(waystone.getDimension()));
        }
        BlockPos pos = waystone.getPos();
        BlockState state = level.m_8055_(pos);
        Direction direction = state.m_61138_((Property)WaystoneBlock.FACING) ? (Direction)state.m_61143_((Property)WaystoneBlock.FACING) : Direction.NORTH;
        ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
        for (Direction candidate : directionCandidates) {
            BlockPos offsetPos = pos.m_121945_(candidate);
            BlockPos offsetPosUp = offsetPos.m_7494_();
            if (level.m_8055_(offsetPos).m_60828_((BlockGetter)level, offsetPos) || level.m_8055_(offsetPosUp).m_60828_((BlockGetter)level, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        boolean shouldOffsetFacing = !(waystoneType = waystone.getWaystoneType()).equals((Object)WaystoneTypes.WARP_PLATE) && !waystoneType.equals((Object)WaystoneTypes.LANDING_STONE);
        BlockPos targetPos = shouldOffsetFacing ? pos.m_121945_(direction) : pos;
        Vec3 location = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        return Either.left((Object)new TeleportDestination((Level)level, location, direction));
    }

    private static void sendHackySyncPacketsAfterTeleport(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
    }

    public static Either<List<Entity>, WaystoneTeleportError> tryTeleport(WaystoneTeleportContext context) {
        Player player;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        Entity entity = context.getEntity();
        if (!context.getLeashedEntities().isEmpty()) {
            if (WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.DISABLED) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            for (Mob leashedEntity : context.getLeashedEntities()) {
                if (!WaystonePermissionManager.isEntityDeniedTeleports((Entity)leashedEntity)) continue;
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied((Entity)leashedEntity));
            }
            if (context.isDimensionalTeleport() && WaystonesConfig.getActive().teleports.transportLeashed == WaystonesConfigData.TransportMobs.SAME_DIMENSION) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (!context.getRequirements().canAfford(player) && !player.m_150110_().f_35937_) {
                return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            context.getRequirements().consume(player);
        }
        return WaystoneTeleportManager.doTeleport(context).ifLeft(teleportedEntities -> Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, (List<Entity>)teleportedEntities)));
    }
}

