/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Optional;
import java.util.Set;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.config.WaystonesConfigData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WaystonePermissionManager {
    private static final Set<WaystoneVisibility> DEFAULT_VISIBILITIES = Set.of(WaystoneVisibility.SHARD_ONLY, WaystoneVisibility.ACTIVATION, WaystoneVisibility.WHITE_SHARESTONE, WaystoneVisibility.ORANGE_SHARESTONE, WaystoneVisibility.MAGENTA_SHARESTONE, WaystoneVisibility.LIGHT_BLUE_SHARESTONE, WaystoneVisibility.YELLOW_SHARESTONE, WaystoneVisibility.LIME_SHARESTONE, WaystoneVisibility.PINK_SHARESTONE, WaystoneVisibility.GRAY_SHARESTONE, WaystoneVisibility.LIGHT_GRAY_SHARESTONE, WaystoneVisibility.CYAN_SHARESTONE, WaystoneVisibility.PURPLE_SHARESTONE, WaystoneVisibility.BLUE_SHARESTONE, WaystoneVisibility.BROWN_SHARESTONE, WaystoneVisibility.GREEN_SHARESTONE, WaystoneVisibility.RED_SHARESTONE, WaystoneVisibility.BLACK_SHARESTONE);

    public static Optional<WaystoneEditError> mayEditWaystone(Player player, Level world, Waystone waystone) {
        if (WaystonePermissionManager.skipsPermissions(player)) {
            return Optional.empty();
        }
        WaystonesConfigData config = WaystonesConfig.getActive();
        if (waystone.hasOwner() && config.general.restrictedWaystones.contains((Object)WaystoneOrigin.PLAYER) && !waystone.isOwner(player)) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (waystone.getOrigin() != WaystoneOrigin.PLAYER && config.general.restrictedWaystones.contains((Object)waystone.getOrigin())) {
            return Optional.of(new WaystoneEditError.NotOwner());
        }
        if (!WaystonePermissionManager.isAllowedVisibility(waystone.getVisibility())) {
            return Optional.of(new WaystoneEditError.RequiresCreative());
        }
        return Optional.empty();
    }

    public static boolean isAllowedVisibility(WaystoneVisibility visibility) {
        WaystonesConfigData config = WaystonesConfig.getActive();
        return DEFAULT_VISIBILITIES.contains((Object)visibility) || config.general.allowedVisibilities.contains((Object)visibility);
    }

    public static boolean skipsPermissions(Player player) {
        return player.m_150110_().f_35937_;
    }

    public static boolean isEntityDeniedTeleports(Entity entity) {
        Set<ResourceLocation> deniedEntities = WaystonesConfig.getActive().teleports.entityDenyList;
        return deniedEntities.contains(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()));
    }
}

