/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.requirement.RequirementClientRegistry;
import net.blay09.mods.waystones.client.requirement.RequirementRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class WaystoneButton
extends Button {
    private final WarpRequirement warpRequirement;
    private final Waystone waystone;

    public WaystoneButton(int x, int y, Waystone waystone, WarpRequirement warpRequirement, Button.OnPress pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable, Button.f_252438_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.warpRequirement = warpRequirement;
        this.waystone = waystone;
        if (player == null) {
            this.f_93623_ = false;
        } else if (!warpRequirement.canAfford((Player)player) && !player.m_150110_().f_35937_) {
            this.f_93623_ = false;
        }
    }

    private static Component getWaystoneNameComponent(Waystone waystone) {
        MutableComponent effectiveName = waystone.getName().m_6881_();
        if (effectiveName.getString().isEmpty()) {
            effectiveName = Component.m_237115_((String)"gui.waystones.waystone_selection.unnamed_waystone");
        }
        if (waystone.getVisibility() == WaystoneVisibility.GLOBAL && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            effectiveName.m_130940_(ChatFormatting.YELLOW);
        }
        return effectiveName;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.waystone.getDimension() == player.m_9236_().m_46472_() && this.m_142518_()) {
            int distance = (int)player.m_20182_().m_82554_(this.waystone.getPos().m_252807_());
            String distanceStr = distance < 10000 && (font.m_92852_((FormattedText)this.m_6035_()) < 120 || distance < 1000) ? distance + "m" : String.format("%.1f", Float.valueOf((float)distance / 1000.0f)).replace(",0", "").replace(".0", "") + "km";
            int xOffset = this.m_5711_() - font.m_92895_(distanceStr);
            guiGraphics.m_280488_(font, distanceStr, this.m_252754_() + xOffset - 4, this.m_252907_() + 6, 0xFFFFFF);
        }
        this.renderRequirements(this.warpRequirement, guiGraphics, mouseX, mouseY, partialTicks);
    }

    private <T extends WarpRequirement> void renderRequirements(T requirement, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        RequirementRenderer<Class<?>> renderer = RequirementClientRegistry.getRenderer(requirement.getClass());
        if (renderer != null) {
            renderer.renderWidget((Player)player, (Class<?>)((Object)requirement), guiGraphics, mouseX, mouseY, partialTicks, this.m_252754_() + 2, this.m_252907_() + 2);
            if (this.f_93622_ && mouseX < this.m_252754_() + 2 + renderer.getWidth((Class<?>)((Object)requirement))) {
                ArrayList<Component> tooltip = new ArrayList<Component>();
                this.warpRequirement.appendHoverText((Player)player, tooltip);
                Optional optional = Optional.empty();
                Objects.requireNonNull(font);
                guiGraphics.m_280677_(font, tooltip, optional, mouseX, mouseY + 9);
            }
        }
    }
}

