/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WarpPlateMenu;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGeneratorManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase
implements Nameable {
    private final WeakHashMap<Entity, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private int lastAttunementSlot;
    private Component customName;

    public WarpPlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.warpPlate.get(), blockPos, blockState);
    }

    @Override
    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        super.initializeWaystone(world, player, origin);
        Waystone waystone = this.getWaystone();
        if (waystone instanceof MutableWaystone) {
            Component name = NameGeneratorManager.get(world.m_7654_()).getName((LevelAccessor)world, waystone, world.m_213780_(), NameGenerationMode.RANDOM_ONLY);
            ((MutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.m_7654_(), waystone);
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128405_("LastAttunementSlot", this.lastAttunementSlot);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        this.lastAttunementSlot = compound.m_128451_("LastAttunementSlot");
    }

    @Override
    public MenuProvider getMenuProvider() {
        return this.getSettingsMenuProvider();
    }

    @Override
    public MenuProvider getSettingsMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return WarpPlateBlockEntity.this.m_5446_();
            }

            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                return new WarpPlateMenu(i, WarpPlateBlockEntity.this, WarpPlateBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(WarpPlateBlockEntity.this.f_58858_);
            }
        };
    }

    public void onEntityCollision(Entity entity) {
        if (WaystonePermissionManager.isEntityDeniedTeleports(entity)) {
            return;
        }
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            Waystone targetWaystone = this.getTargetWaystone().orElse(InvalidWaystone.INSTANCE);
            WarpPlateBlock.WarpPlateStatus status = targetWaystone.isValid() ? WarpPlateBlock.WarpPlateStatus.ACTIVE : WarpPlateBlock.WarpPlateStatus.INVALID;
            Boolean canAfford = WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> it.setFromWaystone(this.getWaystone())).mapLeft(WaystoneTeleportContext::getRequirements).mapLeft(it -> {
                boolean bl;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.m_150110_().f_35937_ && !it.canAfford(player)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }).left().orElse(true);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(WarpPlateBlock.STATUS, (Comparable)((Object)(canAfford != false ? status : WarpPlateBlock.WarpPlateStatus.INVALID))), 3);
        }
    }

    private boolean isEntityOnWarpPlate(Entity entity) {
        return entity.m_20185_() >= (double)this.f_58858_.m_123341_() && entity.m_20185_() < (double)(this.f_58858_.m_123341_() + 1) && entity.m_20186_() >= (double)this.f_58858_.m_123342_() && entity.m_20186_() < (double)(this.f_58858_.m_123342_() + 1) && entity.m_20189_() >= (double)this.f_58858_.m_123343_() && entity.m_20189_() < (double)(this.f_58858_.m_123343_() + 1);
    }

    @Override
    public void serverTick() {
        AABB boundsAbove;
        List entities;
        super.serverTick();
        if (this.m_58900_().m_61143_(WarpPlateBlock.STATUS) != WarpPlateBlock.WarpPlateStatus.IDLE && (entities = this.f_58857_.m_6249_((Entity)null, boundsAbove = new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)), EntitySelector.f_20402_)).isEmpty()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.IDLE)), 3);
            this.ticksPassedPerEntity.clear();
        }
        int useTime = this.getWarpPlateUseTime();
        Iterator<Map.Entry<Entity, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity entity = entry.getKey();
            Integer ticksPassed = entry.getValue();
            if (!entity.m_6084_() || !this.isEntityOnWarpPlate(entity)) {
                iterator.remove();
                continue;
            }
            if (ticksPassed > useTime) {
                ItemStack targetAttunementStack = this.getTargetAttunementStack();
                Waystone targetWaystone = WaystonesAPI.getBoundWaystone(null, targetAttunementStack).orElse(null);
                if (targetWaystone != null && targetWaystone.isValid()) {
                    this.teleportToTarget(entity, targetWaystone, targetAttunementStack);
                }
                if (entity instanceof Player) {
                    if (targetWaystone == null) {
                        chatComponent = Component.m_237115_((String)"chat.waystones.warp_plate_has_no_target");
                        chatComponent.m_130940_(ChatFormatting.DARK_RED);
                        ((Player)entity).m_5661_((Component)chatComponent, true);
                    } else if (!targetWaystone.isValid()) {
                        chatComponent = Component.m_237115_((String)"chat.waystones.warp_plate_has_invalid_target");
                        chatComponent.m_130940_(ChatFormatting.DARK_RED);
                        ((Player)entity).m_5661_((Component)chatComponent, true);
                    }
                }
                iterator.remove();
                continue;
            }
            if (ticksPassed == -1) continue;
            entry.setValue(ticksPassed + 1);
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41720_() == Items.f_151049_) {
                useTimeMultiplier -= 0.016f * (float)itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() != Items.f_42518_) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.m_41613_();
        }
        int configuredUseTime = WaystonesConfig.getActive().general.warpPlateUseTime;
        return Mth.m_14045_((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToTarget(Entity entity, Waystone targetWaystone, ItemStack targetAttunementStack) {
        WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> {
            it.setFromWaystone(this.getWaystone());
            it.setWarpItem(targetAttunementStack);
        }).flatMap(WaystonesAPI::tryTeleport).ifRight(this.informRejectedTeleport(entity)).ifLeft(entities -> {
            block2: {
                block3: {
                    if (!targetAttunementStack.m_204117_(ModItemTags.SINGLE_USE_WARP_SHARDS)) break block2;
                    if (!(entity instanceof Player)) break block3;
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35937_) break block2;
                }
                targetAttunementStack.m_41774_(1);
            }
        }).ifLeft(entities -> entities.forEach(this::applyWarpPlateEffects)).left();
    }

    private Consumer<WaystoneTeleportError> informRejectedTeleport(Entity entityToInform) {
        return error -> {
            if (error.getTranslationKey() != null && entityToInform instanceof Player) {
                Player player = (Player)entityToInform;
                MutableComponent chatComponent = Component.m_237115_((String)error.getTranslationKey());
                chatComponent.m_130940_(ChatFormatting.DARK_RED);
                player.m_5661_((Component)chatComponent, true);
            }
        };
    }

    private void applyWarpPlateEffects(Entity entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41720_() == Items.f_42593_) {
                fireSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42675_) {
                poisonSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42532_) {
                blindSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42455_ || itemStack.m_41720_() == Items.f_42788_) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42415_) {
                potency = Math.min(4, potency + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42402_) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42542_) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() != Items.f_41951_) continue;
            witherSeconds += itemStack.m_41613_();
        }
        if (entity instanceof LivingEntity) {
            if (fireSeconds > 0) {
                entity.m_20254_(fireSeconds);
            }
            if (poisonSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19591_, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, witherSeconds * 20, potency));
            }
            for (ItemStack curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((LivingEntity)entity, curativeItem);
            }
        }
    }

    public ItemStack getTargetAttunementStack() {
        boolean shouldRoundRobin = false;
        boolean shouldPrioritizeSingleUseShards = false;
        ArrayList<ItemStack> attunedShards = new ArrayList<ItemStack>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_204117_(ModItemTags.WARP_SHARDS)) {
                Waystone waystoneAttunedTo = WaystonesAPI.getBoundWaystone(null, itemStack).orElse(null);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42692_) {
                shouldRoundRobin = true;
                continue;
            }
            if (itemStack.m_41720_() != Items.f_42591_) continue;
            shouldPrioritizeSingleUseShards = true;
        }
        if (shouldPrioritizeSingleUseShards && attunedShards.stream().anyMatch(stack -> stack.m_204117_(ModItemTags.SINGLE_USE_WARP_SHARDS))) {
            attunedShards.removeIf(stack -> !stack.m_204117_(ModItemTags.SINGLE_USE_WARP_SHARDS));
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            return shouldRoundRobin ? (ItemStack)attunedShards.get(this.lastAttunementSlot) : (ItemStack)attunedShards.get(this.random.nextInt(attunedShards.size()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<Waystone> getTargetWaystone() {
        return WaystonesAPI.getBoundWaystone(null, this.getTargetAttunementStack());
    }

    public void markEntityForCooldown(Entity entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"container.waystones.warp_plate");
    }

    @Override
    public boolean shouldPerformInitialAttunement() {
        return true;
    }
}

