/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.platform;

import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.impl.framework.message.MessageFramework;
import com.mrcrayfish.configured.network.message.MessageSessionData;
import com.mrcrayfish.configured.platform.services.IPlatformHelper;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_634;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public Environment getEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? Environment.CLIENT : Environment.DEDICATED_SERVER;
    }

    @Override
    public Path getGamePath() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public String getDefaultConfigPath() {
        return "defaultconfigs";
    }

    @Override
    public void sendSessionData(class_3222 player) {
        boolean developer = FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && Config.isDeveloperEnabled() && Config.getDevelopers().contains(player.method_5845());
        boolean lan = player.method_5682() != null && !player.method_5682().method_3816();
        MessageSessionData msg = new MessageSessionData(developer, lan);
        class_2540 buf = PacketByteBufs.create();
        MessageSessionData.encode(msg, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)MessageSessionData.ID, (class_2540)buf);
    }

    @Override
    public void sendFrameworkConfigToServer(class_2960 id, byte[] data) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        MessageFramework.Sync message = new MessageFramework.Sync(id, data);
        class_2540 buf = PacketByteBufs.create();
        MessageFramework.Sync.encode(message, buf);
        ClientPlayNetworking.send((class_2960)MessageFramework.Sync.ID, (class_2540)buf);
    }

    @Override
    public void sendFrameworkConfigRequest(class_2960 id) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        MessageFramework.Request message = new MessageFramework.Request(id);
        class_2540 buf = PacketByteBufs.create();
        MessageFramework.Request.encode(message, buf);
        ClientPlayNetworking.send((class_2960)MessageFramework.Request.ID, (class_2540)buf);
    }

    @Override
    public void sendFrameworkConfigResponse(class_3222 player, byte[] data) {
        if (!this.isModLoaded("framework")) {
            return;
        }
        MessageFramework.Response message = new MessageFramework.Response(data);
        class_2540 buf = PacketByteBufs.create();
        MessageFramework.Response.encode(message, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)MessageFramework.Response.ID, (class_2540)buf);
    }

    @Override
    public boolean isConnectionActive(class_634 listener) {
        return ClientPlayNetworking.getReceived().contains(MessageSessionData.ID);
    }
}

