/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.configured.api.Environment;
import com.mrcrayfish.configured.platform.Services;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;

public class Config {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[\\da-fA-F]{8}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{4}\\b-[\\da-fA-F]{12}$");
    private static CommentedFileConfig clientConfig;
    private static final ConfigSpec CLIENT_SPEC;
    private static CommentedFileConfig developerConfig;
    private static final ConfigSpec DEVELOPER_SPEC;

    public static void load() {
        Path configPath = Services.PLATFORM.getConfigPath();
        clientConfig = Config.createConfig(new File(configPath.toFile(), "configured-client.toml"));
        clientConfig.load();
        CLIENT_SPEC.correct((com.electronwill.nightconfig.core.Config)clientConfig);
        clientConfig.save();
        if (Services.PLATFORM.getEnvironment() == Environment.DEDICATED_SERVER) {
            developerConfig = Config.createConfig(new File(configPath.toFile(), "configured-developer.toml"));
            developerConfig.load();
            DEVELOPER_SPEC.correct((com.electronwill.nightconfig.core.Config)developerConfig);
            developerConfig.save();
        }
    }

    private static CommentedFileConfig createConfig(File configFile) {
        return (CommentedFileConfig)CommentedFileConfig.builder((File)configFile).autosave().sync().onFileNotFound((file, format) -> {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
            format.initEmptyFile(file);
            return false;
        }).build();
    }

    public static boolean isForceConfiguredMenu() {
        return (Boolean)clientConfig.get("forceConfiguredMenu");
    }

    public static boolean isIncludeFoldersInSearch() {
        return (Boolean)clientConfig.get("includeFoldersInSearch");
    }

    public static class_124 getChangedFormatting() {
        return (class_124)clientConfig.getEnumOrElse("changedFormatting", (Enum)class_124.field_1056, EnumGetMethod.NAME_IGNORECASE);
    }

    public static boolean isDeveloperEnabled() {
        return developerConfig != null && (Boolean)developerConfig.get("enabled") != false;
    }

    public static List<String> getDevelopers() {
        if (developerConfig != null) {
            return (List)developerConfig.getOrElse("developers", Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public static boolean shouldBroadcastLogs() {
        return developerConfig != null && (Boolean)developerConfig.get("broadcastLogs") != false;
    }

    static {
        CLIENT_SPEC = (ConfigSpec)class_156.method_656(() -> {
            ConfigSpec spec = new ConfigSpec();
            spec.define("forceConfiguredMenu", (Object)false);
            spec.define("includeFoldersInSearch", (Object)false);
            spec.defineRestrictedEnum("changedFormatting", (Enum)class_124.field_1056, (Collection)ImmutableSet.copyOf((Object[])class_124.values()), EnumGetMethod.NAME_IGNORECASE);
            return spec;
        });
        DEVELOPER_SPEC = (ConfigSpec)class_156.method_656(() -> {
            ConfigSpec spec = new ConfigSpec();
            spec.define("enabled", (Object)false);
            spec.defineList("developers", Collections.emptyList(), e -> {
                String s;
                return e instanceof String && UUID_PATTERN.matcher(s = (String)e).matches();
            });
            spec.define("broadcastLogs", (Object)true);
            return spec;
        });
    }
}

