/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.util.MapKeys;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class WorldGenEntry {
    private float[] chances;
    private boolean silktouch;
    private class_1799 block;
    private class_1799 deepSlateBlock;
    private int minY;
    private int maxY;
    private int colour;
    private Restriction restriction;
    private DistributionBase distribution;
    private Map<String, Set<LootDrop>> drops;
    private Map<class_1792, Set<LootDrop>> wildcardDrops;
    private Map<String, class_1799> dropsDisplay;

    public WorldGenEntry(class_1799 block, class_1799 deepSlateBlock, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        this.block = block;
        this.deepSlateBlock = deepSlateBlock;
        this.distribution = distribution;
        this.restriction = restriction;
        this.colour = -16777216;
        this.silktouch = silktouch;
        this.drops = new HashMap<String, Set<LootDrop>>();
        this.wildcardDrops = new HashMap<class_1792, Set<LootDrop>>();
        this.dropsDisplay = new HashMap<String, class_1799>();
        this.addDrops(drops);
        this.calcChances();
    }

    public WorldGenEntry(class_1799 block, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        this(block, null, distribution, restriction, silktouch, drops);
    }

    public WorldGenEntry(class_1799 block, DistributionBase distribution, LootDrop ... drops) {
        this(block, distribution, Restriction.OVERWORLD, false, drops);
    }

    public WorldGenEntry(class_1799 block, class_1799 deepSlateBlock, DistributionBase distribution, LootDrop ... drops) {
        this(block, deepSlateBlock, distribution, Restriction.OVERWORLD, false, drops);
    }

    public WorldGenEntry(class_1799 block, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        this(block, distribution, Restriction.OVERWORLD, silktouch, drops);
    }

    public WorldGenEntry(class_1799 block, class_1799 deepSlateBlock, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        this(block, deepSlateBlock, distribution, Restriction.OVERWORLD, silktouch, drops);
    }

    public WorldGenEntry(class_1799 block, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        this(block, distribution, restriction, false, drops);
    }

    public WorldGenEntry(class_1799 block, class_1799 deepSlateBlock, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        this(block, deepSlateBlock, distribution, restriction, false, drops);
    }

    public void addDrops(LootDrop ... drops) {
        for (LootDrop drop : drops) {
            String mapKey = MapKeys.getKey(drop.item);
            if (mapKey == null) continue;
            Set<LootDrop> dropSet = this.drops.get(mapKey);
            if (dropSet == null) {
                dropSet = new TreeSet<LootDrop>();
            }
            dropSet.add(drop);
            this.drops.put(mapKey, dropSet);
            if (this.dropsDisplay.containsKey(mapKey)) continue;
            class_1799 itemStack = drop.item.method_7972();
            itemStack.method_7939(Math.max(1, drop.minDrop));
            this.dropsDisplay.put(mapKey, itemStack);
        }
    }

    public void addDrops(Collection<LootDrop> drops) {
        this.addDrops(drops.toArray(new LootDrop[drops.size()]));
    }

    private void calcChances() {
        this.chances = new float[320];
        this.minY = 320;
        this.maxY = 0;
        int i = -1;
        for (float chance : this.distribution.getDistribution()) {
            if (++i == this.chances.length) break;
            int n = i;
            this.chances[n] = this.chances[n] + chance;
            if (!(this.chances[i] > 0.0f)) continue;
            if (this.minY > i) {
                this.minY = i;
            }
            if (i <= this.maxY) continue;
            this.maxY = i;
        }
        if (this.minY == 320) {
            this.minY = 0;
        }
        if (this.maxY == 0) {
            this.maxY = 319;
        }
        this.minY = this.minY < 160 ? 0 : 160;
        this.maxY = this.maxY <= 159 ? 159 : 287;
        this.minY -= 64;
    }

    public float[] getChances() {
        return Arrays.copyOfRange(this.chances, this.minY + 64, this.maxY + 1 + 64);
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean isSilkTouchNeeded() {
        return this.silktouch;
    }

    public int getColour() {
        return this.colour;
    }

    public List<class_1799> getDrops() {
        return new ArrayList<class_1799>(this.dropsDisplay.values());
    }

    public List<class_1799> getBlockAndDrops() {
        LinkedList<class_1799> list = new LinkedList<class_1799>();
        list.add(this.block);
        list.addAll(this.getDrops());
        return list;
    }

    public class_1799 getBlock() {
        return this.block;
    }

    public class_1799 getDeepSlateBlock() {
        return this.deepSlateBlock;
    }

    public List<String> getBiomeRestrictions() {
        return this.restriction.getBiomeRestrictions();
    }

    public String getDimension() {
        return this.restriction.getDimensionRestriction();
    }

    public List<LootDrop> getLootDrops(class_1799 itemStack) {
        String key = MapKeys.getKey(itemStack);
        ArrayList<LootDrop> list = new ArrayList<LootDrop>(this.drops.containsKey(key) ? (Collection)this.drops.get(key) : (Collection)this.wildcardDrops.get(itemStack.method_7909()));
        Collections.reverse(list);
        return list;
    }

    public float getAverageBlockCountPerChunk() {
        float sum = 0.0f;
        for (float chance : this.chances) {
            sum += chance;
        }
        return (float)Math.round(sum * (float)this.chances.length * 100.0f) / 100.0f;
    }

    public String toString() {
        return "WorldGenEntry: " + this.block.method_7954() + " - " + this.restriction.toString();
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public void merge(WorldGenEntry entry) {
        entry.drops.values().forEach(this::addDrops);
        this.distribution = DistributionHelpers.addDistribution(this.distribution, entry.distribution);
        this.calcChances();
    }

    public boolean hasDeepSlateVariant() {
        return this.deepSlateBlock != null && !this.deepSlateBlock.method_7960();
    }
}

