/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.common.SwingAnimation;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.joml.Vector3f;

public class PendulumAnimation
extends SwingAnimation {
    private static final class_5819 RAND = class_5819.method_43047();
    private final Supplier<Config> config;
    private float angularVel;
    private boolean hasDrag = true;
    private float lastImpulse;
    private int immunity = 0;

    public PendulumAnimation(Supplier<Config> config, Function<class_2680, Vector3f> axisGetter) {
        super(axisGetter);
        this.config = config;
        Config c = config.get();
        if (c != null) {
            this.angle = (RAND.method_43057() - 0.5f) * c.minAngle * 2.0f;
            this.angularVel = PendulumAnimation.capVelocity(c.k, 1000.0f, this.angle, c.minAngleEnergy);
        }
    }

    @Override
    public float getAngle(float partialTicks) {
        return 57.295776f * class_3532.method_16439((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    @Override
    public void reset() {
        this.angle = 0.0f;
        this.prevAngle = 0.0f;
        Config c = this.config.get();
        this.angularVel = PendulumAnimation.capVelocity(c.k, 1000.0f, this.angle, c.minAngleEnergy);
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        boolean hasAcc;
        this.prevAngle = this.angle;
        if (this.immunity > 0) {
            --this.immunity;
        }
        float dt = 0.05f;
        float energy = 0.0f;
        Config config = this.config.get();
        float k = config.k;
        boolean bl = hasAcc = this.lastImpulse != 0.0f;
        if (hasAcc) {
            this.hasDrag = true;
        }
        if (this.hasDrag) {
            energy = PendulumAnimation.calculateEnergy(k, this.angularVel, this.angle);
        }
        if (hasAcc && energy < config.maxAngleEnergy || this.lastImpulse * this.angularVel < 0.0f) {
            this.angularVel += this.lastImpulse;
            if (PendulumAnimation.calculateEnergy(k, this.angularVel, this.angle) > config.maxAngleEnergy) {
                this.angularVel = 0.1f * this.angularVel + 0.9f * PendulumAnimation.capVelocity(k, this.angularVel, this.angle, config.maxAngleEnergy);
            }
        }
        this.lastImpulse = 0.0f;
        float acc = -k * class_3532.method_15374((float)this.angle);
        if (this.hasDrag && !hasAcc) {
            if (energy > config.minAngleEnergy) {
                double damping = config.damping;
                float drag = (float)(damping * (double)this.angularVel);
                acc -= drag;
            } else {
                this.hasDrag = false;
            }
        }
        this.angularVel += dt * acc;
        this.angle += this.angularVel * dt;
    }

    public void addImpulse(double vel) {
        this.angularVel = (float)((double)this.angularVel + vel);
        this.hasDrag = true;
    }

    private static float capVelocity(float k, float currentVel, float angle, float targetEnergy) {
        float newVel = (float)Math.sqrt(Math.max(0.0f, 2.0f * (targetEnergy - k * (1.0f - class_3532.method_15362((float)angle)))));
        if (currentVel < 0.0f) {
            newVel *= -1.0f;
        }
        return newVel;
    }

    private static float calculateEnergy(float k, float vel, float radAngle) {
        return PendulumAnimation.angleToEnergy(k, radAngle) + 0.5f * (vel * vel);
    }

    private static float angleToEnergy(float k, float radAngle) {
        return k * (1.0f - class_3532.method_15362((float)radAngle));
    }

    @Override
    public boolean hitByEntity(class_1297 entity, class_2680 state, class_2338 pos) {
        boolean invertedAxis;
        class_243 signVel;
        double eRelVel;
        double eMass;
        if (this.immunity != 0) {
            return true;
        }
        class_243 eVel = entity.method_18798();
        if (eVel.method_1033() < 0.01) {
            return false;
        }
        Config config = ClientConfigs.HANGING_SIGN_CONFIG.get();
        if (config.considerEntityHitbox) {
            class_238 boundingBox = entity.method_5829();
            eMass = boundingBox.method_17939() * boundingBox.method_17940() * boundingBox.method_17941();
        } else {
            eMass = 1.0;
        }
        eMass *= (double)config.collisionInertia;
        eVel = eVel.method_1021((double)config.collisionForce);
        class_243 rotationAxis = new class_243(this.getRotationAxis(state));
        class_243 normalVec = rotationAxis.method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 entityPlaneVector = eVel.method_1020(eVel.method_18806(rotationAxis.method_18806(rotationAxis)));
        float radius = 1.0f;
        double magnitude = this.angularVel * radius;
        if (magnitude == 0.0) {
            magnitude = 1.0E-5;
        }
        if ((eRelVel = eVel.method_1026((signVel = new class_243(0.0, (double)class_3532.method_15374((float)this.angle), 0.0).method_1019(normalVec.method_1021((double)class_3532.method_15362((float)this.angle)))).method_1021(1000000.0).method_1029())) * eRelVel < 1.0E-4) {
            return false;
        }
        double entityForwardMotion = normalVec.field_1350 != 0.0 ? entityPlaneVector.field_1350 : entityPlaneVector.field_1352;
        double v = magnitude;
        double f = eMass * eMass + eMass;
        double g = 2.0 * eMass * (-v - eMass * eRelVel);
        double h = eMass * eMass * eRelVel * eRelVel - eMass * eRelVel * eRelVel + 2.0 * v * eMass * eRelVel;
        float delta = class_3532.method_15355((float)((float)(g * g - 4.0 * f * h)));
        double y1 = (-g + (double)delta) / (2.0 * f);
        double y2 = (-g - (double)delta) / (2.0 * f);
        double x1 = v + eMass * eRelVel - eMass * y1;
        double x2 = v + eMass * eRelVel - eMass * y2;
        double x = (double)class_3532.method_15379((float)((float)(x2 - magnitude))) < 1.0E-4 ? x1 : x2;
        float dW = (float)(x / (double)radius) - this.angularVel;
        if (eRelVel < 0.0 ^ entityForwardMotion < 0.0) {
            dW *= -1.0f;
        }
        boolean bl = invertedAxis = normalVec.field_1350 < 0.0 || normalVec.field_1352 < 0.0;
        if (invertedAxis) {
            dW *= -1.0f;
        }
        this.lastImpulse = dW;
        this.immunity = 10;
        entity.method_37908().method_45446(pos, state.method_26231().method_10598(), class_3419.field_15245, 0.75f, 1.5f, false);
        return true;
    }

    public static class Config {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)360.0f).fieldOf("min_angle").forGetter(c -> Float.valueOf(57.295776f * c.minAngle)), (App)Codec.floatRange((float)0.0f, (float)360.0f).fieldOf("max_angle").forGetter(c -> Float.valueOf(57.295776f * c.maxAngle)), (App)Codec.FLOAT.fieldOf("damping").forGetter(c -> Float.valueOf(c.damping)), (App)Codec.FLOAT.fieldOf("frequency").forGetter(c -> Float.valueOf(c.frequency)), (App)Codec.BOOL.fieldOf("collision_considers_entity_hitbox").forGetter(c -> c.considerEntityHitbox), (App)class_5699.field_34387.fieldOf("collision_inertia").forGetter(c -> Float.valueOf(c.collisionInertia)), (App)class_5699.field_34387.fieldOf("collision_force").forGetter(c -> Float.valueOf(c.collisionForce))).apply((Applicative)instance, Config::new));
        protected final float minAngle;
        protected final float maxAngle;
        protected final float damping;
        protected final float frequency;
        protected final float maxAngleEnergy;
        protected final float minAngleEnergy;
        protected final float k;
        protected final boolean considerEntityHitbox;
        protected final float collisionInertia;
        protected final float collisionForce;

        public Config(float minAngle, float maxAngle, float damping, float frequency, boolean hitbox, float mass, float force) {
            this.minAngle = minAngle * ((float)Math.PI / 180);
            this.maxAngle = maxAngle * ((float)Math.PI / 180);
            this.damping = damping;
            this.frequency = frequency;
            this.k = (float)Math.pow(Math.PI * 2 * (double)frequency, 2.0);
            this.maxAngleEnergy = PendulumAnimation.angleToEnergy(this.k, this.maxAngle);
            this.minAngleEnergy = PendulumAnimation.angleToEnergy(this.k, this.minAngle);
            this.considerEntityHitbox = hitbox;
            this.collisionInertia = mass;
            this.collisionForce = force;
        }

        public Config() {
            this(0.8f, 60.0f, 0.525f, 0.6f, true, 1.0f, 15.0f);
        }
    }
}

