/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5250;
import net.minecraft.class_5601;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFManager;

public class EMFUtils {
    private static final String MOD_ID_SHORT = "EMF";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EMF");

    @NotNull
    public static class_2960 res(String fullPath) {
        return new class_2960(fullPath);
    }

    @NotNull
    public static class_2960 res(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static EMFModelPartRoot getArrowOrNull(class_5601 layer) {
        if (EMF.testForForgeLoadingError()) {
            return null;
        }
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_630 part = modelPartData.method_32112(32, 32);
        class_630 possiblyEMF = EMFManager.getInstance().injectIntoModelRootGetter(layer, part);
        if (possiblyEMF instanceof EMFModelPartRoot) {
            return (EMFModelPartRoot)possiblyEMF;
        }
        return null;
    }

    public static void overrideMessage(String originalClass, String overriddenClassFromMod, boolean wasReverted) {
        LOGGER.warn("[EMF]: Entity model [" + originalClass + "] has been overridden by [" + overriddenClassFromMod + "] likely from a mod.");
        if (wasReverted) {
            LOGGER.warn("[EMF]: Prevent model overrides option is enabled! EMF will attempt to revert the new model [" + overriddenClassFromMod + "] back into the original model [" + originalClass + "]. THIS MAY HAVE UNINTENDED EFFECTS ON THE OTHER MOD, DISABLE THIS EMF SETTING IF IT CAUSES CRASHES!");
        }
    }

    public static void log(String message) {
        EMFUtils.log(message, false, false);
    }

    public static void log(String message, boolean inChat) {
        EMFUtils.log(message, inChat, false);
    }

    public static void log(String message, boolean inChat, boolean noPrefix) {
        if (inChat) {
            class_746 plyr = class_310.method_1551().field_1724;
            if (plyr != null) {
                plyr.method_7353(class_2561.method_30163((String)((noPrefix ? "" : "\u00a76[EMF]:\u00a7r ") + message)), false);
            } else {
                LOGGER.info((noPrefix ? "" : "[EMF]: ") + message);
            }
        } else {
            LOGGER.info((noPrefix ? "" : "[EMF]: ") + message);
        }
    }

    public static void chat(String message) {
        class_746 plyr = class_310.method_1551().field_1724;
        if (plyr != null) {
            plyr.method_7353((class_2561)class_5250.method_43477((class_7417)new class_2585(message)), false);
        }
    }

    public static void logWarn(String message) {
        EMFUtils.logWarn(message, false);
    }

    public static void logWarn(String message, boolean inChat) {
        if (inChat) {
            class_746 plyr = class_310.method_1551().field_1724;
            if (plyr != null) {
                plyr.method_7353(class_2561.method_30163((String)("\u00a76[EMF]\u00a7r: " + message)), false);
            } else {
                LOGGER.warn("[EMF]: " + message);
            }
        } else {
            LOGGER.warn("[EMF]: " + message);
        }
    }

    public static void logError(String message) {
        EMFUtils.logError(message, false);
    }

    public static void logError(String message, boolean inChat) {
        if (inChat) {
            class_746 plyr = class_310.method_1551().field_1724;
            if (plyr != null) {
                plyr.method_7353(class_2561.method_30163((String)("\u00a76[EMF]\u00a7r: " + message)), false);
            } else {
                LOGGER.error("[EMF]: " + message);
            }
        } else {
            LOGGER.error("[EMF]: " + message);
        }
    }

    @Nullable
    public static EMFPartData readModelPart(String pathOfJpm, String filePath) {
        pathOfJpm = Objects.requireNonNullElse(filePath, "optifine/cem/") + (String)pathOfJpm;
        if (!((String)pathOfJpm).endsWith(".jpm")) {
            pathOfJpm = (String)pathOfJpm + ".jpm";
        }
        try {
            Optional res = class_310.method_1551().method_1478().method_14486(EMFUtils.res((String)pathOfJpm));
            if (res.isEmpty()) {
                if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                    EMFUtils.log("jpm failed " + (String)pathOfJpm + " does not exist", false);
                }
                return null;
            }
            class_3298 jpmResource = (class_3298)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jpmResource.method_14482()));
            EMFPartData jpm = (EMFPartData)gson.fromJson((Reader)reader, EMFPartData.class);
            reader.close();
            return jpm;
        }
        catch (Exception e) {
            if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
                EMFUtils.log("jpm failed " + String.valueOf(e), false);
            }
            return null;
        }
    }

    public static String getIdUnique(Set<String> known, String desired) {
        while (known.contains(desired) || ((String)desired).isBlank()) {
            desired = (String)desired + "#";
        }
        return desired;
    }
}

