/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.automessage;

import forge.net.jason13.automessage.CommonClass;
import forge.net.jason13.automessage.CommonConstants;
import forge.net.jason13.automessage.capability.MessagingCapability;
import forge.net.jason13.automessage.capability.MessagingProvider;
import forge.net.jason13.automessage.config.Config;
import java.util.List;
import net.jason13.monolib.methods.BlockMethods;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="automessage")
public class ForgeExampleMod {
    public boolean debuggingEnabled = false;

    public ForgeExampleMod() {
        CommonConstants.LOG.info("Hello Forge world!");
        CommonClass.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onRegisterCapabilitiesEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "automessage-common.toml");
    }

    public void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        event.register(MessagingCapability.class);
    }

    @SubscribeEvent
    public void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("automessage", "properties"), (ICapabilityProvider)new MessagingProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerJoinLevelEvent(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onStartTick(TickEvent.ServerTickEvent event) {
        boolean flag_OperatingOncePerSecond;
        if (event.phase == TickEvent.Phase.START) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                boolean leftHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21206_());
                boolean rightHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21205_());
                if (this.debuggingEnabled || !leftHandCommand || !rightHandCommand) continue;
                this.debuggingEnabled = true;
                player.m_213846_((Component)Component.m_237113_((String)"debuggingEnabledAutoMessage"));
            }
        }
        boolean flag_StartOfTick = event.phase == TickEvent.Phase.START;
        boolean flag_SkipZeroTick = event.getServer().m_129921_() != 0;
        boolean bl = flag_OperatingOncePerSecond = event.getServer().m_129921_() % 20 == 0;
        if (flag_StartOfTick && flag_SkipZeroTick && flag_OperatingOncePerSecond) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                player.getCapability(MessagingProvider.PLAYER_MESSAGING_CAPABILITY).ifPresent(messaging -> {
                    messaging.incrementPlaytime();
                    for (int i = 0; i < ((List)Config.MESSAGES.get()).size(); ++i) {
                        int messageIndex = i;
                        boolean flag_PlaytimeHittingInterval = messaging.getPlaytime() % (Integer)((List)Config.INTERVALS.get()).get(messageIndex) == 0;
                        boolean flag_SoftLessThanLimit = messaging.getSoftCounts()[messageIndex] < (Integer)((List)Config.SOFT_LIMITS.get()).get(messageIndex);
                        boolean flag_SoftUnlimited = (Integer)((List)Config.SOFT_LIMITS.get()).get(messageIndex) == 0;
                        boolean flag_HardLessThanLimit = messaging.getHardCounts()[messageIndex] < (Integer)((List)Config.HARD_LIMITS.get()).get(messageIndex);
                        boolean flag_HardUnlimited = (Integer)((List)Config.HARD_LIMITS.get()).get(messageIndex) == 0;
                        boolean flag_Enabled = (Boolean)Config.AM_ENABLED.get();
                        if (!flag_PlaytimeHittingInterval || !flag_SoftLessThanLimit && !flag_SoftUnlimited || !flag_HardLessThanLimit && !flag_HardUnlimited || !flag_Enabled) continue;
                        player.m_213846_((Component)Component.m_237113_((String)((String)((List)Config.MESSAGES.get()).get(messageIndex))).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(((List)Config.LINKS.get()).get(messageIndex))))));
                        messaging.incrementSoftCountAtIndex(messageIndex);
                        messaging.incrementHardCountAtIndex(messageIndex);
                    }
                });
            }
        }
    }
}

