/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.jason13.automessage;

import fabric.net.jason13.automessage.CommonClass;
import fabric.net.jason13.automessage.CommonConstants;
import fabric.net.jason13.automessage.PlayerData;
import fabric.net.jason13.automessage.StateSaverAndLoader;
import fabric.net.jason13.automessage.config.Config;
import fabric.net.jason13.automessage.util.toml.Toml;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jason13.monolib.methods.BlockMethods;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricExampleMod
implements ModInitializer {
    public static boolean debuggingEnabled = false;
    public static List<Object> messages;
    public static List<Object> links;
    public static List<Object> intervals;
    public static List<Object> soft_limits;
    public static List<Object> hard_limits;
    public static boolean am_enabled;
    public static final class_2960 INITIAL_SYNC;
    public static final class_2960 PLAYTIME;
    public static final class_2960 SOFT_COUNTERS;
    public static final class_2960 HARD_COUNTERS;

    public void onInitialize() {
        CommonConstants.LOG.info("Hello Fabric world!");
        CommonClass.init();
        if (Config.configFound()) {
            Toml config = Config.readTomlFromFile();
            messages = config.getList("messages");
            links = config.getList("links");
            intervals = config.getList("intervals");
            soft_limits = config.getList("soft_limits");
            hard_limits = config.getList("hard_limits");
            am_enabled = config.getBoolean("am_enabled");
        } else {
            String CONFIG_DIRECTORY_PATH = "config";
            File CONFIG_DIRECTORY = new File("config");
            if (!CONFIG_DIRECTORY.isDirectory()) {
                CONFIG_DIRECTORY.mkdir();
            }
            Config.initialize();
            Toml config = Config.readTomlFromFile();
            messages = config.getList("messages");
            links = config.getList("links");
            intervals = config.getList("intervals");
            soft_limits = config.getList("soft_limits");
            hard_limits = config.getList("hard_limits");
            am_enabled = config.getBoolean("am_enabled");
        }
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PlayerData playerState = StateSaverAndLoader.getPlayerState((class_1309)handler.method_32311());
            class_2540 data = PacketByteBufs.create();
            Arrays.fill(playerState.soft_counters, 0);
            data.writeInt(playerState.playtime);
            data.method_10806(playerState.soft_counters);
            data.method_10806(playerState.hard_counters);
            server.execute(() -> ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_2960)INITIAL_SYNC, (class_2540)data));
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            boolean flag_OperatingOncePerSecond;
            boolean flag_SkipZeroTick = server.method_3780() != 0;
            boolean bl = flag_OperatingOncePerSecond = server.method_3780() % 20 == 0;
            if (flag_SkipZeroTick && flag_OperatingOncePerSecond && am_enabled) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    PlayerData playerState = StateSaverAndLoader.getPlayerState((class_1309)player);
                    ++playerState.playtime;
                    boolean leftHandCommand = BlockMethods.compareBlockToItemStack((class_2248)class_2246.field_10525, (class_1799)player.method_6079());
                    boolean rightHandCommand = BlockMethods.compareBlockToItemStack((class_2248)class_2246.field_10525, (class_1799)player.method_6047());
                    if (!debuggingEnabled && leftHandCommand && rightHandCommand) {
                        debuggingEnabled = true;
                        player.method_43496((class_2561)class_2561.method_43470((String)"debuggingEnabledAutoMessage"));
                    }
                    for (int i = 0; i < messages.size(); ++i) {
                        int messageIndex = i;
                        int getPlaytime = playerState.playtime;
                        int[] softCounts = playerState.soft_counters;
                        int[] hardCounts = playerState.hard_counters;
                        int softCountAtMessageIndex = softCounts[messageIndex];
                        int hardCountAtMessageIndex = hardCounts[messageIndex];
                        boolean flag_PlaytimeHittingInterval = getPlaytime % Integer.parseInt(intervals.get(messageIndex).toString()) == 0;
                        boolean flag_SoftLessThanLimit = softCountAtMessageIndex < Integer.parseInt(soft_limits.get(messageIndex).toString());
                        boolean flag_SoftUnlimited = Integer.parseInt(soft_limits.get(messageIndex).toString()) == 0;
                        boolean flag_HardLessThanLimit = hardCountAtMessageIndex < Integer.parseInt(hard_limits.get(messageIndex).toString());
                        boolean flag_HardUnlimited = Integer.parseInt(hard_limits.get(messageIndex).toString()) == 0;
                        boolean flag_Enabled = am_enabled;
                        if (!flag_PlaytimeHittingInterval || !flag_SoftLessThanLimit && !flag_SoftUnlimited || !flag_HardLessThanLimit && !flag_HardUnlimited || !flag_Enabled) continue;
                        player.method_43496((class_2561)class_2561.method_43470((String)messages.get(messageIndex).toString()).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, links.get(messageIndex).toString()))));
                        playerState.incrementSoftCounterAtIndex(messageIndex);
                        playerState.incrementHardCounterAtIndex(messageIndex);
                    }
                    class_2540 data = PacketByteBufs.create();
                    data.writeInt(playerState.playtime);
                    data.method_10806(playerState.soft_counters);
                    data.method_10806(playerState.hard_counters);
                    class_3222 playerEntity = server.method_3760().method_14602(player.method_5667());
                    server.execute(() -> {
                        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)PLAYTIME, (class_2540)data);
                        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)SOFT_COUNTERS, (class_2540)data);
                        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)HARD_COUNTERS, (class_2540)data);
                    });
                }
            }
        });
    }

    static {
        INITIAL_SYNC = new class_2960("automessage", "initial_sync");
        PLAYTIME = new class_2960("automessage", "playtime");
        SOFT_COUNTERS = new class_2960("automessage", "soft_counters");
        HARD_COUNTERS = new class_2960("automessage", "hard_counters");
    }
}

