/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.capability.SeismicWavesCapability;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.core.SeismicWave;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    private static final int MAX_SEISMIC_WAVES_PER_PLAYER = 16;

    public static EventResult onItemUseTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        if (entity.method_6118(class_1304.field_6174).method_7909() == ModRegistry.MUTANT_SKELETON_CHESTPLATE_ITEM.get() && useItem.method_7909() instanceof class_1753 && class_1753.method_7722((int)(useItem.method_7935() - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(class_1657 player, class_1799 stack, class_1937 level, MutableInt charge, boolean hasAmmo) {
        if (!(stack.method_7909() instanceof class_1753)) {
            return EventResult.PASS;
        }
        if (hasAmmo && player.method_6118(class_1304.field_6169).method_7909() == ModRegistry.MUTANT_SKELETON_SKULL_ITEM.get()) {
            float velocity = class_1753.method_7722((int)charge.getAsInt());
            if (!level.field_9236 && velocity >= 0.1f) {
                class_1799 itemstack = player.method_18808(stack);
                class_1744 arrowitem = (class_1744)(itemstack.method_7909() instanceof class_1744 ? itemstack.method_7909() : class_1802.field_8107);
                float[] shotPitches = PlayerEventsHandler.getShotPitches(level.field_9229, velocity);
                for (int i = 0; i < 2; ++i) {
                    class_1665 abstractarrow = arrowitem.method_7702(level, itemstack, (class_1309)player);
                    abstractarrow = CommonAbstractions.INSTANCE.getCustomArrowShotFromBow((class_1753)stack.method_7909(), abstractarrow);
                    abstractarrow.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, velocity * 3.0f, 1.5f);
                    PlayerEventsHandler.applyPowerEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyPunchEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyFlameEnchantment(abstractarrow, stack);
                    PlayerEventsHandler.applyPiercingEnchantment(abstractarrow, stack);
                    abstractarrow.field_7572 = class_1665.class_1666.field_7594;
                    level.method_8649((class_1297)abstractarrow);
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, shotPitches[i + 1]);
                }
            }
        }
        return EventResult.PASS;
    }

    private static float[] getShotPitches(class_5819 random, float velocity) {
        boolean flag = random.method_43056();
        return new float[]{1.0f, PlayerEventsHandler.getRandomShotPitch(flag, random, velocity), PlayerEventsHandler.getRandomShotPitch(!flag, random, velocity)};
    }

    private static float getRandomShotPitch(boolean p_150798_, class_5819 random, float velocity) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f * velocity;
    }

    public static void applyPowerEnchantment(class_1665 arrow, class_1799 stack) {
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        if (powerLevel > 0) {
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(class_1665 arrow, class_1799 stack) {
        int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
        if (punchLevel > 0) {
            arrow.method_7449(punchLevel);
        }
    }

    public static void applyFlameEnchantment(class_1665 arrow, class_1799 stack) {
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
            arrow.method_5639(100);
        }
    }

    public static void applyPiercingEnchantment(class_1665 arrow, class_1799 stack) {
        int pierceLevel = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)stack);
        if (pierceLevel > 0) {
            arrow.method_7451((byte)pierceLevel);
        }
    }

    public static void onPlayerTick$End(class_1657 player) {
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7356());
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7308());
        if (!player.method_37908().field_9236) {
            ModRegistry.SEISMIC_WAVES_CAPABILITY.maybeGet((Object)player).map(SeismicWavesCapability::seismicWaves).ifPresent(seismicWaves -> {
                while (seismicWaves.size() > 16) {
                    seismicWaves.poll();
                }
                if (!seismicWaves.isEmpty()) {
                    PlayerEventsHandler.handleSeismicWave(player, (SeismicWave)((Object)((Object)seismicWaves.poll())));
                }
            });
        }
    }

    private static void handleSeismicWave(class_1657 player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.method_37908(), (class_1297)player);
        class_238 box = new class_238((double)seismicWave.method_10263(), (double)seismicWave.method_10264() + 1.0, (double)seismicWave.method_10260(), (double)seismicWave.method_10263() + 1.0, (double)seismicWave.method_10264() + 2.0, (double)seismicWave.method_10260() + 1.0);
        for (class_1309 livingEntity : player.method_37908().method_18467(class_1309.class, box)) {
            if (livingEntity == player || player.method_5854() == livingEntity) continue;
            livingEntity.method_5643(DamageSourcesHelper.source((class_4538)player.method_37908(), ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (class_1297)player), (float)(6 + player.method_6051().method_43048(3)));
        }
    }

    private static void playShoulderEntitySound(class_1657 player, @Nullable class_2487 compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.method_10545("Silent")) break block2;
                if (compoundNBT.method_10577("Silent")) break block3;
            }
            class_1299.method_5898((String)compoundNBT.method_10558("id")).filter(((class_1299)ModRegistry.CREEPER_MINION_ENTITY_TYPE.get())::equals).ifPresent(entityType -> {
                if (player.method_37908().field_9229.method_43048(500) == 0) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.get(), player.method_5634(), 1.0f, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static EventResult onItemToss(class_1542 entityItem, class_1657 player) {
        if (!player.method_37908().field_9236) {
            boolean isHand;
            class_1799 stack = entityItem.method_6983();
            boolean bl = isHand = stack.method_7909() == ModRegistry.ENDERSOUL_HAND_ITEM.get() && stack.method_7986();
            if (stack.method_7909() == class_1802.field_8449 || isHand) {
                int count = 0;
                for (EndersoulFragment orb : player.method_37908().method_18467(EndersoulFragment.class, player.method_5829().method_1014(8.0))) {
                    if (orb.getOwner() != player) continue;
                    ++count;
                    orb.method_31472();
                }
                if (count > 0) {
                    EntityUtil.sendParticlePacket((class_1297)player, (class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.get(), 256);
                    int addDmg = count * 60;
                    if (isHand) {
                        int dmg = stack.method_7919() - addDmg;
                        stack.method_7974(Math.max(dmg, 0));
                    } else {
                        class_1799 newStack = new class_1799((class_1935)ModRegistry.ENDERSOUL_HAND_ITEM.get());
                        newStack.method_7974(((class_1792)ModRegistry.ENDERSOUL_HAND_ITEM.get()).method_7841() - addDmg);
                        entityItem.method_6979(newStack);
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

