/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.mojang.logging.LogUtils;
import com.starfish_studios.naturalist.common.entity.core.Catchable;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1367;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Moth
extends class_1429
implements GeoEntity,
class_1432,
Catchable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(Moth.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FROM_HAND = class_2945.method_12791(Moth.class, (class_2941)class_2943.field_13323);

    public Moth(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f);
    }

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    protected class_1408 method_5965(final class_1937 pLevel) {
        class_1407 navigation = new class_1407((class_1308)this, pLevel){

            public boolean method_6333(class_2338 pPos) {
                return !pLevel.method_8320(pPos.method_10074()).method_26215();
            }
        };
        navigation.method_6332(false);
        navigation.method_6354(false);
        navigation.method_6331(true);
        return navigation;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT, (Object)1);
        this.field_6011.method_12784(FROM_HAND, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant().getId());
        compound.method_10556("FromHand", this.fromHand());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(Variant.BY_ID[compound.method_10550("Variant")]);
        this.setFromHand(compound.method_10577("FromHand"));
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.field_6011.method_12789(DATA_VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getId());
    }

    @Override
    public boolean fromHand() {
        return (Boolean)this.field_6011.method_12789(FROM_HAND);
    }

    @Override
    public void setFromHand(boolean fromHand) {
        this.field_6011.method_12778(FROM_HAND, (Object)fromHand);
    }

    public float method_6144(class_2338 pPos, class_4538 pLevel) {
        return pLevel.method_8320(pPos).method_26215() ? 10.0f : 0.0f;
    }

    public boolean method_6481(class_1799 pStack) {
        return pStack.method_31573(class_3489.field_20344);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8106((class_6862)class_3489.field_20344), false));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new MothAttractionGoal(this, 1.0, 16, 16));
        this.field_6201.method_6277(6, (class_1352)new FlyingWanderGoal((class_1314)this));
        this.field_6201.method_6277(7, (class_1352)new class_1347((class_1308)this));
    }

    @javax.annotation.Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        boolean bl = false;
        if (reason == class_3730.field_16473) {
            return spawnData;
        }
        class_5819 randomSource = level.method_8409();
        if (spawnData instanceof MothGroupData) {
            if (((MothGroupData)((Object)spawnData)).method_22432() >= 2) {
                bl = true;
            }
        } else {
            spawnData = new MothGroupData(Variant.getCommonSpawnVariant(randomSource), Variant.getCommonSpawnVariant(randomSource));
        }
        this.setVariant(((MothGroupData)((Object)spawnData)).getVariant(randomSource));
        if (bl) {
            this.method_5614(-24000);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return Catchable.catchAnimal(player, hand, this, false).orElse(super.method_5992(player, hand));
    }

    @Override
    public void saveToHandTag(class_1799 stack) {
        Catchable.saveDefaultDataToHandTag((class_1308)this, stack);
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10569("Variant", this.getVariant().getId());
        compoundTag.method_10569("Age", this.method_5618());
    }

    @Override
    public void loadFromHandTag(class_2487 tag) {
        Catchable.loadDefaultDataFromHandTag((class_1308)this, tag);
        int i = tag.method_10550("Variant");
        if (i >= 0 && i < Variant.BY_ID.length) {
            this.setVariant(Variant.BY_ID[i]);
        } else {
            LOGGER.error("Invalid variant: {}", (Object)i);
        }
        if (tag.method_10545("Age")) {
            this.method_5614(tag.method_10550("Age"));
        }
        if (tag.method_10545("HuntingCooldown")) {
            this.method_18868().method_24525(class_4140.field_30246, (Object)true, tag.method_10537("HuntingCooldown"));
        }
    }

    public boolean method_17326() {
        return super.method_17326() || this.fromHand();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.fromHand() && !this.method_16914();
    }

    @Override
    public class_1799 getCaughtItemStack() {
        return null;
    }

    @Override
    public class_3414 getPickupSound() {
        return null;
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_5773() {
        super.method_5773();
    }

    @javax.annotation.Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)NaturalistEntityTypes.CATERPILLAR.get().method_5883((class_1937)level);
    }

    public boolean method_6109() {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Moth> PlayState predicate(AnimationState<E> event) {
        if (this.method_6581()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("butterfly.fly"));
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public boolean method_5776() {
        return this.method_6581() && this.field_6012 % class_3532.method_15386((float)1.4959966f) == 0;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected float method_18394(class_4050 pPose, class_4048 pSize) {
        return pSize.field_18068 * 0.5f;
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        return false;
    }

    protected void method_5623(double pY, boolean pOnGround, class_2680 pState, class_2338 pPos) {
    }

    protected void method_5712(class_2338 pPos, class_2680 pState) {
    }

    public static enum Variant {
        POLYPHEMUS(0, "polyphemus", true),
        DOMESTIC_SILK(1, "domestic_silk", true);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
            this.common = bl;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getTypeById(int id) {
            for (Variant type : Variant.values()) {
                if (type.id != id) continue;
                return type;
            }
            return POLYPHEMUS;
        }

        public static Variant getCommonSpawnVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, true);
        }

        private static Variant getSpawnVariant(class_5819 random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(BY_ID).filter(variant -> variant.common == common).toArray(Variant[]::new);
            return (Variant)((Object)class_156.method_27173((Object[])variants, (class_5819)random));
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    static class MothAttractionGoal
    extends class_1367 {
        protected int ticksWaited;
        private final Moth moth;

        public MothAttractionGoal(Moth pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((class_1314)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.moth = pMob;
        }

        protected boolean method_6296(class_4538 pLevel, class_2338 pPos) {
            return pLevel.method_8320(pPos).method_26164(NaturalistTags.BlockTags.MOTHS_ATTRACTED_TO);
        }

        public void method_6268() {
            if (this.method_6295()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
            super.method_6268();
        }

        protected void onReachedTarget() {
        }

        public boolean method_6264() {
            return super.method_6264();
        }

        public boolean method_6266() {
            return super.method_6266();
        }

        public void method_6269() {
            this.ticksWaited = 0;
            super.method_6269();
        }
    }

    public static class MothGroupData
    extends class_1296.class_4697 {
        public final Variant[] types;

        public MothGroupData(Variant ... variants) {
            super(false);
            this.types = variants;
        }

        public Variant getVariant(class_5819 random) {
            return this.types[random.method_43048(this.types.length)];
        }
    }
}

