/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.enderpack.core.block;

import forge.net.jason13.enderpack.core.GlobalForgeRegistry;
import forge.net.jason13.enderpack.core.block.entity.EnderPackBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderPackBlock
extends BaseEntityBlock {
    static final double ONE_SIXTEENTH = 0.0625;
    static final double startX = 0.1875;
    static final double startY = 0.0;
    static final double startZ = 0.2578125;
    static final double endX = 0.8125;
    static final double endY = 0.71875;
    static final double endZ = 0.625;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.2578125, (double)0.8125, (double)0.71875, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, EnderPackBlock.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public EnderPackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)GlobalForgeRegistry.ENDERPACK.get());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pPlayer.m_6047_()) {
            pPlayer.m_5893_((MenuProvider)new SimpleMenuProvider((p_53124_, p_53125_, p_53126_) -> ChestMenu.m_39237_((int)p_53124_, (Inventory)p_53125_, (Container)pPlayer.m_36327_()), (Component)Component.m_237115_((String)"container.enderpack")));
            return InteractionResult.SUCCESS;
        }
        pLevel.m_46961_(pPos, false);
        pLevel.m_7967_((Entity)new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), new ItemStack((ItemLike)GlobalForgeRegistry.ENDERPACK.get())));
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        for (int i = 0; i < 3; ++i) {
            int posMultiplier = pRandom.m_188503_(2) * 2 - 1;
            int speedMultiplier = pRandom.m_188503_(2) * 2 - 1;
            double xPos = (double)pPos.m_123341_() + 0.5 + 0.25 * (double)posMultiplier;
            double yPos = (float)pPos.m_123342_() + pRandom.m_188501_();
            double zPos = (double)pPos.m_123343_() + 0.5 + 0.25 * (double)speedMultiplier;
            double xSpeed = pRandom.m_188501_() * (float)posMultiplier;
            double ySpeed = ((double)pRandom.m_188501_() - 0.5) * 0.125;
            double zSpeed = pRandom.m_188501_() * (float)speedMultiplier;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123760_, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EnderPackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return EnderPackBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)GlobalForgeRegistry.ENDER_PACK_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (EnderPackBlockEntity)be));
    }
}

