/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.enderpack;

import forge.net.jason13.enderpack.CommonClient;
import forge.net.jason13.enderpack.core.GlobalForgeRegistry;
import forge.net.jason13.enderpack.core.block.EnderPackBlockEntityRenderer;
import forge.net.jason13.enderpack.core.network.ModMessages;
import forge.net.jason13.enderpack.core.network.packet.OpenEnderChestC2SPacket;
import forge.net.jason13.enderpack.core.player.CommonBagModel;
import forge.net.jason13.enderpack.core.player.EnderPackEntityLayer;
import forge.net.jason13.enderpack.core.util.EnderPackKeyBinding;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ForgeExampleModClient {
    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }

    private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }

    @Mod.EventBusSubscriber(modid="enderpack", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (EnderPackKeyBinding.ENDER_PACK_KEY_MAPPING.m_90859_()) {
                ModMessages.sendToServer(new OpenEnderChestC2SPacket());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="enderpack", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)GlobalForgeRegistry.ENDER_PACK_BLOCK_ENTITY.get(), EnderPackBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(EnderPackKeyBinding.ENDER_PACK_KEY_MAPPING);
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CommonClient.ENDERPACK_LAYER, CommonBagModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void construct(EntityRenderersEvent.AddLayers event) {
            ForgeExampleModClient.addLayerToPlayerSkin(event, "default", EnderPackEntityLayer::new);
            ForgeExampleModClient.addLayerToPlayerSkin(event, "slim", EnderPackEntityLayer::new);
        }
    }
}

