/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BuiltinAnimation;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataCapturedMobInstance;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_52;
import net.minecraft.class_6880;
import net.minecraft.class_8567;

public final class DataDefinedCatchableMob
implements ICatchableMob {
    public static final Codec<DataDefinedCatchableMob> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.listOf().fieldOf("owners").forGetter(p -> p.owners), (App)Codec.FLOAT.fieldOf("width_increment").forGetter(p -> Float.valueOf(p.widthIncrement)), (App)Codec.FLOAT.fieldOf("height_increment").forGetter(p -> Float.valueOf(p.heightIncrement)), (App)StrOpt.of((Codec)Codec.intRange((int)0, (int)15), (String)"light_level", (Object)0).forGetter(p -> p.lightLevel), (App)StrOpt.of(CaptureSettings.CODEC, (String)"allowed_in").forGetter(p -> p.captureSettings), (App)StrOpt.of((Codec)Codec.INT, (String)"fish_index", (Object)0).forGetter(p -> p.fishIndex), (App)StrOpt.of(BuiltinAnimation.Type.CODEC, (String)"animation", (Object)((Object)BuiltinAnimation.Type.NONE)).forGetter(b -> b.builtinAnimation), (App)StrOpt.of(TickMode.CODEC, (String)"tick_mode", (Object)((Object)TickMode.NONE)).forGetter(p -> p.tickMode), (App)StrOpt.of((Codec)class_2960.field_25139, (String)"force_fluid").forGetter(p -> p.forceFluidID), (App)StrOpt.of(LootParam.CODEC, (String)"loot").forGetter(p -> p.loot)).apply((Applicative)instance, DataDefinedCatchableMob::new));
    private final List<class_2960> owners;
    final float widthIncrement;
    final float heightIncrement;
    final int lightLevel;
    final Optional<CaptureSettings> captureSettings;
    final int fishIndex;
    final BuiltinAnimation.Type builtinAnimation;
    final TickMode tickMode;
    final Optional<class_2960> forceFluidID;
    final Optional<LootParam> loot;
    private Optional<class_6880<SoftFluid>> forceFluid = null;

    public DataDefinedCatchableMob(List<class_2960> owners, float widthIncrement, float heightIncrement, int lightLevel, Optional<CaptureSettings> captureSettings, int fishIndex, BuiltinAnimation.Type builtinAnimation, TickMode tickMode, Optional<class_2960> forceFluidID, Optional<LootParam> loot) {
        this.widthIncrement = widthIncrement;
        this.heightIncrement = heightIncrement;
        this.lightLevel = lightLevel;
        this.captureSettings = captureSettings;
        this.fishIndex = fishIndex;
        this.builtinAnimation = builtinAnimation;
        this.forceFluidID = forceFluidID;
        this.loot = loot;
        this.tickMode = tickMode;
        this.owners = owners;
    }

    List<class_2960> getOwners() {
        return this.owners;
    }

    @Override
    public <T extends class_1297> CapturedMobInstance<T> createCapturedMobInstance(T self, float containerWidth, float containerHeight) {
        return new DataCapturedMobInstance<T>(self, containerWidth, containerHeight, this);
    }

    @Override
    public boolean canBeCaughtWithItem(class_1297 entity, class_1792 item, class_1657 player) {
        return this.captureSettings.map(settings -> settings.canCapture(entity, item)).orElseGet(() -> ICatchableMob.super.canBeCaughtWithItem(entity, item, player));
    }

    @Override
    public int getLightLevel(class_1937 world, class_2338 pos) {
        return this.lightLevel;
    }

    @Override
    public boolean shouldHover(class_1297 self, boolean waterlogged) {
        BuiltinAnimation.Type cat = this.builtinAnimation;
        if (cat.isLand()) {
            return false;
        }
        return cat.isFlying() || ICatchableMob.super.shouldHover(self, waterlogged);
    }

    @Override
    public Optional<class_6880<SoftFluid>> shouldRenderWithFluid() {
        if (this.forceFluid == null) {
            this.forceFluid = this.forceFluidID.flatMap(SoftFluidRegistry::getOptionalHolder);
        }
        return this.forceFluid;
    }

    @Override
    public int getFishTextureIndex() {
        return this.fishIndex;
    }

    @Override
    public float getHitBoxWidthIncrement(class_1297 entity) {
        return this.widthIncrement;
    }

    @Override
    public float getHitBoxHeightIncrement(class_1297 entity) {
        return this.heightIncrement;
    }

    static enum TickMode implements class_3542
    {
        NONE,
        SERVER,
        CLIENT,
        BOTH;

        public static final Codec<TickMode> CODEC;

        boolean isValid(class_1937 level) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> false;
                case CLIENT -> level.field_9236;
                case SERVER -> {
                    if (!level.field_9236) {
                        yield true;
                    }
                    yield false;
                }
                case BOTH -> true;
            };
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(TickMode::values);
        }
    }

    protected record CaptureSettings(CatchMode jarMode, CatchMode cageMode) {
        private static final Codec<CaptureSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CatchMode.CODEC.fieldOf("jar").forGetter(CaptureSettings::jarMode), (App)CatchMode.CODEC.fieldOf("cage").forGetter(CaptureSettings::cageMode)).apply((Applicative)instance, CaptureSettings::new));

        public boolean canCapture(class_1297 entity, class_1792 item) {
            class_1309 le;
            if (item instanceof JarItem) {
                class_1309 le2;
                return this.jarMode.on && (!this.jarMode.onlyBaby || !(entity instanceof class_1309) || (le2 = (class_1309)entity).method_6109());
            }
            return this.cageMode.on && (!this.cageMode.onlyBaby || !(entity instanceof class_1309) || (le = (class_1309)entity).method_6109());
        }
    }

    protected record LootParam(class_2960 tableId, float chance) {
        private static final Codec<LootParam> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("loot_table").forGetter(LootParam::tableId), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(LootParam::chance)).apply((Applicative)instance, LootParam::new));

        public void tryDropping(class_3218 serverLevel, class_2338 pos, class_1297 entity) {
            if (serverLevel.field_9229.method_43057() < this.chance) {
                class_52 lootTable = serverLevel.method_8503().method_3857().getLootTable(this.tableId);
                class_8567.class_8568 builder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1224, (Object)serverLevel.method_8320(pos)).method_51877(class_181.field_1226, (Object)entity);
                ObjectArrayList l = lootTable.method_51878(builder.method_51875(class_173.field_16235));
                for (class_1799 o : l) {
                    entity.method_5775(o);
                }
            }
        }
    }

    protected record CatchMode(boolean on, boolean onlyBaby) {
        private static final Codec<CatchMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("allow").forGetter(CatchMode::on), (App)StrOpt.of((Codec)Codec.BOOL, (String)"only_baby", (Object)false).forGetter(CatchMode::onlyBaby)).apply((Applicative)instance, CatchMode::new));
    }
}

