/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.values.BooleanValue;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.ServerCreatorBanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModuleList {
    private List<IModule> modules = new ArrayList<IModule>();
    private Map<String, BooleanValue> enableValues = new HashMap<String, BooleanValue>();
    public final ServerCreatorBanner serverCreatorBanner = new ServerCreatorBanner();
    public final PublicServerList publicServerList = new PublicServerList();

    public List<IModule> getEnabled() {
        return this.modules.stream().filter(IModule::isEnabled).collect(Collectors.toList());
    }

    public BooleanValue getEnabledValue(String moduleId) {
        return this.enableValues.get(moduleId);
    }

    public void initialize() {
        this.modules.add(this.serverCreatorBanner);
        this.modules.add(this.publicServerList);
    }

    public void reload() {
        ModRef.LOGGER.info("Reloading Configs");
        for (IModule module : this.modules) {
            BooleanValue enabled = this.enableValues.get(module.getId());
            if (module.isEnabled() == ((Boolean)enabled.getValue()).booleanValue()) continue;
            module.setEnabled((Boolean)enabled.getValue());
        }
    }

    public List<IModule> getAll() {
        return Collections.unmodifiableList(this.modules);
    }

    public void putEnabledValue(String id, BooleanValue value) {
        this.enableValues.put(id, value);
    }
}

