/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment;

import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3486;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.BiomeEnvironment;
import team.creative.ambientsounds.environment.EntityEnvironment;
import team.creative.ambientsounds.environment.TerrainEnvironment;
import team.creative.ambientsounds.mod.SereneSeasonsCompat;
import team.creative.creativecore.client.render.text.DebugTextRenderer;

public class AmbientEnvironment {
    public AmbientDimension dimension;
    public boolean muted = false;
    public boolean night;
    public double sunAngle;
    public double dayTimeHour;
    public double rainSurfaceVolume;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public BiomeEnvironment biome = new BiomeEnvironment();
    public TerrainEnvironment terrain = new TerrainEnvironment();
    public EntityEnvironment entity = new EntityEnvironment();
    public AmbientVolume biomeVolume = AmbientVolume.SILENT;
    public HashMap<String, AmbientVolume> biomeTypeVolumes = new HashMap();
    public double absoluteHeight;
    public double relativeHeight;
    public double relativeMinHeight;
    public double relativeMaxHeight;
    public double underwater;
    public double temperature;

    public boolean isRainAudibleAtSurface() {
        return this.rainSurfaceVolume > 0.0;
    }

    public void analyzeFast(AmbientDimension dimension, class_1657 player, class_1937 level, float deltaTime) {
        this.dimension = dimension;
        this.raining = level.method_8520(player.method_24515().method_10084());
        this.snowing = ((class_1959)level.method_23753(player.method_24515()).comp_349()).method_33599(player.method_24515()) && level.method_8419();
        this.thundering = level.method_8546() && !this.snowing;
        this.absoluteHeight = player.method_23320();
        this.relativeHeight = this.absoluteHeight - this.terrain.averageHeight;
        this.relativeMinHeight = this.absoluteHeight - (double)this.terrain.minHeight;
        this.relativeMaxHeight = this.absoluteHeight - (double)this.terrain.maxHeight;
        this.temperature = SereneSeasonsCompat.getTemperature(player);
        this.analyzeUnderwater(player, level);
        this.analyzeTime(level, deltaTime);
        this.entity.analyzeFast(dimension, player, level, deltaTime);
    }

    public void analyzeTime(class_1937 level, float deltaTime) {
        this.sunAngle = (Math.toDegrees(level.method_8442(deltaTime)) - 180.0) % 360.0;
        if (this.sunAngle < 0.0) {
            this.sunAngle += 360.0;
        }
        this.night = this.sunAngle < 90.0 || this.sunAngle > 270.0;
        this.dayTimeHour = this.sunAngle * 0.06666666666666667;
    }

    public void analyzeUnderwater(class_1657 player, class_1937 level) {
        int depth = 0;
        if (player.method_5777(class_3486.field_15517)) {
            class_2338 blockpos = class_2338.method_49638((class_2374)player.method_33571());
            while (level.method_8316(blockpos).method_15767(class_3486.field_15517)) {
                ++depth;
                blockpos = blockpos.method_10084();
            }
        }
        this.underwater = depth;
    }

    public void analyzeSlow(AmbientDimension dimension, AmbientEngine engine, class_1657 player, class_1937 level, float deltaTime) {
        this.terrain.analyze(engine, dimension, player, level);
        this.biome = new BiomeEnvironment(engine, player, level, this.biomeVolume);
        this.rainSurfaceVolume = this.biome.rainVolume();
    }

    public void collectLevelDetails(DebugTextRenderer text) {
        text.detail("dimension", (Object)this.dimension);
        text.detail("night", (Object)this.night);
        text.detail("rain", (Object)this.raining);
        text.detail("rainSurfaceVolume", (Object)this.rainSurfaceVolume);
        text.detail("snow", (Object)this.snowing);
        text.detail("storm", (Object)this.thundering);
        text.detail("sun", (Object)this.sunAngle);
        text.detail("time", (Object)this.dayTimeHour);
    }

    public void collectPlayerDetails(DebugTextRenderer text, class_1657 player) {
        text.detail("underwater", (Object)this.underwater);
        text.detail("temp", (Object)this.temperature);
        text.detail("height", (Object)("r:" + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeHeight) + ",a:" + DebugTextRenderer.DECIMAL_FORMAT.format(this.terrain.averageHeight) + " (" + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeMinHeight) + "," + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeMaxHeight) + ")"));
    }

    public void collectTerrainDetails(DebugTextRenderer text) {
        this.terrain.collectDetails(text);
    }

    public void collectBiomeDetails(DebugTextRenderer text) {
        text.detail("b-volume", (Object)this.biomeVolume);
        this.biome.collectDetails(text);
    }

    public void reload() {
        this.terrain.scanner = null;
    }
}

