/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.engine;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.ambientsounds.region.AmbientRegion;
import team.creative.ambientsounds.sound.AmbientSound;
import team.creative.ambientsounds.sound.AmbientSoundCategory;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientTickHandler {
    private static class_310 mc = class_310.method_1551();
    public AmbientSoundEngine soundEngine;
    public AmbientEnvironment environment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private boolean shouldReload = false;

    public void scheduleReload() {
        this.shouldReload = true;
    }

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        holder.registerValue("general", (Object)AmbientSounds.CONFIG);
        if (this.engine == null) {
            return;
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field dimensionField = ReflectionHelper.findField(AmbientDimension.class, (String)"volumeSetting");
        for (AmbientDimension dimension : this.engine.dimensions.values()) {
            dimensions.registerField(dimension.name, dimensionField, (Object)dimension);
        }
        ConfigHolderDynamic regions = holder.registerFolder("regions");
        Field regionField = ReflectionHelper.findField(AmbientRegion.class, (String)"volumeSetting");
        Field soundField = ReflectionHelper.findField(AmbientSound.class, (String)"volumeSetting");
        for (Map.Entry<String, AmbientRegion> pair : this.engine.allRegions.entrySet()) {
            ConfigHolderDynamic region = regions.registerFolder(pair.getKey().replace(".", "_"));
            region.registerField("overall", regionField, (Object)pair.getValue());
            if (pair.getValue().loadedSounds == null) continue;
            for (AmbientSound sound : pair.getValue().loadedSounds.values()) {
                region.registerField(sound.name, soundField, (Object)sound);
            }
        }
        ConfigHolderDynamic categories = holder.registerFolder("categories");
        Field categoryField = ReflectionHelper.findField(AmbientSoundCategory.class, (String)"volumeSetting");
        for (AmbientSoundCategory cat : this.engine.sortedSoundCategories) {
            this.createSoundCategoryConfiguration(categories, cat, categoryField);
        }
        holder.registerField("fade-volume", ReflectionHelper.findField(AmbientEngine.class, (String)"fadeVolume"), (Object)this.engine);
        holder.registerField("fade-pitch", ReflectionHelper.findField(AmbientEngine.class, (String)"fadePitch"), (Object)this.engine);
        holder.registerField("silent-dimensions", ReflectionHelper.findField(AmbientEngine.class, (String)"silentDimensions"), (Object)this.engine);
        CreativeCore.CONFIG_HANDLER.load("ambientsounds", Side.CLIENT);
    }

    private void createSoundCategoryConfiguration(ConfigHolderDynamic parent, AmbientSoundCategory cat, Field categoryField) {
        if (!cat.children.isEmpty()) {
            parent = parent.registerFolder(cat.name);
        }
        parent.registerField(cat.name, categoryField, (Object)cat);
        for (AmbientSoundCategory child : cat.children) {
            this.createSoundCategoryConfiguration(parent, child, categoryField);
        }
    }

    public void onRender(Object object) {
        if (this.showDebugInfo && this.engine != null && !mc.method_1493() && this.environment != null && AmbientTickHandler.mc.field_1687 != null) {
            class_332 graphics = (class_332)object;
            DebugTextRenderer text = new DebugTextRenderer();
            this.engine.collectDetails(text);
            text.detail("playing", (Object)this.engine.soundEngine.playingCount()).detail("dim-name", (Object)AmbientTickHandler.mc.field_1687.method_27983().method_29177()).newLine();
            this.environment.collectLevelDetails(text);
            text.newLine();
            this.environment.collectPlayerDetails(text, (class_1657)AmbientTickHandler.mc.field_1724);
            text.newLine();
            this.environment.collectTerrainDetails(text);
            text.newLine();
            this.environment.collectBiomeDetails(text);
            text.newLine();
            for (AmbientSoundCategory cat : this.engine.sortedSoundCategories) {
                cat.collectDetails(text);
            }
            text.newLine();
            for (AmbientRegion region : this.engine.activeRegions) {
                text.detail("region", (Object)(class_124.field_1077 + region.name + class_124.field_1070));
                text.detail("playing", (Object)region.playing.size());
                text.newLine();
                for (AmbientSound sound : region.playing) {
                    if (!sound.isPlaying()) continue;
                    if (sound.stream1 != null) {
                        sound.stream1.collectDetails(text);
                    }
                    if (sound.stream2 != null) {
                        sound.stream2.collectDetails(text);
                    }
                    text.newLine();
                }
            }
            text.render(AmbientTickHandler.mc.field_1772, graphics);
        }
    }

    public void loadLevel(class_1936 level) {
        if (level.method_8608() && this.engine != null) {
            this.engine.onClientLoad();
        }
    }

    public void onTick() {
        if (this.soundEngine == null) {
            this.soundEngine = new AmbientSoundEngine();
            if (this.engine == null) {
                this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            }
            if (this.engine != null) {
                this.engine.soundEngine = this.soundEngine;
            }
        }
        if (this.shouldReload) {
            AmbientSounds.reload();
            this.shouldReload = false;
        }
        if (this.engine == null) {
            return;
        }
        class_638 level = AmbientTickHandler.mc.field_1687;
        class_746 player = AmbientTickHandler.mc.field_1724;
        if (level != null && player != null && AmbientTickHandler.mc.field_1690.method_1630(class_3419.field_15256) > 0.0f && !mc.method_1493()) {
            AmbientDimension newDimension;
            if (this.environment == null) {
                this.environment = new AmbientEnvironment();
            }
            if (this.environment.dimension != (newDimension = this.engine.getDimension((class_1937)level))) {
                this.engine.changeDimension(this.environment, newDimension);
                this.environment.dimension = newDimension;
            }
            if (this.timer % this.engine.environmentTickTime == 0) {
                this.environment.analyzeSlow(newDimension, this.engine, (class_1657)player, (class_1937)level, this.timer);
            }
            if (this.timer % this.engine.soundTickTime == 0) {
                this.environment.analyzeFast(newDimension, (class_1657)player, (class_1937)level, mc.method_1534());
                this.environment.dimension.manipulateEnviroment(this.environment);
                this.engine.tick(this.environment);
            }
            this.engine.fastTick(this.environment);
            ++this.timer;
        } else if (!this.engine.activeRegions.isEmpty()) {
            this.engine.stopEngine();
        }
    }
}

