/*
 * Decompiled with CFR 0.152.
 */
package common.net.jason13.eatanomelette.content;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class EnchantedSpanishPotatoOmeletteBlock
extends CakeBlock {
    public EnchantedSpanishPotatoOmeletteBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Block block;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        Item item = itemstack.getItem();
        if (itemstack.is(ItemTags.CANDLES) && (Integer)pState.getValue((Property)BITES) == 0 && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            if (!pPlayer.isCreative()) {
                itemstack.shrink(1);
            }
            pLevel.playSound((Player)null, pPos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.setBlockAndUpdate(pPos, CandleCakeBlock.byCandle((Block)block));
            pLevel.gameEvent((Entity)pPlayer, GameEvent.BLOCK_CHANGE, pPos);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (pLevel.isClientSide) {
            if (EnchantedSpanishPotatoOmeletteBlock.eat((LevelAccessor)pLevel, pPos, pState, pPlayer).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return EnchantedSpanishPotatoOmeletteBlock.eat((LevelAccessor)pLevel, pPos, pState, pPlayer);
    }

    protected static InteractionResult eat(LevelAccessor pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pPlayer.canEat(true)) {
            return InteractionResult.PASS;
        }
        pPlayer.awardStat(Stats.EAT_CAKE_SLICE);
        pPlayer.getFoodData().eat(2, 0.1f);
        pPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 1));
        pPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 0));
        pPlayer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 6000, 0));
        pPlayer.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 3));
        int i = (Integer)pState.getValue((Property)BITES);
        pLevel.gameEvent((Entity)pPlayer, GameEvent.EAT, pPos);
        if (i < 6) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            pLevel.removeBlock(pPos, false);
            pLevel.gameEvent((Entity)pPlayer, GameEvent.BLOCK_DESTROY, pPos);
        }
        return InteractionResult.SUCCESS;
    }
}

