/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.spyglass_improvements.client;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.juancarloscp52.spyglass_improvements.client.Settings;
import me.juancarloscp52.spyglass_improvements.client.TrinketsIntegration;
import me.juancarloscp52.spyglass_improvements.mixin.MinecraftClientInvoker;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_304;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class SpyglassImprovementsClient
implements ClientModInitializer {
    public boolean force_spyglass = false;
    private boolean trinketsLoaded = false;
    public static final Logger LOGGER = LogManager.getLogger();
    public static class_304 useSpyglass = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.spyglass-improvements.use", class_3675.class_307.field_1668, 90, "category.spyglass-improvements"));
    public Settings settings;
    private static SpyglassImprovementsClient INSTANCE;
    public static int slot;
    public static float MULTIPLIER;

    public static SpyglassImprovementsClient getInstance() {
        return INSTANCE;
    }

    public void onInitializeClient() {
        INSTANCE = this;
        this.loadSettings();
        if (FabricLoader.getInstance().isModLoaded("physicsmod")) {
            this.settings.hideSettingsButton = true;
            this.saveSettings();
        }
        this.trinketsLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        if (this.trinketsLoaded) {
            TrinketsIntegration.registerRenderer();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1761 == null) {
                return;
            }
            class_746 player = client.field_1724;
            if (useSpyglass.method_1434() && ((MinecraftClientInvoker)client).getItemUseCooldown() == 0 && !client.field_1724.method_6115()) {
                slot = this.findSlotByItem(client.field_1724.method_31548(), class_1802.field_27070);
                if (player.method_6079().method_7909().equals(class_1802.field_27070)) {
                    client.field_1761.method_2919((class_1657)player, class_1268.field_5810);
                } else if (player.method_6047().method_7909().equals(class_1802.field_27070)) {
                    client.field_1761.method_2919((class_1657)player, class_1268.field_5808);
                } else if (player.method_7337()) {
                    this.forceUseSpyglass(player);
                } else if (this.trinketsLoaded && TrinketsIntegration.verifySpyglassTrinket(player)) {
                    this.forceUseSpyglass(player);
                } else if (slot >= 9) {
                    client.field_1761.method_2906(0, slot, 40, class_1713.field_7791, (class_1657)player);
                    client.field_1761.method_2919((class_1657)player, class_1268.field_5810);
                } else if (slot >= 0) {
                    int oldSlot = player.method_31548().field_7545;
                    player.method_31548().field_7545 = slot;
                    slot = oldSlot;
                    client.field_1761.method_2919((class_1657)player, class_1268.field_5808);
                }
            } else if (!useSpyglass.method_1434() && this.force_spyglass) {
                this.force_spyglass = false;
                player.method_5783(class_3417.field_26973, 1.0f, 1.0f);
            }
        });
        LOGGER.info("Initialized spyglass-improvements");
    }

    private void forceUseSpyglass(class_746 player) {
        if (this.force_spyglass) {
            return;
        }
        this.force_spyglass = true;
        player.method_5783(class_3417.field_26972, 1.0f, 1.0f);
    }

    public void loadSettings() {
        File file = new File("./config/spyglass-improvements/settings.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (Settings)gson.fromJson((Reader)fileReader, Settings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Spyglass Improvements settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new Settings();
            this.saveSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/spyglass-improvements/settings.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Spyglass Improvements settings: " + e.getLocalizedMessage());
        }
    }

    private int findSlotByItem(class_1661 inventory, class_1792 item) {
        for (int i = 0; i < inventory.field_7547.size(); ++i) {
            if (((class_1799)inventory.field_7547.get(i)).method_7960() || !((class_1799)inventory.field_7547.get(i)).method_31574(item)) continue;
            return i;
        }
        return -1;
    }

    static {
        slot = -1;
        MULTIPLIER = 0.1f;
    }
}

