/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cristelknight.wwoo.EEExpectPlatform;
import cristelknight.wwoo.ExpandedEcosphere;
import cristelknight.wwoo.utils.Update;
import cristelknight.wwoo.utils.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.util.Platform;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Updater {
    private Optional<Update> info;
    private final String currentVersion;
    private boolean isBig = false;
    private int newUpdates;
    private static final String s = "[Expanded Ecosphere Updater]";

    public Updater(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void checkForUpdates() {
        try {
            InputStream in = new URL("https://github.com/Cristelknight999/CristelknightUpdateChecker/releases/download/1.0/update.json").openStream();
            try {
                String updateIndex;
                try {
                    updateIndex = JsonParser.parseReader((Reader)new InputStreamReader(in)).getAsJsonObject().get(Updater.getReleaseTarget()).getAsString();
                }
                catch (NullPointerException e) {
                    ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] This version doesn't have an update index, skipping");
                    this.info = Optional.empty();
                    if (in != null) {
                        in.close();
                    }
                    return;
                }
                JsonObject object = JsonParser.parseReader((Reader)new InputStreamReader(new URL(updateIndex).openStream())).getAsJsonObject();
                ArrayList<Update> newUpdate = new ArrayList<Update>();
                for (JsonElement element : object.getAsJsonArray("versions")) {
                    Update u = (Update)new Gson().fromJson(element, Update.class);
                    boolean isForge = CristelLibExpectPlatform.getPlatform().equals((Object)Platform.FORGE);
                    if (isForge && u.modDownloadFO.isEmpty() || !isForge && u.modDownloadFA.isEmpty() || !EEExpectPlatform.isNewer(this.currentVersion, u.semanticVersion)) continue;
                    newUpdate.add(u);
                    if (!u.isBig) continue;
                    this.isBig = true;
                }
                if (newUpdate.isEmpty()) {
                    this.info = Optional.empty();
                    ExpandedEcosphere.LOGGER.info("[Expanded Ecosphere Updater] Found no updates");
                    return;
                }
                this.newUpdates = newUpdate.size();
                String isBigString = this.isBig ? " important" : "";
                ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Found an" + isBigString + " update!");
                this.info = newUpdate.stream().findFirst();
                return;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Unable to download " + e.getMessage());
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.warn("[Expanded Ecosphere Updater] Failed to get update info!", (Throwable)e);
        }
        this.info = Optional.empty();
    }

    public boolean isBig() {
        return this.isBig;
    }

    public Optional<class_2561> getUpdateMessage() {
        Update update = this.info.orElse(null);
        if (update == null) {
            return Optional.empty();
        }
        String string = this.isBig ? "expanded_ecosphere.config.text.newUpdateBig" : "expanded_ecosphere.config.text.newUpdate";
        class_5250 component1 = class_2561.method_43469((String)"expanded_ecosphere.config.text.newUpdates", (Object[])new Object[]{this.newUpdates, this.newUpdates > 1 ? Util.translatableText("multiple") : Util.translatableText("null")}).method_27692(class_124.field_1080);
        class_5250 component = class_2561.method_43469((String)string, (Object[])new Object[]{Util.translatableText("ch").method_27692(class_124.field_1067).method_27692(class_124.field_1073).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11749, update.modDownloadFA))), component1});
        return Optional.of(component);
    }

    public static String getReleaseTarget() {
        return class_155.method_16673().method_48022() ? class_155.method_16673().method_48019() : "1.20.2";
    }
}

