/*
 * Decompiled with CFR 0.152.
 */
package cristelknight.wwoo.terra;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cristelknight.wwoo.EERL;
import cristelknight.wwoo.ExpandedEcosphere;
import cristelknight.wwoo.config.configs.ReplaceBiomesConfig;
import cristelknight.wwoo.terra.WWOORegion;
import cristelknight.wwoo.utils.BiomeReplace;
import cristelknight.wwoo.utils.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.util.TerrablenderUtil;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_7924;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class TerraInit {
    private static final String OVERWORLD = "resources/ee_default/data/minecraft/dimension/overworld.json";
    private static final String NOISE = "resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json";

    public static List<Pair<class_6544.class_4762, class_5321<class_1959>>> readParameterPoints() {
        ArrayList<Pair<class_6544.class_4762, class_5321<class_1959>>> arrayList;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)"expanded_ecosphere", (String)OVERWORLD);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.error("Couldn't read resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement el = JsonParser.parseReader((Reader)reader);
            if (!el.isJsonObject()) {
                throw new RuntimeException("Input stream is on JsonElement");
            }
            ArrayList<Pair<class_6544.class_4762, class_5321<class_1959>>> list = new ArrayList<Pair<class_6544.class_4762, class_5321<class_1959>>>();
            JsonObject o = el.getAsJsonObject();
            if (((ReplaceBiomesConfig)ReplaceBiomesConfig.DEFAULT.getConfig()).enableBiomes()) {
                BiomeReplace.replaceObject(o, true);
            }
            JsonArray jsonArray = o.get("generator").getAsJsonObject().get("biome_source").getAsJsonObject().get("biomes").getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject e = jsonArray.get(i).getAsJsonObject();
                String b = e.get("biome").getAsString();
                if (b.contains("minecraft:")) continue;
                JsonObject jo = e.get("parameters").getAsJsonObject();
                class_6544.class_4762 point = (class_6544.class_4762)Util.readConfig((JsonElement)jo, class_6544.class_4762.field_24679, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
                Pair pair = new Pair((Object)point, (Object)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960(b)));
                list.add((Pair<class_6544.class_4762, class_5321<class_1959>>)pair);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                ExpandedEcosphere.LOGGER.error("Couldn't find resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
                throw new RuntimeException(e);
            }
            catch (JsonSyntaxException | IOException e) {
                ExpandedEcosphere.LOGGER.error("Couldn't parse resources/ee_default/data/minecraft/dimension/overworld.json, crashing instead");
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static class_6686.class_6708 readSurfaceRulesFromNoise() {
        class_6686.class_6708 class_67082;
        InputStream im;
        try {
            Path path = CristelLibExpectPlatform.getResourceDirectory((String)"expanded_ecosphere", (String)NOISE);
            if (path == null) {
                throw new RuntimeException();
            }
            im = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            ExpandedEcosphere.LOGGER.error("Couldn't read resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json, crashing instead");
            throw new RuntimeException(e);
        }
        InputStreamReader reader = new InputStreamReader(im);
        try {
            JsonElement load = JsonParser.parseReader((Reader)reader);
            JsonElement element = load.getAsJsonObject().get("surface_rule");
            class_67082 = (class_6686.class_6708)Util.readConfig(element, class_6686.class_6708.field_35252, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception errorMsg) {
                throw new IllegalArgumentException("Couldn't parse resources/ee_default/data/minecraft/worldgen/noise_settings/overworld.json, crashing instead.");
            }
        }
        reader.close();
        return class_67082;
    }

    public static void terraEnableDisable() {
        if (ExpandedEcosphere.currentMode.equals((Object)ExpandedEcosphere.Mode.COMPATIBLE)) {
            TerraInit.terraEnable();
        } else {
            TerrablenderUtil.setMixinEnabled((boolean)false);
            Regions.remove((RegionType)RegionType.OVERWORLD, (class_2960)new EERL("overworld"));
            SurfaceRuleManager.removeSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"wythers");
        }
    }

    public static void terraEnable() {
        TerrablenderUtil.setMixinEnabled((boolean)true);
        TerraInit.registerRegions();
        TerraInit.readOverworldSurfaceRules();
    }

    private static void registerRegions() {
        Regions.register((Region)new WWOORegion(new EERL("overworld"), 10));
    }

    private static void readOverworldSurfaceRules() {
        class_6686.class_6708 s = TerraInit.readSurfaceRulesFromNoise();
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"wythers", (class_6686.class_6708)s);
    }
}

