/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.moregeodes.item.recipe;

import com.github.thedeathlycow.moregeodes.item.GeodesItemGroup;
import com.github.thedeathlycow.moregeodes.item.recipe.GeodesRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;

public class TuningRecipe
extends class_1867 {
    private final class_2960 tuningId;

    public TuningRecipe(class_2960 id, String group, class_7710 category, class_2960 tuningId, class_2371<class_1856> input) {
        super(id, group, category, GeodesItemGroup.makeTunedLocatorStack(tuningId.toString()), input);
        this.tuningId = tuningId;
    }

    public class_1865<?> method_8119() {
        return GeodesRecipeSerializers.CRYSTAL_TUNING;
    }

    public static class Serializer
    implements class_1865<TuningRecipe> {
        public TuningRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_7710 category = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)jsonObject, (String)"category", null), (Enum)class_7710.field_40251);
            class_2371<class_1856> ingredients = Serializer.getIngredients(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for tuning recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for tuning recipe");
            }
            if (!jsonObject.has("tuning")) {
                throw new JsonParseException("No tuning ID found for a tuning recipe");
            }
            class_2960 tuning = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"tuning"));
            return new TuningRecipe(identifier, group, category, tuning, ingredients);
        }

        private static class_2371<class_1856> getIngredients(JsonArray json) {
            class_2371 defaultedList = class_2371.method_10211();
            for (int i = 0; i < json.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)json.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public TuningRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            String group = packetByteBuf.method_19772();
            class_7710 category = (class_7710)packetByteBuf.method_10818(class_7710.class);
            int numIngredients = packetByteBuf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)numIngredients, (Object)class_1856.field_9017);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_2960 tuning = new class_2960(packetByteBuf.method_19772());
            return new TuningRecipe(identifier, group, category, tuning, (class_2371<class_1856>)ingredients);
        }

        public void write(class_2540 packetByteBuf, TuningRecipe tuningRecipe) {
            packetByteBuf.method_10814(tuningRecipe.method_8112());
            packetByteBuf.method_10817((Enum)tuningRecipe.method_45441());
            packetByteBuf.method_10804(tuningRecipe.method_8117().size());
            for (class_1856 ingredient : tuningRecipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10814(tuningRecipe.tuningId.toString());
        }
    }
}

