/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.moregeodes.item;

import com.github.thedeathlycow.moregeodes.entity.EchoDisplay;
import com.github.thedeathlycow.moregeodes.entity.GeodesEntityTypes;
import com.github.thedeathlycow.moregeodes.item.ModItems;
import com.github.thedeathlycow.moregeodes.item.tuning.Tuning;
import com.github.thedeathlycow.moregeodes.mixin.BlockDisplayInvoker;
import com.github.thedeathlycow.moregeodes.sounds.GeodesSoundEvents;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class CrystalLocatorItem
extends class_1792 {
    public static final int CRYSTAL_LOCATOR_RANGE = 48;
    public static final int CRYSTAL_LOCATOR_COOL_DOWN = 20;
    private final int range;
    private final int coolDown;

    public CrystalLocatorItem(class_1792.class_1793 settings, int range, int coolDown) {
        super(settings);
        this.range = range;
        this.coolDown = coolDown;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.field_9236) {
            int blocksPinged = this.activate((class_3218)world, user.method_24515(), itemStack);
            if (blocksPinged > 0) {
                itemStack.method_7956(1, (class_1309)user, player -> player.method_20236(hand));
            }
            class_1796 cooldownManager = user.method_7357();
            this.setCooldown(cooldownManager, this.coolDown);
            user.method_17356(GeodesSoundEvents.BLOCK_ECHO_LOCATOR_USE, user.method_5634(), 1.0f, 1.0f);
        }
        return class_1271.method_29237((Object)itemStack, (boolean)world.method_8608());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (!this.isTuned(stack, world)) {
            tooltip.add(Tuning.UNTUNED.getDescription());
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public boolean isTuned(class_1799 stack, @Nullable class_1937 world) {
        return false;
    }

    protected boolean isPingableCrystal(class_1799 locatorStack, class_3218 world, class_2338 pos) {
        return false;
    }

    protected void setCooldown(class_1796 cooldownManager, int ticks) {
        cooldownManager.method_7906(ModItems.CRYSTAL_LOCATOR, ticks);
        cooldownManager.method_7906(ModItems.TUNED_CRYSTAL_LOCATOR, ticks);
    }

    private int activate(class_3218 world, class_2338 origin, class_1799 itemStack) {
        class_2382 scanVector = new class_2382(this.range, this.range, this.range);
        class_2338 from = origin.method_10059(scanVector);
        class_2338 to = origin.method_10081(scanVector);
        int rangeSquared = this.range * this.range;
        int blocksPinged = 0;
        for (class_2338 pos : class_2338.method_10097((class_2338)from, (class_2338)to)) {
            double distanceToPos = origin.method_10262((class_2382)pos) * 3.0;
            if (!(distanceToPos <= (double)rangeSquared)) continue;
            blocksPinged += this.tryPing(world, pos, itemStack, distanceToPos);
        }
        return blocksPinged;
    }

    private int tryPing(class_3218 world, class_2338 pos, class_1799 itemStack, double distanceToPosSquared) {
        if (this.isPingableCrystal(itemStack, world, pos)) {
            int delay = class_3532.method_15384((double)Math.sqrt(distanceToPosSquared));
            CrystalLocatorItem.highlightCrystal((class_1937)world, pos, world.method_8320(pos), delay);
            return 1;
        }
        return 0;
    }

    private static void highlightCrystal(class_1937 world, class_2338 pos, class_2680 state, int delay) {
        EchoDisplay blockDisplay = (EchoDisplay)GeodesEntityTypes.ECHO_DISPLAY.method_5883(world);
        if (blockDisplay == null) {
            return;
        }
        ((BlockDisplayInvoker)((Object)blockDisplay)).geodes$setBlockState(state);
        blockDisplay.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
        blockDisplay.setGlowDelay(delay);
        world.method_8649((class_1297)blockDisplay);
    }
}

