/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.moregeodes.config;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public final class GeodesConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String generateEmeraldGeodes = "generate_emerald_geodes";
    private static final String generateQuartzGeodes = "generate_quartz_geodes";
    private static final String generateDiamondGeodes = "generate_diamond_geodes";
    private static final String generateEchoGeodes = "generate_echo_geodes";
    private static final String generateLapisGeodes = "generate_lapis_geodes";
    private static final String generateGypsumPatches = "generate_gypsum_patches";
    private static final String generateCertusGeodes = "generate_certus_geodes";
    private static final String generateBismuthGeodes = "generate_bismuth_geodes";
    private Properties properties;
    private final Properties defaultProperties = new Properties();

    public boolean generateEmeraldGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateEmeraldGeodes));
    }

    public boolean generateQuartzGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateQuartzGeodes));
    }

    public boolean generateDiamondGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateDiamondGeodes));
    }

    public boolean generateEchoGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateEchoGeodes));
    }

    public boolean generateLapisGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateLapisGeodes));
    }

    public boolean generateGypsumPatches() {
        return Boolean.parseBoolean(this.properties.getProperty(generateGypsumPatches));
    }

    public boolean generateCertusGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateCertusGeodes));
    }

    public boolean generateBismuthGeodes() {
        return Boolean.parseBoolean(this.properties.getProperty(generateBismuthGeodes));
    }

    public void loadConfig() {
        this.loadDefaultConfig();
        this.properties = new Properties(this.defaultProperties);
        try (FileReader reader = new FileReader(this.getConfigFile());){
            this.properties.load(reader);
        }
        catch (FileNotFoundException ignored) {
            this.generateDefaultConfig();
        }
        catch (IOException e) {
            LOGGER.error("Could not load More Geodes config, using default config instead. Failed with exception: " + String.valueOf(e));
            return;
        }
        LOGGER.info("Loaded More Geodes config!");
    }

    private void generateDefaultConfig() {
        try (FileWriter writer = new FileWriter(this.getConfigFile());){
            this.defaultProperties.store(writer, "Default config file for More Geodes. See the readme on GitHub for more information: https://github.com/TheDeathlyCow/more-geodes/blob/main/README.md");
        }
        catch (IOException e) {
            LOGGER.error("Error creating default More Geodes config: " + String.valueOf(e));
            return;
        }
        LOGGER.info("Generated default config for More Geodes");
    }

    private void loadDefaultConfig() {
        this.defaultProperties.setProperty(generateEmeraldGeodes, "true");
        this.defaultProperties.setProperty(generateQuartzGeodes, "true");
        this.defaultProperties.setProperty(generateDiamondGeodes, "true");
        this.defaultProperties.setProperty(generateEchoGeodes, "true");
        this.defaultProperties.setProperty(generateLapisGeodes, "true");
        this.defaultProperties.setProperty(generateGypsumPatches, "true");
        this.defaultProperties.setProperty(generateCertusGeodes, "true");
        this.defaultProperties.setProperty(generateBismuthGeodes, "true");
    }

    private File getConfigFile() {
        Path config = FabricLoader.getInstance().getConfigDir().resolve("geodes.properties");
        File file = config.toFile();
        assert (file.isFile());
        return file;
    }
}

