/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.moreusefulcopper.registry;

import forge.net.jason13.moreusefulcopper.content.CopperBucketItem;
import forge.net.jason13.moreusefulcopper.content.CopperMilkBucketItem;
import forge.net.jason13.moreusefulcopper.content.CopperSolidBucketItem;
import forge.net.jason13.moreusefulcopper.entity.custom.CopperGolemEntity;
import forge.net.jason13.moreusefulcopper.registry.ModArmorMaterials;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegistry {
    public static DeferredRegister<Block> BLOCK = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"moreusefulcopper");
    public static DeferredRegister<Item> ITEM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"moreusefulcopper");
    public static DeferredRegister<EntityType<?>> ENTITY_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"moreusefulcopper");
    public static DeferredRegister<CreativeModeTab> CREATIVE_MODE_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"moreusefulcopper");
    public static final RegistryObject<Block> COPPER_CHAIN = ForgeRegistry.registerBlock("copper_chain", () -> new ChainBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50184_)));
    public static final RegistryObject<Block> COPPER_BUTTON = ForgeRegistry.registerBlock("copper_button", () -> new ButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60999_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), BlockSetType.f_271479_, 20, false));
    public static final RegistryObject<Block> COPPER_PRESSURE_PLATE = ForgeRegistry.registerBlock("copper_pressure_plate", () -> new WeightedPressurePlateBlock(150, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_280606_().m_60999_().m_60910_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), BlockSetType.f_271132_));
    public static final RegistryObject<EntityType<CopperGolemEntity>> COPPER_GOLEM = ENTITY_TYPE.register("", () -> EntityType.Builder.m_20704_(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.4f, 2.7f).m_20702_(10).m_20712_("copper_golem"));
    public static final RegistryObject<Item> COPPER_SWORD = ForgeRegistry.registerItem("copper_sword", () -> new SwordItem((Tier)Tiers.IRON, 3, -2.4f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_SHOVEL = ForgeRegistry.registerItem("copper_shovel", () -> new ShovelItem((Tier)Tiers.IRON, 1.5f, -3.0f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_PICKAXE = ForgeRegistry.registerItem("copper_pickaxe", () -> new PickaxeItem((Tier)Tiers.IRON, 1, -2.8f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_AXE = ForgeRegistry.registerItem("copper_axe", () -> new AxeItem((Tier)Tiers.IRON, 6.0f, -3.1f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_HOE = ForgeRegistry.registerItem("copper_hoe", () -> new HoeItem((Tier)Tiers.IRON, -2, -1.0f, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_BUCKET = ForgeRegistry.registerItem("copper_bucket", () -> new CopperBucketItem(Fluids.f_76191_, new Item.Properties().m_41487_(16)));
    public static final RegistryObject<Item> COPPER_WATER_BUCKET = ForgeRegistry.registerItem("copper_water_bucket", () -> new CopperBucketItem((Fluid)Fluids.f_76193_, new Item.Properties().m_41495_((Item)COPPER_BUCKET.get()).m_41487_(1)));
    public static final RegistryObject<Item> COPPER_MILK_BUCKET = ForgeRegistry.registerItem("copper_milk_bucket", () -> new CopperMilkBucketItem(new Item.Properties().m_41495_((Item)COPPER_BUCKET.get()).m_41487_(1)));
    public static final RegistryObject<Item> COPPER_POWDER_SNOW_BUCKET = ForgeRegistry.registerItem("copper_powder_snow_bucket", () -> new CopperSolidBucketItem(Blocks.f_152499_, SoundEvents.f_144076_, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_SHEARS = ForgeRegistry.registerItem("copper_shears", () -> new ShearsItem(new Item.Properties().m_41503_(238)));
    public static final RegistryObject<Item> COPPER_GOLEM_SPAWN_EGG = ForgeRegistry.registerItem("copper_golem_spawn_egg", () -> new ForgeSpawnEggItem(COPPER_GOLEM, 7156769, 15170646, new Item.Properties()));
    public static final RegistryObject<Item> COPPER_HORSE_ARMOR = ForgeRegistry.registerItem("copper_horse_armor", () -> new HorseArmorItem(5, new ResourceLocation("moreusefulcopper", "textures/entity/horse/armor/horse_armor_copper.png"), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_HELMET = ForgeRegistry.registerItem("copper_helmet", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.COPPER, ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_CHESTPLATE = ForgeRegistry.registerItem("copper_chestplate", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.COPPER, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_LEGGINGS = ForgeRegistry.registerItem("copper_leggings", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.COPPER, ArmorItem.Type.LEGGINGS, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> COPPER_BOOTS = ForgeRegistry.registerItem("copper_boots", () -> new ArmorItem((ArmorMaterial)ModArmorMaterials.COPPER, ArmorItem.Type.BOOTS, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<CreativeModeTab> MOREUSEFULCOPPER_TAB = CREATIVE_MODE_TAB.register("moreusefulcopper_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257737_(() -> new ItemStack((ItemLike)COPPER_PICKAXE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.moreUsefulCopper")).m_257501_((itemDisplayParameters, output) -> {
        output.m_246326_((ItemLike)COPPER_SWORD.get());
        output.m_246326_((ItemLike)COPPER_SHOVEL.get());
        output.m_246326_((ItemLike)COPPER_PICKAXE.get());
        output.m_246326_((ItemLike)COPPER_AXE.get());
        output.m_246326_((ItemLike)COPPER_HOE.get());
        output.m_246326_((ItemLike)COPPER_BUCKET.get());
        output.m_246326_((ItemLike)COPPER_WATER_BUCKET.get());
        output.m_246326_((ItemLike)COPPER_MILK_BUCKET.get());
        output.m_246326_((ItemLike)COPPER_POWDER_SNOW_BUCKET.get());
        output.m_246326_((ItemLike)COPPER_SHEARS.get());
        output.m_246326_((ItemLike)COPPER_GOLEM_SPAWN_EGG.get());
        output.m_246326_((ItemLike)COPPER_HORSE_ARMOR.get());
        output.m_246326_((ItemLike)COPPER_HELMET.get());
        output.m_246326_((ItemLike)COPPER_CHESTPLATE.get());
        output.m_246326_((ItemLike)COPPER_LEGGINGS.get());
        output.m_246326_((ItemLike)COPPER_BOOTS.get());
        output.m_246326_((ItemLike)COPPER_CHAIN.get());
        output.m_246326_((ItemLike)COPPER_BUTTON.get());
        output.m_246326_((ItemLike)COPPER_PRESSURE_PLATE.get());
    }).m_257652_());

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCK.register(name, block);
        ForgeRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ITEM.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> item) {
        return ITEM.register(name, item);
    }

    public static void register(IEventBus bus) {
        BLOCK.register(bus);
        ITEM.register(bus);
        ENTITY_TYPE.register(bus);
        CREATIVE_MODE_TAB.register(bus);
    }

    private static ButtonBlock copperButton() {
        return new ButtonBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60999_().m_60978_(0.5f).m_278166_(PushReaction.DESTROY), BlockSetType.f_271479_, 20, false);
    }
}

