/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.moreusefulcopper.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.jason13.moreusefulcopper.entity.animations.GolemAnimations;
import forge.net.jason13.moreusefulcopper.entity.custom.CopperGolemEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CopperGolemModel<T extends CopperGolemEntity>
extends HierarchicalModel<T> {
    private final ModelPart golem;
    private final ModelPart head;

    public CopperGolemModel(ModelPart root) {
        this.golem = root.m_171324_("body");
        this.head = root.m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-9.0f, -33.0f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 70).m_171488_(-4.5f, -21.0f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -43.0f, -7.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.0f, -36.0f, -9.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legRight = body.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171488_(-7.5f, 0.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition legLeft = body.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171488_(1.5f, 0.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition armRight = body.m_171599_("armRight", CubeListBuilder.m_171558_().m_171514_(60, 21).m_171488_(-13.0f, -0.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-33.0f, (float)0.0f));
        PartDefinition armLeft = body.m_171599_("armLeft", CubeListBuilder.m_171558_().m_171514_(60, 58).m_171488_(9.0f, -0.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-33.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(CopperGolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(entity, netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(GolemAnimations.WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        this.m_233385_(entity.attackAnimationState, GolemAnimations.ATTACK, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.golem;
    }

    private void applyHeadRotation(CopperGolemEntity pEntity, float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-2.5f, (float)2.5f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }
}

