/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import com.supermartijn642.durabilitytooltip.TooltipColorStyle;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public enum TooltipStyle {
    BAR,
    NUMBERS,
    TEXT;


    public void appendTooltip(List<class_2561> tooltips, int durability, int maxDurability) {
        boolean showTooltipHint = DurabilityTooltipConfig.showTooltipHint.get();
        class_124 baseColor = DurabilityTooltipConfig.baseTooltipColor.get();
        TooltipColorStyle colorStyle = DurabilityTooltipConfig.tooltipColorStyle.get();
        class_124 reactiveColor = colorStyle.getColorForDurability(baseColor, durability, maxDurability);
        switch (this) {
            case BAR: {
                if (showTooltipHint) {
                    tooltips.add((class_2561)class_2561.method_43471((String)"durabilitytooltip.info.bar.durability_hint").method_27692(baseColor));
                }
                int fullCharacters = Math.round(10.0f * (float)durability / (float)maxDurability);
                class_5250 innerBar = class_2561.method_43470((String)"");
                for (int character = 0; character < 10; ++character) {
                    innerBar.method_10852((class_2561)class_2561.method_43471((String)(character < fullCharacters ? "durabilitytooltip.info.bar.full_symbol" : "durabilitytooltip.info.bar.empty_symbol")).method_27692(reactiveColor));
                }
                class_5250 bar = class_2561.method_43469((String)"durabilitytooltip.info.bar.bar_line", (Object[])new Object[]{innerBar}).method_27692(baseColor);
                tooltips.add((class_2561)bar);
                break;
            }
            case NUMBERS: {
                class_5250 durabilityComponent = class_2561.method_43470((String)Integer.toString(durability)).method_27692(reactiveColor);
                class_5250 maxDurabilityComponent = class_2561.method_43470((String)Integer.toString(maxDurability)).method_27692(colorStyle == TooltipColorStyle.VARYING ? baseColor : reactiveColor);
                class_5250 numbers = durability == maxDurability ? class_2561.method_43469((String)"durabilitytooltip.info.numbers.full_durability", (Object[])new Object[]{maxDurabilityComponent}).method_27692(baseColor) : class_2561.method_43469((String)"durabilitytooltip.info.numbers.damaged", (Object[])new Object[]{durabilityComponent, maxDurabilityComponent}).method_27692(baseColor);
                if (showTooltipHint) {
                    numbers = class_2561.method_43469((String)"durabilitytooltip.info.numbers.durability_hint", (Object[])new Object[]{numbers}).method_27692(baseColor);
                }
                tooltips.add((class_2561)numbers);
                break;
            }
            case TEXT: {
                String translationKey = durability == maxDurability ? "durabilitytooltip.info.text.full_durability" : ((float)durability >= 0.4f * (float)maxDurability ? "durabilitytooltip.info.text.damaged" : ((float)durability >= 0.1f * (float)maxDurability ? "durabilitytooltip.info.text.severely_damaged" : "durabilitytooltip.info.text.nearly_broken"));
                class_5250 tooltip = class_2561.method_43471((String)translationKey).method_27692(reactiveColor);
                if (showTooltipHint) {
                    tooltip = class_2561.method_43469((String)"durabilitytooltip.info.text.durability_hint", (Object[])new Object[]{tooltip}).method_27692(baseColor);
                }
                tooltips.add((class_2561)tooltip);
            }
        }
    }
}

