/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.bedrockplus.item.armor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.anvian.bedrockplus.BedrockPlusMod;
import net.anvian.bedrockplus.item.armor.ModArmorMaterials;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class ModArmorItem
extends class_1738 {
    private static final Map<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.IMPUREBEDROCK, (Object)new class_1293(class_1294.field_5907, 200, 0, false, BedrockPlusMod.CONFIG.ArmorShowParticle(), BedrockPlusMod.CONFIG.ArmorShowIcon())).build();

    public ModArmorItem(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (!world.method_8608() && entity instanceof class_1657 && this.hasFullSuitOfArmorOn(player = (class_1657)entity)) {
            this.evaluateArmorEffects(world, player);
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void evaluateArmorEffects(class_1937 world, class_1657 player) {
        for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            class_1293 mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(world, player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(class_1937 world, class_1657 player, class_1741 mapArmorMaterial, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.method_6092(new class_1293(mapStatusEffect));
        }
    }

    private boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 boots = player.method_31548().method_7372(0);
        class_1799 leggings = player.method_31548().method_7372(1);
        class_1799 breastplate = player.method_31548().method_7372(2);
        class_1799 helmet = player.method_31548().method_7372(3);
        return !helmet.method_7960() && !breastplate.method_7960() && !leggings.method_7960() && !boots.method_7960();
    }

    private boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        class_1799 boots = player.method_31548().method_7372(0);
        class_1799 leggings = player.method_31548().method_7372(1);
        class_1799 breastplate = player.method_31548().method_7372(2);
        class_1799 helmet = player.method_31548().method_7372(3);
        return this.isArmorMaterial(helmet, material) && this.isArmorMaterial(breastplate, material) && this.isArmorMaterial(leggings, material) && this.isArmorMaterial(boots, material);
    }

    private boolean isArmorMaterial(class_1799 stack, class_1741 material) {
        return stack.method_7909() instanceof class_1738 && ((class_1738)stack.method_7909()).method_7686() == material;
    }
}

