/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class ScrollableTextWidget
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final List<class_5481> texts;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            Rectangle bounds = ScrollableTextWidget.this.getBounds();
            return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 2;
            for (class_5481 entry : ScrollableTextWidget.this.texts) {
                int n;
                if (entry == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(ScrollableTextWidget.this.font);
                    n = 9;
                }
                i += n;
            }
            return i;
        }
    };

    public ScrollableTextWidget(Rectangle bounds, List<class_5348> texts) {
        this.bounds = Objects.requireNonNull(bounds);
        this.texts = Lists.newArrayList();
        for (class_5348 text : texts) {
            if (!this.texts.isEmpty()) {
                this.texts.add(null);
            }
            this.texts.addAll(class_310.method_1551().field_1772.method_1728(text, bounds.width - 11));
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return false;
    }

    @Nullable
    public class_364 method_25399() {
        return null;
    }

    public void method_25395(@Nullable class_364 focused) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25397() {
        return false;
    }

    public void method_25398(boolean isDragging) {
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.scrolling.updatePosition(delta);
        Rectangle innerBounds = this.scrolling.getScissorBounds();
        try (CloseableScissors scissors = ScrollableTextWidget.scissor((class_332)graphics, (Rectangle)innerBounds);){
            int currentY = -this.scrolling.scrollAmountInt() + innerBounds.y;
            for (class_5481 text : this.texts) {
                int n;
                if (text != null) {
                    Objects.requireNonNull(this.font);
                    if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                        graphics.method_51430(this.font, text, innerBounds.x + 2, currentY + 2, REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079, false);
                    }
                }
                if (text == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(this.font);
                    n = 9;
                }
                currentY += n;
            }
        }
        if (this.scrolling.hasScrollBar()) {
            if (this.scrolling.scrollAmount() > 8.0) {
                graphics.method_25296(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.y + 16, -3750202, 0xC6C6C6);
            }
            if ((double)this.scrolling.getMaxScroll() - this.scrolling.scrollAmount() > 8.0) {
                graphics.method_25296(innerBounds.x, innerBounds.getMaxY() - 16, innerBounds.getMaxX(), innerBounds.getMaxY(), 0xC6C6C6, -3750202);
            }
        }
        scissors = ScrollableTextWidget.scissor((class_332)graphics, (Rectangle)this.scrolling.getBounds());
        try {
            this.scrolling.renderScrollBar(graphics, 0, 1.0f, 1.0f);
        }
        finally {
            if (scissors != null) {
                scissors.close();
            }
        }
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
}

