/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei;

import dev.architectury.event.CompoundEventResult;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.IPlugin;
import net.mehvahdjukaar.jeed.common.ScreenExtensionsHandler;
import net.mehvahdjukaar.jeed.plugin.rei.display.EffectInfoDisplay;
import net.mehvahdjukaar.jeed.plugin.rei.display.EffectInfoDisplayCategory;
import net.mehvahdjukaar.jeed.plugin.rei.ingredient.EffectInstanceDefinition;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_465;

@REIPluginClient
public class REIPlugin
implements REIClientPlugin,
IPlugin {
    public static final CategoryIdentifier<EffectInfoDisplay> EFFECTS_INFO_CATEGORY = CategoryIdentifier.of((class_2960)Jeed.res("effects"));
    public static final EntryType<class_1293> EFFECT_ENTRY_TYPE = EntryType.deferred((class_2960)new class_2960("effect"));

    public REIPlugin() {
        Jeed.PLUGIN = this;
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new EffectInfoDisplayCategory());
        registry.addWorkstations(EFFECTS_INFO_CATEGORY, new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8574)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (class_1291 e : Jeed.getEffectList()) {
            registry.add((Display)EffectInfoDisplay.create(e));
        }
    }

    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(EFFECT_ENTRY_TYPE, (EntryDefinition)new EffectInstanceDefinition());
        registry.registerBridge(EFFECT_ENTRY_TYPE, VanillaEntryTypes.ITEM, input -> {
            class_1799 item = (class_1799)input.cheatsAs().getValue();
            return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of((class_1799)item)));
        });
    }

    public void registerEntries(EntryRegistry registry) {
        for (class_1291 e : Jeed.getEffectList()) {
            registry.addEntry(EntryStack.of(EFFECT_ENTRY_TYPE, (Object)new class_1293(e)));
        }
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerFocusedStack((screen, mouse) -> {
            if (screen instanceof class_465) {
                class_465 as = (class_465)screen;
                return REIPlugin.typed(mouse, as);
            }
            return CompoundEventResult.pass();
        });
    }

    private static <T extends class_465<?>> CompoundEventResult<EntryStack<?>> typed(Point mouse, T as) {
        class_1293 e;
        Object ext = ScreenExtensionsHandler.getExtension(as);
        if (ext != null && (e = ext.getEffectAtPosition(as, mouse.x, mouse.y, IEffectScreenExtension.CallReason.RECIPE_KEY)) != null) {
            return CompoundEventResult.interruptTrue((Object)EntryStack.of(EFFECT_ENTRY_TYPE, (Object)e));
        }
        return CompoundEventResult.pass();
    }

    @Override
    public void onClickedEffect(class_1293 effect, double x, double y, int button) {
        ViewSearchBuilder.builder().addRecipesFor(EntryStack.of(EFFECT_ENTRY_TYPE, (Object)effect).normalize()).open();
    }
}

