/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public class AllowedSoundConfig
extends CommentedPropertyConfig {
    private Map<String, Boolean> allowedSounds;

    public AllowedSoundConfig(Path path) {
        super(path);
        this.save();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.allowedSounds = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            boolean value;
            String key = entry.getKey();
            try {
                value = Boolean.parseBoolean(entry.getValue());
            }
            catch (Exception e) {
                SoundPhysics.LOGGER.warn("Failed to set allowed sound entry {}", (Object)key);
                continue;
            }
            class_3414 soundEvent = null;
            try {
                soundEvent = (class_3414)class_7923.field_41172.method_10223(new class_2960(key));
            }
            catch (Exception e) {
                SoundPhysics.LOGGER.warn("Failed to set allowed sound entry {}", (Object)key, (Object)e);
            }
            if (soundEvent == null) {
                SoundPhysics.LOGGER.warn("Sound event {} not found", (Object)key);
                continue;
            }
            this.setAllowed(soundEvent, value);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.addHeaderComment("Allowed sounds");
        this.properties.addHeaderComment("Set to 'false' to disable sound physics for that sound");
        for (Map.Entry<String, Boolean> entry : this.allowedSounds.entrySet()) {
            this.properties.set(entry.getKey(), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<String, Boolean> getAllowedSounds() {
        return this.allowedSounds;
    }

    public boolean isAllowed(String soundEvent) {
        return this.allowedSounds.getOrDefault(soundEvent, true);
    }

    public AllowedSoundConfig setAllowed(String soundEvent, boolean allowed) {
        this.allowedSounds.put(soundEvent, allowed);
        return this;
    }

    public AllowedSoundConfig setAllowed(class_3414 soundEvent, boolean allowed) {
        return this.setAllowed(soundEvent.method_14833().toString(), allowed);
    }

    public Map<String, Boolean> createDefaultMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (class_3414 event : class_7923.field_41172) {
            map.put(event.method_14833().toString(), true);
        }
        map.put(class_3417.field_14946.method_14833().toString(), false);
        map.put(class_3417.field_15020.method_14833().toString(), false);
        return map;
    }
}

