/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.gui.immersive_library;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;

public class Auth {
    static final SecureRandom random = new SecureRandom();
    static String currentToken;
    private static final String RES_PAGE = "        <html lang=\"en\">\n        <head>\n            <title>Login</title>\n            <link rel=\"stylesheet\" href=\"style.css\">\n            <script src=\"https://accounts.google.com/gsi/client\" async defer></script>\n        </head>\n        <body class=\"background\">\n        <div class=\"container\">\n            <div class=\"chunk\">\n                <h1>Authenticate</h1>\n                Immersive Library uses your Google account as authentication.\n                <br/>\n                Only your Google user id is stored.\n                <br/> <br/>\n\n                <div id=\"g_id_onload\"\n                     data-client_id=\"854276437682-lkb8uqt14lrt5ctcbknaia4s3j429kme.apps.googleusercontent.com\"\n                     data-login_uri=\"{URL}/v1/auth?username={USERNAME}&token={TOKEN}\"\n                     data-ux_mode=\"redirect\"\n                     data-auto_prompt=\"false\">\n                </div>\n                <div class=\"g_id_signin\"\n                     data-type=\"standard\"\n                     data-size=\"large\"\n                     data-theme=\"filled_black\"\n                     data-text=\"sign_in_with\"\n                     data-shape=\"rectangular\"\n                     data-logo_alignment=\"left\">\n                </div>\n            </div>\n        </div>\n        </body>\n        </html>\n";
    private static final String RES_STYLE = "        .container {\n            display: flex;\n            flex-flow: wrap;\n            justify-content: center;\n            align-items: center;\n            text-align: center;\n            min-height: 95vh;\n        }\n\n        .container hr {\n            width: 100%;\n        }\n\n        body {\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            min-height: 100vh;\n            background: radial-gradient(ellipse at bottom, #0d1d31 0%, #0c0d13 100%);\n            overflow: hidden;\n        }\n\n        .chunk {\n            color: black;\n            font-family: Calibri, sans-serif;\n            background-color: white;\n            opacity: 95%;\n            border-radius: 32px;\n            padding: 16px 32px 32px 32px;\n            box-shadow: 4px 6px 64px;\n        }\n";

    private static String newToken() {
        byte[] bytes = new byte[64];
        random.nextBytes(bytes);
        return new String(bytes);
    }

    @Nullable
    public static String loadToken() {
        try {
            return Files.readString(Paths.get("./immersiveLibraryToken", new String[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static String getToken() {
        if (currentToken == null) {
            currentToken = Auth.loadToken();
        }
        return currentToken;
    }

    public static void saveToken() {
        try {
            Files.writeString(Paths.get("./immersiveLibraryToken", new String[0]), (CharSequence)currentToken, new OpenOption[0]);
        }
        catch (IOException e) {
            MCA.LOGGER.error((Object)e);
        }
    }

    public static void clearToken() {
        Paths.get("./immersiveLibraryToken", new String[0]).toFile().delete();
    }

    private static void write(String path, String content) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(path));){
            writer.write(content);
        }
    }

    public static void authenticate(String username) {
        try {
            String tmpdir = Files.createTempDirectory("immersive_library", new FileAttribute[0]).toFile().getAbsolutePath();
            currentToken = Auth.newToken();
            Auth.saveToken();
            String content = RES_PAGE;
            content = content.replace("{URL}", Config.getInstance().immersiveLibraryUrl);
            content = content.replace("{USERNAME}", URLEncoder.encode(username, StandardCharsets.UTF_8));
            content = content.replace("{TOKEN}", URLEncoder.encode(currentToken, StandardCharsets.UTF_8));
            Auth.write(tmpdir + "/page.html", content);
            Auth.write(tmpdir + "/style.css", RES_STYLE);
            class_156.method_668().method_673(new File(tmpdir + "/page.html").toURI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

