/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3852;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import quilt.net.mca.Config;
import quilt.net.mca.MCA;
import quilt.net.mca.client.gui.ColorSelector;
import quilt.net.mca.client.gui.CombScreen;
import quilt.net.mca.client.gui.DestinyScreen;
import quilt.net.mca.client.gui.NeedleScreen;
import quilt.net.mca.client.gui.SkinListUpdateListener;
import quilt.net.mca.client.gui.VillagerEditorScreen;
import quilt.net.mca.client.gui.immersive_library.Api;
import quilt.net.mca.client.gui.immersive_library.Auth;
import quilt.net.mca.client.gui.immersive_library.SkinCache;
import quilt.net.mca.client.gui.immersive_library.Utils;
import quilt.net.mca.client.gui.immersive_library.Workspace;
import quilt.net.mca.client.gui.immersive_library.responses.ContentIdResponse;
import quilt.net.mca.client.gui.immersive_library.responses.ContentListResponse;
import quilt.net.mca.client.gui.immersive_library.responses.ErrorResponse;
import quilt.net.mca.client.gui.immersive_library.responses.IsAuthResponse;
import quilt.net.mca.client.gui.immersive_library.responses.Response;
import quilt.net.mca.client.gui.immersive_library.responses.SuccessResponse;
import quilt.net.mca.client.gui.immersive_library.responses.UserResponse;
import quilt.net.mca.client.gui.immersive_library.types.LiteContent;
import quilt.net.mca.client.gui.immersive_library.types.User;
import quilt.net.mca.client.gui.widget.ColorPickerWidget;
import quilt.net.mca.client.gui.widget.HorizontalColorPickerWidget;
import quilt.net.mca.client.gui.widget.HorizontalGradientWidget;
import quilt.net.mca.client.gui.widget.IntegerSliderWidget;
import quilt.net.mca.client.gui.widget.ItemButtonWidget;
import quilt.net.mca.client.gui.widget.ToggleableTooltipButtonWidget;
import quilt.net.mca.client.gui.widget.ToggleableTooltipIconButtonWidget;
import quilt.net.mca.client.gui.widget.TooltipButtonWidget;
import quilt.net.mca.client.gui.widget.WidgetUtils;
import quilt.net.mca.client.model.CommonVillagerModel;
import quilt.net.mca.client.resources.ClientUtils;
import quilt.net.mca.client.resources.ProfessionIcons;
import quilt.net.mca.client.resources.SkinLocations;
import quilt.net.mca.client.resources.SkinMeta;
import quilt.net.mca.client.resources.SkinPorter;
import quilt.net.mca.cobalt.network.NetworkHandler;
import quilt.net.mca.entity.EntitiesMCA;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.Genetics;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.network.c2s.AddCustomClothingMessage;
import quilt.net.mca.network.c2s.RemoveCustomClothingMessage;
import quilt.net.mca.resources.data.skin.Clothing;
import quilt.net.mca.resources.data.skin.Hair;
import quilt.net.mca.resources.data.skin.SkinListEntry;
import quilt.net.mca.util.compat.ButtonWidget;
import quilt.net.mca.util.localization.FlowingText;

public class SkinLibraryScreen
extends class_437
implements SkinListUpdateListener {
    private static final class_2960 TEMPLATE_IDENTIFIER = MCA.locate("textures/skin_template.png");
    private static final class_2960 EMPTY_IDENTIFIER = MCA.locate("skins/empty.png");
    private static final class_2960 CANVAS_IDENTIFIER = MCA.locate("temp");
    private static final float CANVAS_SCALE = 2.35f;
    private String filteredString = "";
    private SortingMode sortingMode = SortingMode.LIKES;
    private boolean filterInvalidSkins = true;
    private boolean moderatorMode = false;
    private boolean filterHair = false;
    private boolean filterClothing = false;
    private final List<LiteContent> serverContent = new ArrayList<LiteContent>();
    private SubscriptionFilter subscriptionFilter = SubscriptionFilter.LIBRARY;
    @Nullable
    private User currentUser;
    private int selectionPage;
    private LiteContent focusedContent;
    private LiteContent hoveredContent;
    private LiteContent deleteConfirmationContent;
    private LiteContent reportConfirmationContent;
    private Page page;
    private String lastFilteredString = "";
    private int lastLoadedPage = -1;
    private ButtonWidget pageWidget;
    private Workspace workspace;
    private final ColorSelector color = new ColorSelector();
    private int activeMouseButton;
    private int lastPixelMouseX;
    private int lastPixelMouseY;
    private float x0;
    private float x1;
    private float y0;
    private float y1;
    private boolean isPanning;
    private boolean hasPanned;
    private double lastMouseX;
    private double lastMouseY;
    private int timeSinceLastRebuild;
    private class_2561 error;
    private final VillagerEditorScreen previousScreen;
    protected final VillagerEntityMCA villagerVisualization;
    static final int CLOTHES_H = 7;
    static final int CLOTHES_V = 2;
    static final int CLOTHES_PER_PAGE = 15;
    private boolean authenticated;
    private boolean awaitingAuthentication;
    private boolean isBrowserOpen;
    private boolean uploading;
    private Thread thread;
    private class_342 textFieldWidget;
    private boolean skipHairWarning;
    private final List<LiteContent> contents;
    private List<LiteContent> libraryContents;

    public SkinLibraryScreen() {
        this(null, null);
    }

    public SkinLibraryScreen(VillagerEditorScreen screen, VillagerEntityMCA villagerVisualization) {
        super((class_2561)class_2561.method_43471((String)"gui.skin_library.title"));
        this.villagerVisualization = Objects.requireNonNull((VillagerEntityMCA)((class_1299)EntitiesMCA.MALE_VILLAGER.get()).method_5883((class_1937)class_310.method_1551().field_1687));
        this.authenticated = false;
        this.awaitingAuthentication = false;
        this.isBrowserOpen = false;
        this.uploading = false;
        this.contents = new LinkedList<LiteContent>();
        this.libraryContents = new LinkedList<LiteContent>();
        this.previousScreen = screen;
        if (this.previousScreen instanceof NeedleScreen) {
            this.filterHair = true;
        }
        if (this.previousScreen instanceof CombScreen) {
            this.filterClothing = true;
        }
        if (villagerVisualization != null) {
            class_2487 nbt = new class_2487();
            villagerVisualization.method_5652(nbt);
            this.villagerVisualization.method_5749(nbt);
        } else {
            assert (class_310.method_1551().field_1724 != null);
            VillagerLike<?> villagerLike = CommonVillagerModel.getVillager((class_1937)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_5667());
            if (villagerLike instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)villagerLike;
                class_2487 nbt = new class_2487();
                villager.method_5652(nbt);
                this.villagerVisualization.method_5749(nbt);
            }
        }
    }

    public void method_25420(class_332 context) {
        if (this.previousScreen instanceof DestinyScreen) {
            assert (class_310.method_1551().field_1687 != null);
            this.method_25434(context);
        }
    }

    public void method_25419() {
        if (this.previousScreen == null) {
            super.method_25419();
        } else {
            class_310.method_1551().method_1507((class_437)this.previousScreen);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.refreshServerContent();
        this.thread = Thread.currentThread();
        if (this.page == null) {
            if (Auth.loadToken() == null) {
                this.setPage(Page.LOADING);
            } else {
                this.setPage(Page.LOGIN);
            }
            this.reloadDatabase();
        } else {
            this.refreshPage();
        }
    }

    private void reloadDatabase() {
        this.reloadDatabase(() -> {
            if (this.page == Page.LOADING) {
                this.setPage(Page.LIBRARY);
            }
        });
    }

    private void reloadDatabase(Runnable callback) {
        CompletableFuture.runAsync(() -> {
            if (Auth.getToken() != null && this.authenticated) {
                Response response = Api.request(Api.HttpMethod.GET, UserResponse.class, "user/mca/me", Map.of("token", Auth.getToken()));
                if (response instanceof UserResponse) {
                    UserResponse userResponse = (UserResponse)response;
                    this.currentUser = userResponse.user();
                    this.refreshContentList();
                } else {
                    this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.list_fetch_failed"));
                }
            }
        }).thenRunAsync(callback);
    }

    private void loadPage() {
        this.loadPage(false);
    }

    private void loadPage(boolean force) {
        if (this.lastLoadedPage == this.selectionPage && this.lastFilteredString.equals(this.filteredString) && !force) {
            return;
        }
        this.lastFilteredString = this.filteredString;
        this.lastLoadedPage = this.selectionPage;
        CompletableFuture.runAsync(() -> {
            Response response = Api.request(Api.HttpMethod.GET, ContentListResponse.class, "v2/content/mca", Map.of("whitelist", this.filteredString, "blacklist", (this.filterInvalidSkins ? "invalid" : "") + (this.filterHair ? ",hair" : "") + (this.filterClothing ? ",clothing" : ""), "order", this.sortingMode.order, "descending", "true", "offset", String.valueOf(this.selectionPage * 15), "limit", String.valueOf(15), "moderator", String.valueOf(this.moderatorMode), "token", String.valueOf(Auth.getToken())));
            if (response instanceof ContentListResponse) {
                ContentListResponse contentListResponse = (ContentListResponse)response;
                this.libraryContents = new ArrayList<LiteContent>(Arrays.asList(contentListResponse.contents()));
                this.refreshContentList();
            } else {
                this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.list_fetch_failed"));
            }
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        this.method_25420(context);
        this.hoveredContent = null;
        this.villagerVisualization.method_5614(0);
        this.villagerVisualization.method_18382();
        switch (this.page) {
            case LIBRARY: {
                int i = 0;
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 7 + y && this.contents.size() > i; ++i, ++x) {
                        LiteContent c = this.contents.get(i);
                        this.setDummyTexture(c);
                        int cx = this.field_22789 / 2 + (int)(((double)x - 3.5 + 0.5 - 0.5 * (double)(y % 2)) * 55.0);
                        int cy = this.field_22790 / 2 + 15 + (int)(((double)y - 1.0 + 0.5) * 80.0);
                        if (Math.abs(cx - mouseX) <= 15 && Math.abs(cy - mouseY - 25) <= 24) {
                            this.hoveredContent = c;
                            context.method_51434(this.field_22793, this.getMetaDataText(c), mouseX, mouseY);
                        }
                        this.villagerVisualization.getGenetics().setGender(SkinCache.getMeta(c).map(SkinMeta::getGender).orElse(Gender.MALE).binary());
                        class_490.method_2486((class_332)context, (int)cx, (int)cy, (int)(this.hoveredContent == c ? 30 : 28), (float)((float)(-(mouseX - cx)) / 2.0f), (float)((float)(-(mouseY - cy)) / 2.0f), (class_1309)this.villagerVisualization);
                    }
                }
                if (this.authenticated || this.subscriptionFilter != SubscriptionFilter.LIKED && this.subscriptionFilter != SubscriptionFilter.SUBMISSIONS) break;
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.like_locked"));
                break;
            }
            case EDITOR_LOCKED: {
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.locked"));
                break;
            }
            case EDITOR_PREPARE: {
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.drop"));
                break;
            }
            case EDITOR_TYPE: {
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.prepare"));
                break;
            }
            case DELETE: {
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.delete_confirm"));
                break;
            }
            case REPORT: {
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.report_confirm"));
                break;
            }
            case EDITOR: {
                SkinLocations.Part part;
                if (this.workspace.isDirty()) {
                    this.workspace.backendTexture.method_4524();
                    class_310.method_1551().method_1531().method_4616(CANVAS_IDENTIFIER, (class_1044)this.workspace.backendTexture);
                    this.workspace.setDirty(false);
                }
                int tw = 64;
                int th = 64;
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                matrices.method_22903();
                matrices.method_46416((float)this.field_22789 / 2.0f - (float)tw * 2.35f / 2.0f, (float)this.field_22790 / 2.0f - (float)th * 2.35f / 2.0f, 0.0f);
                matrices.method_22905(2.35f, 2.35f, 1.0f);
                float vx0 = class_3532.method_15363((float)0.0f, (float)this.x0, (float)this.x1);
                float vx1 = class_3532.method_15363((float)1.0f, (float)this.x0, (float)this.x1);
                float vy0 = class_3532.method_15363((float)0.0f, (float)this.y0, (float)this.y1);
                float vy1 = class_3532.method_15363((float)1.0f, (float)this.y0, (float)this.y1);
                float uvx0 = (vx0 - this.x0) / (this.x1 - this.x0);
                float uvx1 = (vx1 - this.x0) / (this.x1 - this.x0);
                float uvy0 = (vy0 - this.y0) / (this.y1 - this.y0);
                float uvy1 = (vy1 - this.y0) / (this.y1 - this.y0);
                RenderSystem.setShaderTexture((int)0, (class_2960)TEMPLATE_IDENTIFIER);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                WidgetUtils.drawTexturedQuad(matrices.method_23760().method_23761(), vx0 * 64.0f, vx1 * 64.0f, vy0 * 64.0f, vy1 * 64.0f, 0.0f, uvx0, uvx1, uvy0, uvy1);
                RenderSystem.setShaderTexture((int)0, (class_2960)CANVAS_IDENTIFIER);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                WidgetUtils.drawTexturedQuad(matrices.method_23760().method_23761(), vx0 * 64.0f, vx1 * 64.0f, vy0 * 64.0f, vy1 * 64.0f, 0.0f, uvx0, uvx1, uvy0, uvy1);
                WidgetUtils.drawRectangle(context, -1, -1, tw + 1, th + 1, -1426063361);
                matrices.method_22909();
                int x = (int)this.getPixelX();
                int y = (int)this.getPixelY();
                if (x >= 0 && x < 64 && y >= 0 && y < 64 && (part = SkinLocations.LOOKUP[x][y]) != null) {
                    class_2561 text = part.getTranslation();
                    int textWidth = this.field_22793.method_27525((class_5348)text);
                    context.method_51438(this.field_22793, text, this.field_22789 / 2 - textWidth / 2 - 12, this.field_22790 / 2 - 68);
                }
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.villagerVisualization.setHair(EMPTY_IDENTIFIER);
                    this.villagerVisualization.setClothes(CANVAS_IDENTIFIER);
                } else {
                    this.villagerVisualization.setHair(CANVAS_IDENTIFIER);
                    this.villagerVisualization.setClothes(EMPTY_IDENTIFIER);
                }
                int cx = this.field_22789 / 2 + 150;
                int cy = this.field_22790 / 2 - 10;
                this.villagerVisualization.getGenetics().setGender(this.workspace.gender.binary());
                WidgetUtils.drawBackgroundEntity(cx, cy, 50, (float)(-(mouseX - cx)) / 2.0f, (float)(-(mouseY - cy + 32)) / 2.0f, (class_1309)this.villagerVisualization);
                if (this.workspace.skinType != SkinType.HAIR) break;
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.skin_library.hair_color"), this.field_22789 / 2 - 150, this.field_22790 / 2 - 40, -1426063361);
                break;
            }
            case LOGIN: {
                if (!this.awaitingAuthentication) {
                    this.awaitingAuthentication = true;
                    CompletableFuture.runAsync(() -> {
                        try {
                            Response response;
                            String token = Auth.getToken();
                            Response response2 = response = token != null ? Api.request(Api.HttpMethod.GET, IsAuthResponse.class, "auth", Map.of("token", token)) : null;
                            if (response instanceof IsAuthResponse) {
                                IsAuthResponse authResponse = (IsAuthResponse)response;
                                if (authResponse.authenticated()) {
                                    this.authenticated = true;
                                    this.clearError();
                                    this.reloadDatabase();
                                    Auth.saveToken();
                                    this.setPage(Page.LIBRARY);
                                } else {
                                    Auth.clearToken();
                                    if (!this.isBrowserOpen) {
                                        this.setPage(Page.LIBRARY);
                                        this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.is_auth_failed"));
                                    }
                                }
                            } else {
                                this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.is_auth_failed"));
                            }
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            MCA.LOGGER.error((Object)e);
                        }
                        this.awaitingAuthentication = false;
                    });
                }
                if (this.isBrowserOpen) {
                    this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.authenticating_browser"));
                    break;
                }
                if (this.error != null) {
                    this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.authenticating"));
                    break;
                }
                this.drawTextBox(context, (class_2561)class_2561.method_43471((String)"gui.skin_library.authenticating").method_10852((class_2561)class_2561.method_43470((String)(" " + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L))))));
                break;
            }
            case DETAIL: {
                this.setDummyTexture(this.focusedContent);
                int cx = this.field_22789 / 2;
                int cy = this.field_22790 / 2 + 50;
                this.villagerVisualization.getGenetics().setGender(SkinCache.getMeta(this.focusedContent).map(SkinMeta::getGender).orElse(Gender.MALE).binary());
                class_490.method_2486((class_332)context, (int)cx, (int)cy, (int)60, (float)((float)(-(mouseX - cx)) / 2.0f), (float)((float)(-(mouseY - cy)) / 2.0f), (class_1309)this.villagerVisualization);
                context.method_51434(this.field_22793, this.getMetaDataText(this.focusedContent), this.field_22789 / 2 + 200, this.field_22790 / 2 - 50);
                break;
            }
            case LOADING: {
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.loading"), this.field_22789 / 2, this.field_22790 / 2, -1);
            }
        }
        if (this.error != null) {
            context.method_27534(this.field_22793, this.error, this.field_22789 / 2, this.field_22790 / 2, -65536);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void setDummyTexture(LiteContent content) {
        if (content.hasTag("clothing")) {
            this.villagerVisualization.setHair(EMPTY_IDENTIFIER);
            this.villagerVisualization.setClothes(SkinCache.getTextureIdentifier(content));
        } else {
            this.villagerVisualization.setHair(SkinCache.getTextureIdentifier(content));
            this.villagerVisualization.setClothes(EMPTY_IDENTIFIER);
        }
    }

    private List<class_2561> getMetaDataText(LiteContent content) {
        Optional<SkinMeta> meta = SkinCache.getMeta(content);
        if (meta.isEmpty()) {
            return List.of(class_2561.method_43470((String)content.title()));
        }
        List<class_2561> wrap = FlowingText.wrap((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", content.tags())).method_27692(class_124.field_1054), 160);
        ArrayList<class_5250> texts = new ArrayList<class_5250>(List.of(class_2561.method_43470((String)content.title()), class_2561.method_43469((String)"gui.skin_library.meta.by", (Object[])new Object[]{content.username()}).method_27692(class_124.field_1056), class_2561.method_43469((String)"gui.skin_library.meta.likes", (Object[])new Object[]{content.likes()}).method_27692(class_124.field_1080), class_2561.method_43469((String)"gui.skin_library.gender", (Object[])new Object[]{meta.get().getGender() == Gender.MALE ? class_2561.method_43471((String)"gui.villager_editor.masculine") : (meta.get().getGender() == Gender.FEMALE ? class_2561.method_43471((String)"gui.villager_editor.feminine") : class_2561.method_43471((String)"gui.villager_editor.neutral"))}), class_2561.method_43469((String)"gui.skin_library.profession", (Object[])new Object[]{meta.get().getProfession() == null ? class_2561.method_43471((String)"entity.minecraft.villager") : class_2561.method_43471((String)("entity.minecraft.villager." + meta.get().getProfession()))}), class_2561.method_43469((String)"gui.skin_library.temperature", (Object[])new Object[]{class_2561.method_43471((String)("gui.skin_library.temperature." + (meta.get().getTemperature() + 2)))}), class_2561.method_43469((String)"gui.skin_library.chance_val", (Object[])new Object[]{(int)(meta.get().getChance() * 100.0f)}).method_27692(class_124.field_1080)));
        texts.addAll(wrap);
        if (content.tags().contains("invalid")) {
            texts.add(class_2561.method_43471((String)"gui.skin_library.probably_not_valids").method_27692(class_124.field_1067).method_27692(class_124.field_1061));
        }
        return texts;
    }

    private double getScreenScaleX() {
        assert (this.field_22787 != null);
        return (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
    }

    private double getScreenScaleY() {
        assert (this.field_22787 != null);
        return (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507();
    }

    private double getCanvasX() {
        assert (this.field_22787 != null);
        double x = this.field_22787.field_1729.method_1603() * this.getScreenScaleX();
        return (x - (double)this.field_22789 / 2.0 + (double)75.2f) / (double)2.35f / 64.0;
    }

    private double getCanvasY() {
        assert (this.field_22787 != null);
        double y = this.field_22787.field_1729.method_1604() * this.getScreenScaleY();
        return (y - (double)this.field_22790 / 2.0 + (double)75.2f) / (double)2.35f / 64.0;
    }

    private float getPixelX() {
        double cx = this.getCanvasX();
        return (int)((cx - (double)this.x0) / (double)(this.x1 - this.x0) * 64.0);
    }

    private float getPixelY() {
        double cy = this.getCanvasY();
        return (int)((cy - (double)this.y0) / (double)(this.y1 - this.y0) * 64.0);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.mouseDeltaMoved(this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.method_16014(mouseX, mouseY);
    }

    protected void mouseDeltaMoved(double deltaX, double deltaY) {
        if (this.isPanning) {
            float ox = (float)(deltaX / 64.0 / (double)2.35f);
            this.x0 -= ox;
            this.x1 -= ox;
            float oy = (float)(deltaY / 64.0 / (double)2.35f);
            this.y0 -= oy;
            this.y1 -= oy;
            this.hasPanned = true;
        } else {
            this.hasPanned = false;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!(keyCode != 32 || this.textFieldWidget != null && this.textFieldWidget.method_25370())) {
            this.isPanning = true;
            return true;
        }
        if (!(this.page != Page.EDITOR || this.textFieldWidget != null && this.textFieldWidget.method_25370())) {
            if (keyCode == 82) {
                this.x0 = 0.0f;
                this.x1 = 1.0f;
                this.y0 = 0.0f;
                this.y1 = 1.0f;
                return true;
            }
            if (keyCode == 70) {
                this.workspace.fillDelete((int)this.getPixelX(), (int)this.getPixelY());
                return true;
            }
            if (keyCode == 89 || keyCode == 90) {
                this.workspace.undo();
                return true;
            }
            if (keyCode == 80) {
                this.pickColor();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.isPanning = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isPanning && this.activeMouseButton >= 0 && this.page == Page.EDITOR) {
            int x = (int)this.getPixelX();
            int y = (int)this.getPixelY();
            ClientUtils.bethlehemLine(this.lastPixelMouseX, this.lastPixelMouseY, x, y, this::paint);
            this.lastPixelMouseX = x;
            this.lastPixelMouseY = y;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.page == Page.EDITOR) {
            float zoom = (float)(amount * (double)0.2f) * (this.x1 - this.x0);
            float ox = this.getPixelX() / 64.0f;
            this.x0 -= zoom * ox;
            this.x1 += zoom * (1.0f - ox);
            float oy = this.getPixelY() / 64.0f;
            this.y0 -= zoom * oy;
            this.y1 += zoom * (1.0f - oy);
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25393() {
        super.method_25393();
        ++this.timeSinceLastRebuild;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.timeSinceLastRebuild < 2) {
            return false;
        }
        if (this.page == Page.EDITOR) {
            if (button == 0 || button == 1) {
                int y;
                this.activeMouseButton = button;
                int x = (int)this.getPixelX();
                if (this.workspace.validPixel(x, y = (int)this.getPixelY())) {
                    this.workspace.saveSnapshot(true);
                }
                if (!this.isPanning) {
                    this.paint(x, y);
                }
                this.lastPixelMouseX = x;
                this.lastPixelMouseY = y;
            } else if (button == 2) {
                this.isPanning = true;
            }
        } else if (this.hoveredContent != null) {
            if (this.previousScreen == null) {
                this.focusedContent = this.hoveredContent;
                this.setPage(Page.DETAIL);
            } else if (this.hoveredContent.hasTag("clothing")) {
                this.previousScreen.getVillager().setClothes("immersive_library:" + this.hoveredContent.contentid());
                this.returnToPreviousScreen();
            } else if (this.hoveredContent.hasTag("hair")) {
                this.previousScreen.getVillager().setHair("immersive_library:" + this.hoveredContent.contentid());
                this.returnToPreviousScreen();
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void returnToPreviousScreen() {
        this.previousScreen.syncVillagerData();
        if (this.previousScreen instanceof DestinyScreen) {
            this.method_25419();
        } else {
            this.previousScreen.method_25419();
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.activeMouseButton = -1;
        if (button == 2) {
            this.isPanning = false;
            if (!this.hasPanned && this.page == Page.EDITOR) {
                this.pickColor();
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void drawTextBox(class_332 context, class_2561 text) {
        List<class_2561> wrap = FlowingText.wrap(text, 220);
        int y = this.field_22790 / 2 - 20 - wrap.size() * 12;
        context.method_25294(this.field_22789 / 2 - 115, y - 5, this.field_22789 / 2 + 115, y + 12 * wrap.size(), 0x50000000);
        for (class_2561 t : wrap) {
            context.method_27534(this.field_22793, t, this.field_22789 / 2, y, -1);
            y += 12;
        }
    }

    private void paint(int x, int y) {
        if (this.page == Page.EDITOR && this.workspace.validPixel(x, y)) {
            if (this.activeMouseButton == 0) {
                this.workspace.currentImage.method_4305(x, y, this.color.getColor());
                this.workspace.setDirty(true);
            } else if (this.activeMouseButton == 1) {
                this.workspace.currentImage.method_4305(x, y, 0);
                this.workspace.setDirty(true);
            }
        }
    }

    private void pickColor() {
        int y;
        int x = (int)this.getPixelX();
        if (this.workspace.validPixel(x, y = (int)this.getPixelY())) {
            this.color.setRGB((double)(this.workspace.currentImage.method_35623(x, y) & 0xFF) / 255.0, (double)(this.workspace.currentImage.method_35625(x, y) & 0xFF) / 255.0, (double)(this.workspace.currentImage.method_35626(x, y) & 0xFF) / 255.0);
            if (this.workspace.skinType == SkinType.HAIR) {
                this.color.setHSV(0.0, 0.0, this.color.brightness);
            }
        }
    }

    private void rebuild() {
        this.method_37067();
        this.timeSinceLastRebuild = 0;
        if (this.page == Page.LIBRARY || this.page == Page.EDITOR_LOCKED || this.page == Page.EDITOR_PREPARE || this.page == Page.EDITOR_TYPE) {
            LinkedList<Page> b = new LinkedList<Page>();
            b.add(Page.LIBRARY);
            b.add(Page.EDITOR_PREPARE);
            b.add(Page.HELP);
            if (this.authenticated) {
                b.add(Page.LOGOUT);
            } else {
                b.add(Page.LOGIN);
            }
            int x = this.page == Page.LIBRARY ? this.field_22789 / 2 - 20 : this.field_22789 / 2 - 110;
            int w = 220 / b.size();
            for (Page page : b) {
                ((ButtonWidget)this.method_37063((class_364)new ButtonWidget((int)x, (int)(this.field_22790 / 2 - 110), (int)w, (int)20, (class_2561)class_2561.method_43471((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"gui.skin_library.page.\u0001"}, (String)page.name().toLowerCase((Locale)Locale.ROOT)))), (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$rebuild$4(quilt.net.mca.client.gui.SkinLibraryScreen$Page net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)((SkinLibraryScreen)this, (Page)page)))).field_22763 = page != this.page;
                x += w;
            }
        }
        switch (this.page) {
            case LIBRARY: {
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 30 - 30, this.field_22790 / 2 + 80, 30, 20, (class_2561)class_2561.method_43470((String)"<<"), sender -> {
                    this.setSelectionPage(this.selectionPage - 1);
                    this.refreshContentList();
                }));
                this.pageWidget = (ButtonWidget)this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 30, this.field_22790 / 2 + 80, 60, 20, (class_2561)class_2561.method_43470((String)""), sender -> {}));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 30, this.field_22790 / 2 + 80, 30, 20, (class_2561)class_2561.method_43470((String)">>"), sender -> {
                    this.setSelectionPage(this.selectionPage + 1);
                    this.refreshContentList();
                }));
                this.setSelectionPage(this.selectionPage);
                int iconX = this.field_22789 / 2 + 80;
                this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX, this.field_22790 / 2 + 82, 96, 48, this.sortingMode == SortingMode.LIKES, class_2561.method_43471((String)"gui.skin_library.sort_likes"), v -> {
                    this.sortingMode = SortingMode.LIKES;
                    this.loadPage(true);
                }));
                this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX + 22, this.field_22790 / 2 + 82, 112, 48, this.sortingMode == SortingMode.NEWEST, class_2561.method_43471((String)"gui.skin_library.sort_newest"), v -> {
                    this.sortingMode = SortingMode.NEWEST;
                    this.loadPage(true);
                }));
                if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                    this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX + 44, this.field_22790 / 2 + 82, 144, 48, this.filterInvalidSkins, class_2561.method_43471((String)"gui.skin_library.filter_invalid"), v -> {
                        this.filterInvalidSkins = !this.filterInvalidSkins;
                        this.loadPage(true);
                    }));
                    this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX + 66, this.field_22790 / 2 + 82, 192, 48, this.filterClothing, class_2561.method_43471((String)"gui.skin_library.filter_clothing"), v -> {
                        this.filterClothing = !this.filterClothing;
                        this.loadPage(true);
                    }));
                    this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX + 88, this.field_22790 / 2 + 82, 208, 48, this.filterHair, class_2561.method_43471((String)"gui.skin_library.filter_hair"), v -> {
                        this.filterHair = !this.filterHair;
                        this.loadPage(true);
                    }));
                    if (this.isModerator()) {
                        this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(iconX + 110, this.field_22790 / 2 + 82, 176, 48, this.moderatorMode, class_2561.method_43471((String)"gui.skin_library.filter_moderator"), v -> {
                            this.moderatorMode = !this.moderatorMode;
                            this.loadPage(true);
                        }));
                    }
                }
                if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                    class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 200 + 65, this.field_22790 / 2 - 110 + 2, 110, 16, (class_2561)class_2561.method_43471((String)"gui.skin_library.search")));
                    textFieldWidget.method_1880(64);
                    textFieldWidget.method_1852(this.filteredString);
                    if (this.filteredString.isEmpty()) {
                        textFieldWidget.method_1887("Search");
                    }
                    textFieldWidget.method_1863(s -> {
                        this.filteredString = s;
                        this.refreshContentList();
                        textFieldWidget.method_1887(null);
                    });
                }
                this.method_37063((class_364)class_5676.method_32606(SubscriptionFilter::getText).method_32624((Object[])SubscriptionFilter.values()).method_32619((Object)this.subscriptionFilter).method_32616().method_32617(this.field_22789 / 2 - 200, this.field_22790 / 2 - 110, 60, 20, (class_2561)class_2561.method_43470((String)""), (button, filter) -> {
                    this.subscriptionFilter = filter;
                    this.refreshContentList();
                }));
                int i = 0;
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 7 + y && this.contents.size() > i; ++i, ++x) {
                        LiteContent c = this.contents.get(i);
                        int cx = this.field_22789 / 2 + (int)(((double)x - 3.5 + 0.5 - 0.5 * (double)(y % 2)) * 55.0);
                        int cy = this.field_22790 / 2 + 15 + (int)(((double)y - 1.0 + 0.5) * 80.0);
                        this.drawControls(c, false, cx, cy);
                        if (this.isModerator()) {
                            this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(cx + 16, cy - 48, 160, 48, false, class_2561.method_43470((String)"Toggle invalid"), v -> this.setTag(c.contentid(), "invalid", !c.hasTag("invalid"))));
                        }
                        if (!c.tags().contains("invalid")) continue;
                        this.method_37063((class_364)new ToggleableTooltipIconButtonWidget(cx + 12, cy - 16, 144, 48, true, class_2561.method_43471((String)"gui.skin_library.probably_not_valids"), v -> {}));
                    }
                }
                break;
            }
            case EDITOR_PREPARE: {
                class_342 textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 90, this.field_22790 / 2 - 18, 180, 16, (class_2561)class_2561.method_43470((String)"URL")));
                textFieldWidget.method_1880(1024);
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 + 5, 100, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.load_image"), sender -> this.loadImage(textFieldWidget.method_1882())));
                break;
            }
            case EDITOR_TYPE: {
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 100, this.field_22790 / 2, 95, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.prepare.hair"), v -> {
                    this.workspace.skinType = SkinType.HAIR;
                    this.color.setHSV(0.0, 0.0, 0.5);
                    this.setPage(Page.EDITOR);
                }));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2, 95, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.prepare.clothing"), v -> {
                    this.workspace.skinType = SkinType.CLOTHING;
                    this.setPage(Page.EDITOR);
                }));
                this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 - 10, this.field_22790 / 2 + 30, 20, 20, class_2561.method_43470((String)"?"), class_2561.method_43471((String)"gui.skin_library.help"), v -> this.openHelp()));
                break;
            }
            case LOGIN: {
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 + 25, 100, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.cancel"), v -> this.setPage(Page.LIBRARY)));
                break;
            }
            case DETAIL: {
                if (this.canModifyFocusedContent()) {
                    class_342 tagNameWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 200, this.field_22790 / 2 - 100 + 2, 95, 16, (class_2561)class_2561.method_43470((String)"")));
                    tagNameWidget.method_1880(20);
                    tagNameWidget.method_1887("New Tag Name");
                    tagNameWidget.method_1863(v -> tagNameWidget.method_1887(null));
                    this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 - 100, this.field_22790 / 2 - 100, 40, 20, "gui.skin_library.add", sender -> {
                        String tag = tagNameWidget.method_1882().trim().toLowerCase(Locale.ROOT);
                        if (!tag.isEmpty()) {
                            this.setTag(this.focusedContent.contentid(), tag, true);
                            tagNameWidget.method_1852("");
                            this.rebuild();
                        }
                    }));
                }
                this.drawControls(this.focusedContent, true, this.field_22789 / 2 + 130, this.field_22790 / 2 + 60);
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 40, this.field_22790 / 2 + 60, 80, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.close"), v -> this.setPage(Page.LIBRARY)));
                int ty = this.field_22790 / 2 - 70;
                for (String tag : this.focusedContent.tags()) {
                    if ((tag.equals("clothing") || tag.equals("hair") || tag.equals("invalid")) && !this.isModerator()) continue;
                    int w = this.field_22793.method_1727(tag) + 10;
                    if (this.canModifyFocusedContent()) {
                        this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 200, ty, 20, 20, (class_2561)class_2561.method_43470((String)"X"), v -> {
                            this.setTag(this.focusedContent.contentid(), tag, false);
                            this.rebuild();
                        }));
                    }
                    this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 200 + 20, ty, w, 20, (class_2561)class_2561.method_43470((String)tag), v -> {}));
                    ty += 20;
                }
                break;
            }
            case DELETE: {
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 65, this.field_22790 / 2, 60, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.cancel"), v -> this.setPage(Page.DETAIL)));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2, 60, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.delete"), v -> {
                    this.removeContent(this.deleteConfirmationContent.contentid());
                    this.setPage(Page.LIBRARY);
                }));
                break;
            }
            case REPORT: {
                this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 - 105, this.field_22790 / 2, 100, 20, class_2561.method_43471((String)"gui.skin_library.report_invalid"), class_2561.method_43471((String)"gui.skin_library.report_invalid_tooltip"), v -> {
                    this.reportContent(this.reportConfirmationContent.contentid(), "INVALID");
                    this.setPage(Page.DETAIL);
                }));
                this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2, 100, 20, class_2561.method_43471((String)"gui.skin_library.report_default"), class_2561.method_43471((String)"gui.skin_library.report_default_tooltip"), v -> {
                    this.reportContent(this.reportConfirmationContent.contentid(), "DEFAULT");
                    this.setPage(Page.DETAIL);
                }));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 + 22, 100, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.cancel"), v -> this.setPage(Page.DETAIL)));
                if (!this.isModerator()) break;
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 50, this.field_22790 / 2 + 44, 100, 20, (class_2561)class_2561.method_43470((String)"Counter Report"), v -> {
                    this.reportContent(this.reportConfirmationContent.contentid(), "COUNTER_DEFAULT");
                    this.setPage(Page.DETAIL);
                }));
                break;
            }
            case EDITOR: {
                this.textFieldWidget = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_22789 / 2 - 60, this.field_22790 / 2 - 105, 120, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.name")));
                this.textFieldWidget.method_1880(1024);
                this.textFieldWidget.method_1852(this.workspace.title);
                if (this.workspace.title.isEmpty()) {
                    this.textFieldWidget.method_1887(this.workspace.title);
                }
                this.textFieldWidget.method_25365(false);
                this.textFieldWidget.method_1863(v -> {
                    this.workspace.title = v;
                    this.textFieldWidget.method_1887(null);
                });
                this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 65, this.field_22790 / 2 - 105, 20, 20, class_2561.method_43470((String)"?"), class_2561.method_43471((String)"gui.skin_library.tool_help"), v -> this.openHelp()));
                this.method_37063((class_364)class_5676.method_32606(Gender::getText).method_32624((Object[])new Gender[]{Gender.MALE, Gender.NEUTRAL, Gender.FEMALE}).method_32619((Object)this.workspace.gender).method_32616().method_32617(this.field_22789 / 2 - 200, this.field_22790 / 2 - 80, 105, 20, (class_2561)class_2561.method_43470((String)""), (button, gender) -> {
                    this.workspace.gender = gender;
                }));
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 - 200, this.field_22790 / 2 - 60, 105, 20, this.workspace.temperature, -2, 2, v -> {
                        this.workspace.temperature = v;
                    }, v -> class_2561.method_43471((String)("gui.skin_library.temperature." + (v + 2))), () -> class_2561.method_43471((String)"gui.skin_library.temperature.tooltip")));
                }
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    int ox = 0;
                    int oy = 0;
                    LinkedList<ItemButtonWidget> widgets = new LinkedList<ItemButtonWidget>();
                    for (class_3852 profession : class_7923.field_41195) {
                        class_5250 text = class_2561.method_43471((String)("entity.minecraft.villager." + profession.comp_818()));
                        ItemButtonWidget widget = (ItemButtonWidget)this.method_37063((class_364)new ItemButtonWidget(this.field_22789 / 2 - 200 + ox * 21, this.field_22790 / 2 - 30 + oy * 21, 20, text, ProfessionIcons.ICONS.getOrDefault(profession.comp_818(), class_1802.field_17535.method_7854()), v -> {
                            this.workspace.profession = profession == class_3852.field_17051 ? null : profession.comp_818();
                            widgets.forEach(b -> {
                                b.field_22763 = true;
                            });
                            v.field_22763 = false;
                        }));
                        widget.field_22763 = !Objects.equals(this.workspace.profession, profession == class_3852.field_17051 ? null : profession.comp_818());
                        widgets.add(widget);
                        if (++ox < 5) continue;
                        ox = 0;
                        ++oy;
                    }
                }
                int y = this.field_22790 / 2 - 5;
                if (this.workspace.skinType == SkinType.CLOTHING) {
                    this.color.hueWidget = (HorizontalColorPickerWidget)this.method_37063((class_364)new HorizontalColorPickerWidget(this.field_22789 / 2 + 100, y, 100, 15, this.color.hue / 360.0, MCA.locate("textures/colormap/hue.png"), (vx, vy) -> this.color.setHSV(vx * 360.0, this.color.saturation, this.color.brightness)));
                    this.color.saturationWidget = (HorizontalColorPickerWidget)this.method_37063((class_364)new HorizontalGradientWidget(this.field_22789 / 2 + 100, y + 20, 100, 15, this.color.saturation, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 0.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, () -> {
                        double[] doubles = ClientUtils.HSV2RGB(this.color.hue, 1.0, 1.0);
                        return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                    }, (vx, vy) -> this.color.setHSV(this.color.hue, (double)vx, this.color.brightness)));
                }
                this.color.brightnessWidget = (HorizontalColorPickerWidget)this.method_37063((class_364)new HorizontalGradientWidget(this.field_22789 / 2 + 100, y + 40, 100, 15, this.color.brightness, () -> {
                    double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 0.0);
                    return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                }, () -> {
                    double[] doubles = ClientUtils.HSV2RGB(this.color.hue, this.color.saturation, 1.0);
                    return new float[]{(float)doubles[0], (float)doubles[1], (float)doubles[2], 1.0f};
                }, (vx, vy) -> this.color.setHSV(this.color.hue, this.color.saturation, (double)vx)));
                this.method_37063((class_364)new IntegerSliderWidget(this.field_22789 / 2 + 100, y + 60, 100, 20, this.workspace.fillToolThreshold, 0, 128, v -> {
                    this.workspace.fillToolThreshold = v;
                }, v -> class_2561.method_43471((String)"gui.skin_library.fillToolThreshold"), () -> class_2561.method_43471((String)"gui.skin_library.fillToolThreshold.tooltip")));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 100, y + 85, 100, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.undo"), v -> this.workspace.undo()));
                if (this.workspace.skinType == SkinType.HAIR) {
                    this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 100, y - 20, 100, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.remove_saturation"), v -> this.workspace.removeSaturation()));
                    this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 100, y, 50, 20, class_2561.method_43470((String)"C -"), class_2561.method_43471((String)"gui.skin_library.less_contrast"), v -> this.workspace.addContrast(-0.15f)));
                    this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 150, y, 50, 20, class_2561.method_43470((String)"C +"), class_2561.method_43471((String)"gui.skin_library.more_contrast"), v -> this.workspace.addContrast(0.15f)));
                    this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 100, y + 20, 50, 20, class_2561.method_43470((String)"B -"), class_2561.method_43471((String)"gui.skin_library.less_brightness"), v -> this.workspace.addBrightness(-8)));
                    this.method_37063((class_364)new TooltipButtonWidget(this.field_22789 / 2 + 150, y + 20, 50, 20, class_2561.method_43470((String)"B +"), class_2561.method_43471((String)"gui.skin_library.more_brightness"), v -> this.workspace.addBrightness(8)));
                    Genetics genetics = this.villagerVisualization.getGenetics();
                    this.method_37063((class_364)new ColorPickerWidget(this.field_22789 / 2 - 200, this.field_22790 / 2 - 30, 100, 100, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                        genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                        genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                    }));
                }
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 80, this.field_22790 / 2 + 80, 75, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.cancel"), v -> this.setPage(Page.LIBRARY)));
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 + 5, this.field_22790 / 2 + 80, 75, 20, (class_2561)class_2561.method_43471((String)"gui.skin_library.publish"), v -> this.publish()));
            }
        }
    }

    private void drawControls(LiteContent content, boolean advanced, int cx, int cy) {
        int w = advanced ? 20 : 16;
        LinkedList<ToggleableTooltipIconButtonWidget> widgets = new LinkedList<ToggleableTooltipIconButtonWidget>();
        if (this.isOp() || Config.getServerConfig().allowEveryoneToAddContentGlobally) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 0, 48, this.getServerContentById(content.contentid()).isPresent(), class_2561.method_43471((String)"gui.skin_library.subscribe"), v -> {
                if (((ToggleableTooltipButtonWidget)v).toggle) {
                    NetworkHandler.sendToServer(new RemoveCustomClothingMessage(content.hasTag("clothing") ? RemoveCustomClothingMessage.Type.CLOTHING : RemoveCustomClothingMessage.Type.HAIR, new class_2960("immersive_library", String.valueOf(content.contentid()))));
                } else {
                    this.toListEntry(content).ifPresent(e -> NetworkHandler.sendToServer(new AddCustomClothingMessage((SkinListEntry)e)));
                }
                ((ToggleableTooltipButtonWidget)v).toggle = !((ToggleableTooltipButtonWidget)v).toggle;
            }));
        }
        if (this.authenticated) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 16, 48, this.isLiked(content), class_2561.method_43471((String)"gui.skin_library.like"), v -> {
                ((ToggleableTooltipButtonWidget)v).toggle = !((ToggleableTooltipButtonWidget)v).toggle;
                this.setLike(content.contentid(), ((ToggleableTooltipButtonWidget)v).toggle);
            }));
        }
        if (advanced && this.canModifyContent(content)) {
            widgets.add(new ToggleableTooltipIconButtonWidget(0, 0, 32, 48, false, class_2561.method_43471((String)"gui.skin_library.edit"), v -> SkinCache.getImage(content).ifPresent(image -> SkinCache.getMeta(content).ifPresent(meta -> {
                this.workspace = new Workspace((class_1011)image, (SkinMeta)meta, content);
                this.setPage(Page.EDITOR);
                if (this.workspace.skinType == SkinType.HAIR) {
                    this.color.setHSV(0.0, 0.0, 0.5);
                }
            }))));
        }
        if (advanced && this.authenticated) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 160, 48, true, class_2561.method_43471((String)"gui.skin_library.report"), v -> {
                this.reportConfirmationContent = content;
                this.setPage(Page.REPORT);
            }));
        }
        if (advanced && this.canModifyContent(content)) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 48, 48, true, class_2561.method_43471((String)"gui.skin_library.delete"), v -> {
                this.deleteConfirmationContent = content;
                this.setPage(Page.DELETE);
            }));
        }
        if (!advanced) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 64, 64, true, class_2561.method_43471((String)"gui.skin_library.details"), v -> {
                if (this.isPanning && this.isModerator()) {
                    this.reportContent(content.contentid(), "DEFAULT");
                    this.refreshContentList();
                } else {
                    this.focusedContent = content;
                    this.setPage(Page.DETAIL);
                }
            }));
        }
        if (advanced && this.isModerator()) {
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 80, 48, false, class_2561.method_43471((String)"gui.skin_library.ban"), v -> {
                this.setBan(content.userid(), true);
                this.refreshContentList();
            }));
            widgets.add(new ToggleableTooltipIconButtonWidget(cx - 12 + 25, cy, 176, 48, false, class_2561.method_43471((String)"gui.skin_library.unban"), v -> {
                this.setBan(content.userid(), false);
                this.refreshContentList();
            }));
        }
        int wx = cx - widgets.size() * w / 2;
        for (TooltipButtonWidget tooltipButtonWidget : widgets) {
            this.method_37063((class_364)tooltipButtonWidget);
            tooltipButtonWidget.method_46421(wx);
            tooltipButtonWidget.method_46419(cy);
            wx += w;
        }
    }

    private Optional<SkinListEntry> toListEntry(LiteContent content) {
        return SkinCache.getMeta(content).map(meta -> {
            if (content.hasTag("clothing")) {
                return new Clothing("immersive_library:" + content.contentid(), meta.getProfession(), meta.getTemperature(), false, meta.getGender());
            }
            return new Hair("immersive_library:" + content.contentid());
        });
    }

    private boolean canModifyFocusedContent() {
        return this.canModifyContent(this.focusedContent);
    }

    private boolean canModifyContent(LiteContent content) {
        return this.currentUser != null && (this.currentUser.moderator() || this.currentUser.userid() == content.userid());
    }

    private boolean isModerator() {
        return this.currentUser != null && this.currentUser.moderator();
    }

    private boolean isLiked(LiteContent content) {
        return this.currentUser != null && this.currentUser.likes().stream().anyMatch(c -> c.contentid() == content.contentid());
    }

    public void setPage(Page page) {
        if (Thread.currentThread() != this.thread) {
            assert (this.field_22787 != null);
            this.field_22787.method_40000(() -> this.setPage(page));
            return;
        }
        this.clearError();
        if (!(page != Page.EDITOR_TYPE && page != Page.EDITOR_PREPARE || this.authenticated)) {
            this.setPage(Page.EDITOR_LOCKED);
            return;
        }
        if (page == Page.HELP) {
            this.openHelp();
            return;
        }
        if (page == Page.LOGIN) {
            if (Auth.loadToken() == null) {
                this.isBrowserOpen = true;
                Auth.authenticate(this.getPlayerName());
            } else {
                this.isBrowserOpen = false;
            }
        }
        if (page == Page.LOGOUT) {
            this.authenticated = false;
            this.currentUser = null;
            Auth.clearToken();
            this.refreshPage();
            return;
        }
        this.page = page;
        if (page == Page.EDITOR) {
            this.x0 = 0.0f;
            this.x1 = 1.0f;
            this.y0 = 0.0f;
            this.y1 = 1.0f;
            this.uploading = false;
        }
        if (page == Page.LIBRARY) {
            this.refreshContentList();
        } else {
            this.rebuild();
        }
    }

    private void openHelp() {
        try {
            class_156.method_668().method_673(URI.create("https://github.com/Luke100000/minecraft-comes-alive/wiki/Skin-Editor"));
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
        }
    }

    private void refreshContentList() {
        if (Thread.currentThread() != this.thread) {
            assert (this.field_22787 != null);
            this.field_22787.method_40000(this::refreshContentList);
            return;
        }
        this.refreshServerContent();
        List<LiteContent> newList = switch (this.subscriptionFilter) {
            case SubscriptionFilter.LIBRARY -> {
                this.loadPage();
                yield this.libraryContents;
            }
            case SubscriptionFilter.GLOBAL -> this.serverContent;
            case SubscriptionFilter.LIKED -> this.currentUser != null ? this.currentUser.likes() : Collections.emptyList();
            case SubscriptionFilter.SUBMISSIONS -> this.currentUser != null ? this.currentUser.submissions() : Collections.emptyList();
            default -> throw new IllegalStateException("Unexpected value: " + this.subscriptionFilter);
        };
        if (this.subscriptionFilter != SubscriptionFilter.LIBRARY && !newList.isEmpty()) {
            newList = this.selectionPage * 15 >= newList.size() ? new LinkedList() : newList.subList(this.selectionPage * 15, Math.min(newList.size(), (this.selectionPage + 1) * 15));
        }
        this.contents.clear();
        this.contents.addAll(newList);
        if (this.contents.isEmpty() && this.selectionPage > 0) {
            --this.selectionPage;
            if (this.subscriptionFilter == SubscriptionFilter.LIBRARY) {
                this.loadPage();
            } else {
                this.refreshContentList();
            }
            return;
        }
        this.rebuild();
        this.setSelectionPage(this.selectionPage);
    }

    private String getPlayerName() {
        return class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_7334().getName();
    }

    private boolean isOp() {
        return class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_5687(4);
    }

    private void setSelectionPage(int p) {
        if (this.pageWidget != null) {
            this.selectionPage = Math.max(0, p);
            this.pageWidget.method_25355((class_2561)class_2561.method_43469((String)"gui.villager_editor.page", (Object[])new Object[]{this.selectionPage + 1}));
        }
    }

    public void method_29638(List<Path> paths) {
        Path path = paths.get(0);
        this.loadImage(path.toString());
    }

    private void loadImage(String path) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                MCA.LOGGER.error((Object)e);
            }
        }
        if (stream != null) {
            try {
                class_1011 image = class_1011.method_4309((InputStream)stream);
                stream.close();
                if (image.method_4307() == 64 && image.method_4323() == 64) {
                    if (SkinPorter.isSlimFormat(image)) {
                        SkinPorter.convertSlimToDefault(image);
                    }
                    this.workspace = new Workspace(image);
                    this.setPage(Page.EDITOR_TYPE);
                } else if (image.method_4307() == 64 && image.method_4323() == 32) {
                    this.workspace = new Workspace(SkinPorter.portLegacySkin(image));
                    this.setPage(Page.EDITOR_TYPE);
                } else {
                    this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.not_64"));
                }
            }
            catch (IOException e) {
                MCA.LOGGER.error((Object)e);
            }
        }
    }

    private void publish() {
        if (this.workspace.title.equals("Unnamed Asset")) {
            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.choose_name"));
            return;
        }
        if (!Utils.verify(this.workspace.currentImage)) {
            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.read_the_help"));
            return;
        }
        if (this.workspace.skinType == SkinType.HAIR && !Utils.verifyHair(this.workspace.currentImage) && !this.skipHairWarning) {
            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.read_the_help_hair"));
            this.skipHairWarning = true;
            return;
        }
        this.skipHairWarning = false;
        if (!this.uploading) {
            this.uploading = true;
            CompletableFuture.runAsync(() -> {
                if (Auth.getToken() != null) {
                    Response request = null;
                    try {
                        request = Api.request(this.workspace.contentid == -1 ? Api.HttpMethod.POST : Api.HttpMethod.PUT, this.workspace.contentid == -1 ? ContentIdResponse.class : SuccessResponse.class, (String)(this.workspace.contentid == -1 ? "content/mca" : "content/mca/" + this.workspace.contentid), Map.of("token", Auth.getToken()), Map.of("title", this.workspace.title, "meta", this.workspace.toListEntry().toJson().toString(), "data", new String(Base64.getEncoder().encode(this.workspace.currentImage.method_24036()))));
                    }
                    catch (IOException e) {
                        MCA.LOGGER.error((Object)e);
                    }
                    if (request instanceof ContentIdResponse || request instanceof SuccessResponse) {
                        Response finalRequest = request;
                        this.reloadDatabase(() -> {
                            int n;
                            if (finalRequest instanceof ContentIdResponse) {
                                ContentIdResponse response = (ContentIdResponse)finalRequest;
                                n = response.contentid();
                            } else {
                                n = this.workspace.contentid;
                            }
                            int contentid = n;
                            this.setTag(contentid, this.workspace.skinType.name().toLowerCase(Locale.ROOT), true);
                            if (this.workspace.profession != null) {
                                this.setTag(contentid, this.workspace.profession.replace("mca.", ""), true);
                            }
                            this.getSubmittedContent(contentid).or(() -> this.getContentById(contentid)).ifPresent(content -> {
                                this.focusedContent = content;
                                this.setPage(Page.DETAIL);
                                this.uploading = false;
                            });
                            SkinCache.enforceSync(contentid);
                        });
                    } else if (request instanceof ErrorResponse) {
                        ErrorResponse response = (ErrorResponse)request;
                        if (response.code() == 428) {
                            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.upload_duplicate"));
                        } else {
                            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.upload_failed"));
                        }
                        this.uploading = false;
                    }
                }
            });
        } else {
            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.already_uploading"));
        }
    }

    private Optional<LiteContent> getContentById(int contentid) {
        return Stream.concat(this.libraryContents.stream(), this.serverContent.stream()).filter(v -> v.contentid() == contentid).findAny();
    }

    private Optional<LiteContent> getServerContentById(int contentid) {
        return this.serverContent.stream().filter(v -> v.contentid() == contentid).findAny();
    }

    private Optional<LiteContent> getSubmittedContent(int contentid) {
        return this.currentUser == null ? Optional.empty() : this.currentUser.submissions().stream().filter(v -> v.contentid() == contentid).findAny();
    }

    private void setTag(int contentid, String tag, boolean add) {
        if (Auth.getToken() != null) {
            Api.request(add ? Api.HttpMethod.POST : Api.HttpMethod.DELETE, SuccessResponse.class, "tag/mca/" + contentid + "/" + tag, Map.of("token", Auth.getToken()));
            this.getContentById(contentid).ifPresent(c -> {
                if (add) {
                    c.tags().add(tag);
                } else {
                    c.tags().remove(tag);
                }
            });
            this.getSubmittedContent(contentid).ifPresent(c -> {
                if (add) {
                    c.tags().add(tag);
                } else {
                    c.tags().remove(tag);
                }
            });
        }
    }

    private void removeContent(int contentId) {
        if (Auth.getToken() != null) {
            Api.request(Api.HttpMethod.DELETE, SuccessResponse.class, "content/mca/" + contentId, Map.of("token", Auth.getToken()));
            this.removeContentLocally(contentId);
        }
    }

    private void removeContentLocally(int contentId) {
        this.libraryContents.removeIf(v -> v.contentid() == contentId);
        if (this.currentUser != null) {
            this.currentUser.likes().removeIf(v -> v.contentid() == contentId);
            this.currentUser.submissions().removeIf(v -> v.contentid() == contentId);
        }
    }

    private void reportContent(int contentId, String reason) {
        if (Auth.getToken() != null) {
            Api.request(Api.HttpMethod.POST, SuccessResponse.class, "report/mca/" + contentId + "/" + reason, Map.of("token", Auth.getToken()));
            if (reason.equals("DEFAULT")) {
                this.removeContentLocally(contentId);
            }
            this.setError((class_2561)class_2561.method_43471((String)"gui.skin_library.reported"));
        }
    }

    private void setLike(int contentid, boolean add) {
        if (Auth.getToken() != null && this.currentUser != null) {
            Api.request(add ? Api.HttpMethod.POST : Api.HttpMethod.DELETE, SuccessResponse.class, "like/mca/" + contentid, Map.of("token", Auth.getToken()));
            if (add) {
                this.getContentById(contentid).ifPresent(this.currentUser.likes()::add);
            } else {
                this.currentUser.likes().removeIf(v -> v.contentid() == contentid);
            }
        }
    }

    private void setBan(int userid, boolean banned) {
        if (Auth.getToken() != null && this.currentUser != null) {
            Api.request(Api.HttpMethod.PUT, SuccessResponse.class, "user/" + userid, Map.of("token", Auth.getToken(), "banned", Boolean.toString(banned)));
        }
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(class_2561 text) {
        this.error = text;
    }

    private <T> void addServerContent(Map<String, T> map, String type) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("immersive_library:")) continue;
            try {
                int contentid = Integer.parseInt(entry.getKey().substring(18));
                this.serverContent.add(this.getContentById(contentid).orElse(new LiteContent(contentid, -1, "unknown", -1, Set.of(type), "unknown", -1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void skinListUpdatedCallback() {
        this.refreshServerContent();
        if (this.page == Page.LIBRARY) {
            this.refreshContentList();
        }
    }

    private void refreshServerContent() {
        this.serverContent.clear();
        this.addServerContent(VillagerEditorScreen.getClothing(), "clothing");
        this.addServerContent(VillagerEditorScreen.getHair(), "hair");
    }

    private /* synthetic */ void lambda$rebuild$4(Page page, class_4185 sender) {
        this.setPage(page);
    }

    public static enum SortingMode {
        LIKES("likes"),
        NEWEST("date"),
        REPORTS("reports");

        public final String order;

        private SortingMode(String order) {
            this.order = order;
        }
    }

    public static enum SubscriptionFilter {
        LIBRARY,
        GLOBAL,
        LIKED,
        SUBMISSIONS;


        public static class_2561 getText(SubscriptionFilter t) {
            return class_2561.method_43471((String)("gui.skin_library.subscription_filter." + t.name().toLowerCase(Locale.ROOT)));
        }
    }

    public static enum Page {
        LIBRARY,
        EDITOR_LOCKED,
        EDITOR_PREPARE,
        EDITOR_TYPE,
        EDITOR,
        HELP,
        LOGIN,
        LOGOUT,
        DETAIL,
        DELETE,
        LOADING,
        REPORT;

    }

    public static enum SkinType {
        CLOTHING,
        HAIR;

    }
}

