/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.chatAI;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.chatAI.ChatAIStrategy;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.EnvironmentModule;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.PersonalityModule;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.PlayerModule;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.RelationModule;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.TraitsModule;
import forge.net.mca.entity.ai.chatAI.gpt3Modules.VillageModule;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import org.apache.commons.io.IOUtils;

public class GPT3
implements ChatAIStrategy {
    private static final int MIN_MEMORY = 100;
    private static final int MAX_MEMORY = 600;
    private static final int MAX_MEMORY_TIME = 54000;
    private static final Map<UUID, List<Tuple<String, String>>> memory = new HashMap<UUID, List<Tuple<String, String>>>();
    private static final Map<UUID, Long> lastInteractions = new HashMap<UUID, Long>();

    public static String translate(String phrase) {
        return phrase.replace("_", " ").toLowerCase(Locale.ROOT).replace("mca.", "");
    }

    public static Answer post(String url, String requestBody, String token) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Authorization", "Bearer " + token);
            con.setDoOutput(true);
            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                wr.write(requestBody.getBytes(StandardCharsets.UTF_8));
                wr.flush();
            }
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String message = map.has("choices") ? map.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").getAsJsonPrimitive("content").getAsString() : null;
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
            message = message == null ? null : GPT3.cleanupAnswer(message);
            return new Answer(message, error);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "unknown");
        }
    }

    public static Answer request(String encodedURL) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(encodedURL).openConnection();
            con.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.toString());
            InputStream response = con.getInputStream();
            String body = IOUtils.toString((InputStream)response, (Charset)StandardCharsets.UTF_8);
            JsonObject map = JsonParser.parseString((String)body).getAsJsonObject();
            String answer = map.has("answer") ? map.get("answer").getAsString().trim().replace("\n", " ") : "";
            String error = map.has("error") ? map.get("error").getAsString().trim().replace("\n", " ") : null;
            return new Answer(answer, error);
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            return new Answer(null, "unknown");
        }
    }

    @Override
    public Optional<String> answer(ServerPlayer player, VillagerEntityMCA villager, String msg) {
        try {
            String playerName = player.m_7755_().getString();
            String villagerName = villager.m_7755_().getString();
            long time = villager.m_9236_().m_46467_();
            if (time > lastInteractions.getOrDefault(villager.m_20148_(), 0L) + 54000L) {
                memory.remove(villager.m_20148_());
            }
            lastInteractions.put(villager.m_20148_(), time);
            List pastDialogue = memory.computeIfAbsent(villager.m_20148_(), key -> new LinkedList());
            int memory = 100 + Math.min(5, Config.getInstance().villagerChatAIIntelligence) * 500 / 5;
            while (pastDialogue.stream().mapToInt(v -> ((String)v.m_14419_()).length() / 4).sum() > memory) {
                pastDialogue.remove(0);
            }
            LinkedList<String> input = new LinkedList<String>();
            PersonalityModule.apply(input, villager, player);
            TraitsModule.apply(input, villager, player);
            RelationModule.apply(input, villager, player);
            VillageModule.apply(input, villager, player);
            EnvironmentModule.apply(input, villager, player);
            PlayerModule.apply(input, villager, player);
            Map<String, String> variables = Map.of("player", playerName, "villager", villagerName);
            StringBuilder sb = new StringBuilder();
            if (!Config.getInstance().villagerChatAISystemPrompt.isEmpty()) {
                sb.append(Config.getInstance().villagerChatAISystemPrompt);
                sb.append("\n");
            }
            for (String s2 : input) {
                for (Map.Entry<String, String> entry : variables.entrySet()) {
                    s2 = s2.replaceAll("\\$" + entry.getKey(), entry.getValue());
                }
                sb.append(s2);
            }
            String system = sb.toString();
            StringBuilder body = new StringBuilder();
            body.append("{");
            body.append("\"model\": \"").append(Config.getInstance().villagerChatAIModel).append("\",");
            body.append("\"messages\": [");
            body.append("{\"role\": \"system\", \"content\": ").append(GPT3.jsonStringQuote(system)).append("},");
            for (Tuple pair : pastDialogue) {
                String role = (String)pair.m_14418_();
                String content = (String)pair.m_14419_();
                body.append("{\"role\": \"").append(role).append("\", \"content\": ").append(GPT3.jsonStringQuote(content)).append("},");
            }
            body.append("{\"role\": \"user\", \"content\": ").append(GPT3.jsonStringQuote(msg)).append("}");
            body.append("]}");
            String token = Config.getInstance().villagerChatAIToken;
            if (token.isEmpty() || Config.getInstance().villagerChatAIEndpoint.contains("conczin.net")) {
                token = variables.get("player");
            }
            Answer message = GPT3.post(Config.getInstance().villagerChatAIEndpoint, body.toString(), token);
            if (message.error == null) {
                if (message.answer != null) {
                    pastDialogue.add(new Tuple((Object)"user", (Object)msg));
                    pastDialogue.add(new Tuple((Object)"assistant", (Object)message.answer));
                }
                return Optional.ofNullable(message.answer);
            }
            if (message.error.equals("invalid_model")) {
                player.m_5661_((Component)Component.m_237113_((String)"Invalid model!").m_130940_(ChatFormatting.RED), false);
            } else if (message.error.equals("limit")) {
                MutableComponent styled = Component.m_237115_((String)"mca.limit.patreon").m_130938_(s -> s.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Luke100000/minecraft-comes-alive/wiki/GPT3-based-conversations#increase-conversation-limit")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"mca.limit.patreon.hover"))));
                player.m_5661_((Component)styled, false);
            } else if (message.error.equals("limit_premium")) {
                player.m_5661_((Component)Component.m_237115_((String)"mca.limit.premium").m_130940_(ChatFormatting.RED), false);
            } else {
                MCA.LOGGER.error(message.error);
                player.m_5661_((Component)Component.m_237115_((String)"mca.ai_broken").m_130940_(ChatFormatting.RED), false);
            }
        }
        catch (Exception e) {
            MCA.LOGGER.error((Object)e);
            player.m_5661_((Component)Component.m_237115_((String)"mca.ai_broken").m_130940_(ChatFormatting.RED), false);
        }
        return Optional.empty();
    }

    static String jsonStringQuote(String string) {
        StringBuilder sb = new StringBuilder("\"");
        for (char c : string.toCharArray()) {
            sb.append(switch (c) {
                case '\"', '/', '\\' -> "\\" + c;
                case '\b' -> "\\b";
                case '\t' -> "\\t";
                case '\n' -> "\\n";
                case '\f' -> "\\f";
                case '\r' -> "\\r";
                default -> c < ' ' ? String.format(Locale.ROOT, "\\u%04x", Character.valueOf(c)) : Character.valueOf(c);
            });
        }
        return sb.append('\"').toString();
    }

    static String cleanupAnswer(String answer) {
        answer = answer.replace("\"", "");
        answer = answer.replace("\n", " ");
        String[] parts = answer.split(":", 2);
        return parts[parts.length - 1].strip();
    }

    public record Answer(String answer, String error) {
    }
}

