/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.mca.MCAClient;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import java.util.UUID;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface CommonVillagerModel<T extends LivingEntity> {
    public ModelPart getBreastPart();

    public ModelPart getBodyPart();

    public Iterable<ModelPart> getCommonHeadParts();

    public Iterable<ModelPart> getCommonBodyParts();

    public Iterable<ModelPart> getBreastParts();

    public VillagerDimensions.Mutable getDimensions();

    public float getBreastSize();

    public void setBreastSize(float var1);

    default public void renderCommon(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float breastSize;
        float headSize = this.getDimensions().getHead();
        matrices.m_85836_();
        matrices.m_85841_(headSize, headSize, headSize);
        this.getCommonHeadParts().forEach(a -> a.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
        matrices.m_85849_();
        this.getCommonBodyParts().forEach(a -> a.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
        if (this.getBreastPart().f_104207_ && this.getBodyPart().f_104207_ && (breastSize = this.getBreastSize() * this.getDimensions().getBreasts()) > 0.0f) {
            matrices.m_85836_();
            matrices.m_85841_(breastSize * 0.2f + 1.05f, breastSize * 0.75f + 0.75f, breastSize * 0.75f + 0.75f);
            for (ModelPart part : this.getBreastParts()) {
                part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.m_85849_();
        }
    }

    default public void applyVillagerDimensions(VillagerLike<?> villager, boolean isSneaking) {
        this.getDimensions().set(villager.getVillagerDimensions());
        this.setBreastSize(villager.getGenetics().getBreastSize());
        this.getBreastPart().f_104207_ = villager.getGenetics().getGender() == Gender.FEMALE;
        for (ModelPart part : this.getBreastParts()) {
            part.f_104203_ = 0.9424779f + this.getBodyPart().f_104203_;
            float cy = 0.0f;
            float cz = 0.0f;
            if (isSneaking) {
                cy = 3.0f;
                cz = 1.5f;
            }
            part.m_104227_(0.25f, (float)(5.0 - Math.pow(this.getBreastSize(), 0.5) * 2.5 + (double)cy), -1.5f + this.getBreastSize() * 0.25f + cz);
        }
    }

    default public void copyCommonAttributes(CommonVillagerModel<T> target) {
        target.getDimensions().set(this.getDimensions());
        target.setBreastSize(this.getBreastSize());
    }

    public static VillagerLike<?> getVillager(Level world, UUID uuid) {
        if (MCAClient.fallbackVillager == null) {
            MCAClient.fallbackVillager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_(world);
        }
        return MCAClient.playerData.getOrDefault(uuid, MCAClient.fallbackVillager);
    }

    public static VillagerLike<?> getVillager(Entity villager) {
        if (villager instanceof VillagerLike) {
            VillagerLike v = (VillagerLike)villager;
            return v;
        }
        return CommonVillagerModel.getVillager(villager.m_9236_(), villager.m_20148_());
    }
}

