/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.SoundsMCA;
import fabric.net.mca.block.BlocksMCA;
import fabric.net.mca.entity.EntitiesMCA;
import fabric.net.mca.entity.GrimReaperEntity;
import fabric.net.mca.server.world.data.VillageManager;
import fabric.net.mca.util.NbtHelper;
import fabric.net.mca.util.WorldUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3730;

public class ReaperSpawner {
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
    private final Object lock = new Object();
    private final Map<Long, ActiveSummon> activeSummons = new HashMap<Long, ActiveSummon>();
    private final VillageManager manager;

    public ReaperSpawner(VillageManager manager) {
        this.manager = manager;
    }

    public ReaperSpawner(VillageManager manager, class_2487 nbt) {
        this.manager = manager;
        NbtHelper.toList((class_2520)nbt.method_10554("summons", 10), n -> new ActiveSummon((class_2487)n)).forEach(summon -> this.activeSummons.put(summon.position.spawnPosition.method_10063(), (ActiveSummon)summon));
    }

    private void warn(class_1937 world, class_2338 pos, String phrase) {
        world.method_18456().stream().min(Comparator.comparingInt(a -> a.method_24515().method_19455((class_2382)pos))).ifPresent(p -> p.method_7353((class_2561)class_2561.method_43471((String)phrase).method_27692(class_124.field_1061), true));
    }

    public void trySpawnReaper(class_3218 world, class_2338 pos) {
        if (!Config.getInstance().allowGrimReaper) {
            return;
        }
        class_1923 chunkPos = new class_1923(pos);
        if (!WorldUtils.isAreaLoaded(world, chunkPos, 1)) {
            return;
        }
        if (world.method_8320(pos).method_26204() != class_2246.field_10234) {
            return;
        }
        MCA.LOGGER.info("Attempting to spawn reaper at {} in {}", (Object)pos, (Object)world.method_27983().method_29177());
        if (!this.isNightTime((class_1937)world)) {
            this.warn((class_1937)world, pos, "reaper.day");
            return;
        }
        Set<class_2338> totems = this.getTotemsFires((class_1937)world, pos);
        MCA.LOGGER.info("It is night time, found {} totems", (Object)totems.size());
        if (totems.size() < 3) {
            this.warn((class_1937)world, pos, "reaper.totems");
            return;
        }
        this.start(new SummonPosition(pos.method_10084(), totems));
        class_1299.field_6112.method_47821(world, pos, class_3730.field_16461);
        world.method_8652(pos, class_2246.field_22090.method_9564(), 3);
        world.method_8652(pos.method_10084(), ((class_2248)BlocksMCA.INFERNAL_FLAME.get()).method_9564(), 3);
        totems.forEach(totem -> world.method_8652(totem, ((class_2248)BlocksMCA.INFERNAL_FLAME.get()).method_9564(), 18));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(SummonPosition pos) {
        Object object = this.lock;
        synchronized (object) {
            this.activeSummons.computeIfAbsent(pos.spawnPosition.method_10063(), ActiveSummon::new).start(pos);
            this.manager.method_80();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(class_3218 world) {
        Object object = this.lock;
        synchronized (object) {
            boolean empty = this.activeSummons.isEmpty();
            this.activeSummons.values().removeIf(summon -> {
                try {
                    return summon.tick(world);
                }
                catch (Exception e) {
                    MCA.LOGGER.error("Exception ticking summon", (Throwable)e);
                    return true;
                }
            });
            if (!empty) {
                this.manager.method_80();
            }
        }
    }

    private boolean isNightTime(class_1937 world) {
        long time = world.method_8532() % 24000L;
        MCA.LOGGER.info("Current time is {}", (Object)time);
        return time >= 13000L && time <= 23000L;
    }

    private Set<class_2338> getTotemsFires(class_1937 world, class_2338 pos) {
        int groundY = pos.method_10264() - 1;
        int leftSkyHeight = world.method_31600() - groundY;
        int minPillarHeight = Math.min(Config.getInstance().minPillarHeight, leftSkyHeight);
        class_2338.class_2339 target = new class_2338.class_2339();
        return Stream.of(HORIZONTALS).map(d -> target.method_10101((class_2382)pos).method_33098(groundY).method_10104(d, 3)).filter(pillarPos -> {
            for (int height = 1; height <= leftSkyHeight; ++height) {
                pillarPos.method_33098(groundY + height);
                if (world.method_8320((class_2338)pillarPos).method_27852(class_2246.field_10540)) continue;
                if (world.method_8320((class_2338)pillarPos).method_26164(class_3481.field_21952)) {
                    return height - 1 >= minPillarHeight;
                }
                return false;
            }
            return false;
        }).map(class_2338::method_10062).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2487 writeNbt() {
        Object object = this.lock;
        synchronized (object) {
            class_2487 nbt = new class_2487();
            nbt.method_10566("summons", (class_2520)NbtHelper.fromList(this.activeSummons.values(), ActiveSummon::write));
            return nbt;
        }
    }

    static class SummonPosition {
        public final class_2338 spawnPosition;
        public final class_2338 fire;
        public final Set<class_2338> totems;

        public SummonPosition(class_2487 tag) {
            if (tag.method_10545("fire") || tag.method_10545("totems") || tag.method_10545("spawnPosition")) {
                this.fire = class_2512.method_10691((class_2487)tag.method_10562("fire"));
                this.totems = new HashSet<class_2338>(NbtHelper.toList((class_2520)tag.method_10562("totems"), v -> class_2512.method_10691((class_2487)((class_2487)v))));
                this.spawnPosition = class_2512.method_10691((class_2487)tag.method_10562("spawnPosition"));
            } else {
                this.totems = new HashSet<class_2338>();
                this.spawnPosition = class_2512.method_10691((class_2487)tag);
                this.fire = this.spawnPosition.method_10087(10);
            }
        }

        public SummonPosition(class_2338 fire, Set<class_2338> totems) {
            this.fire = fire;
            this.spawnPosition = fire.method_10086(10);
            this.totems = totems;
        }

        public boolean isCancelled(class_1937 world) {
            return !this.check(this.fire, world);
        }

        private boolean check(class_2338 pos, class_1937 world) {
            return world.method_8320(pos).method_27852((class_2248)BlocksMCA.INFERNAL_FLAME.get());
        }

        public class_2487 toNbt() {
            class_2487 tag = new class_2487();
            tag.method_10566("fire", (class_2520)class_2512.method_10692((class_2338)this.fire));
            tag.method_10566("totems", (class_2520)NbtHelper.fromList(this.totems, class_2512::method_10692));
            tag.method_10566("spawnPosition", (class_2520)class_2512.method_10692((class_2338)this.spawnPosition));
            return tag;
        }
    }

    static class ActiveSummon {
        private int ticks;
        private SummonPosition position;

        ActiveSummon(long l) {
        }

        ActiveSummon(class_2487 nbt) {
            this.ticks = nbt.method_10550("ticks");
            this.position = new SummonPosition(nbt.method_10562("position"));
        }

        public void start(SummonPosition pos) {
            if (this.ticks <= 0) {
                this.position = pos;
                this.ticks = 100;
            }
        }

        public boolean tick(class_3218 world) {
            if (this.ticks <= 0 || this.position == null) {
                return true;
            }
            if (this.position.isCancelled((class_1937)world)) {
                this.position.totems.forEach(totem -> {
                    if (this.position.check((class_2338)totem, (class_1937)world)) {
                        world.method_8501(totem, class_2246.field_10036.method_9564());
                    }
                });
                this.position = null;
                this.ticks = 0;
                return true;
            }
            if (--this.ticks % 20 == 0) {
                class_1299.field_6112.method_47821(world, this.position.spawnPosition, class_3730.field_16461);
            }
            if (this.ticks == 0) {
                GrimReaperEntity reaper = (GrimReaperEntity)((class_1299)EntitiesMCA.GRIM_REAPER.get()).method_47821(world, this.position.spawnPosition, class_3730.field_16461);
                if (reaper != null) {
                    reaper.method_5783((class_3414)SoundsMCA.REAPER_SUMMON.get(), 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }

        public class_2487 write() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("ticks", this.ticks);
            nbt.method_10566("position", (class_2520)this.position.toNbt());
            return nbt;
        }
    }
}

