/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.Constants;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class TipManager
extends class_4309 {
    private final Map<class_2960, ITip> loadedTips = new HashMap<class_2960, ITip>();
    private final List<ITip> randomAccess = new ArrayList<ITip>();
    private final List<ITip> immutableAccess = Collections.unmodifiableList(this.randomAccess);

    public TipManager() {
        super(new Gson(), "tips");
    }

    public List<ITip> getTips() {
        return this.immutableAccess;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        this.loadedTips.clear();
        this.randomAccess.clear();
        long startTime = System.nanoTime();
        map.forEach((tipId, tipData) -> {
            try {
                if (tipData instanceof JsonObject) {
                    JsonObject json = (JsonObject)tipData;
                    class_2960 serializerID = (class_2960)Serializers.RESOURCE_LOCATION.fromJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
                    ITipSerializer<?> serializer = TipsAPI.getTipSerializer(serializerID);
                    if (serializer == null) {
                        throw new JsonParseException("Serializer " + serializerID + " is unknown!");
                    }
                    Object tipEntry = serializer.fromJSON((class_2960)tipId, json);
                    if (tipEntry == null) {
                        throw new JsonParseException("Serializer " + serializerID + " produced a null result!");
                    }
                    this.loadedTips.put((class_2960)tipId, (ITip)tipEntry);
                    this.randomAccess.add((ITip)tipEntry);
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load tip {}!", tipId, (Object)e);
            }
        });
        Collections.shuffle(this.randomAccess);
        Constants.LOG.debug("Loaded {} tips. Took {}ms.", (Object)this.loadedTips.size(), (Object)((double)(System.nanoTime() - startTime) / 1000000.0));
    }
}

