/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class SimpleTip
implements ITip {
    public static final ITipSerializer<SimpleTip> SERIALIZER = new Serializer();
    private final class_2960 id;
    private final class_2561 title;
    private final class_2561 text;
    private final Optional<Integer> cycleTime;

    public SimpleTip(class_2960 id, class_2561 title, class_2561 text, Optional<Integer> cycleTime) {
        this.id = id;
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public class_2561 getText() {
        return this.text;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime.orElse(TipsModCommon.CONFIG.defaultCycleTime);
    }

    private static final class Serializer
    implements ITipSerializer<SimpleTip> {
        private Serializer() {
        }

        @Override
        public SimpleTip fromJSON(class_2960 id, JsonObject json) {
            class_2561 title = (class_2561)Serializers.TEXT.fromJSON(json, "title", (Object)TipsAPI.DEFAULT_TITLE);
            class_2561 text = (class_2561)Serializers.TEXT.fromJSON(json, "tip");
            Optional cycleTime = Serializers.INT.fromJSONOptional(json, "cycleTime");
            if (title == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have a title. This is required!");
            }
            if (text == null) {
                throw new JsonParseException("Tip " + id.toString() + " does not have text. This is required.");
            }
            return new SimpleTip(id, title, text, cycleTime);
        }

        @Override
        public JsonObject toJSON(SimpleTip toWrite) {
            JsonObject json = new JsonObject();
            Serializers.RESOURCE_LOCATION.toJSON(json, "type", (Object)TipsAPI.DEFAULT_SERIALIZER);
            Serializers.TEXT.toJSON(json, "title", (Object)toWrite.title);
            Serializers.TEXT.toJSON(json, "tip", (Object)toWrite.text);
            Serializers.INT.toJSONOptional(json, "cycleTime", toWrite.cycleTime);
            return json;
        }
    }
}

