/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.Constants;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.api.resources.ITipSerializer;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.SimpleTip;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7417;

public class TipsAPI {
    public static final class_2960 DEFAULT_SERIALIZER = new class_2960("tips", "simple_tip");
    public static final class_2561 DEFAULT_TITLE = class_2561.method_43471((String)"tipsmod.title.default").method_27695(new class_124[]{class_124.field_1067, class_124.field_1073, class_124.field_1054});
    public static final ITip EMPTY = new SimpleTip(new class_2960("bookshelf", "empty"), DEFAULT_TITLE, (class_2561)class_2561.method_43470((String)"No tips loaded. Please review your config options!"), Optional.of(999999));
    private static Map<class_2960, ITipSerializer<?>> SERIALIZERS = new HashMap();
    private static Set<Class<? extends class_437>> SCREENS = new HashSet<Class<? extends class_437>>();
    private static int currentTipIndex = 0;

    public static void registerTipSerializer(class_2960 id, ITipSerializer<?> serializer) {
        SERIALIZERS.put(id, serializer);
    }

    public static void registerTipScreen(Class<? extends class_437> screenClass) {
        SCREENS.add(screenClass);
    }

    public static boolean canRenderOnScreen(class_437 screen) {
        return SCREENS.stream().filter(clazz -> clazz.isInstance(screen)).count() > 0L;
    }

    public static ITip getRandomTip() {
        List<ITip> filteredTips = TipsAPI.getLoadedTips().stream().filter(TipsAPI::canDisplayTip).toList();
        if (currentTipIndex + 1 > filteredTips.size()) {
            currentTipIndex = 0;
        }
        if (!filteredTips.isEmpty()) {
            return filteredTips.get(currentTipIndex++);
        }
        return EMPTY;
    }

    public static ITipSerializer<?> getTipSerializer(class_2960 id) {
        return SERIALIZERS.get(id);
    }

    public static List<ITip> getLoadedTips() {
        return TipsModCommon.TIP_MANAGER.getTips();
    }

    public static boolean canDisplayTip(ITip tip) {
        String key;
        if (tip == null) {
            return false;
        }
        if (tip.getId() == null) {
            Constants.LOG.error("Found invalid tip without an ID. Object: {}, Class: {}", (Object)tip, tip.getClass());
            return false;
        }
        if (tip.getTitle() == null) {
            Constants.LOG.error("Found invalid tip. Title is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        if (tip.getText() == null) {
            Constants.LOG.error("Found invalid tip. Text is null. Object: {}, Class: {}, ID: {}", new Object[]{tip, tip.getClass(), tip.getId()});
            return false;
        }
        class_2960 id = tip.getId();
        if (TipsModCommon.CONFIG.ignoredNamespaces.contains(id.method_12836())) {
            return false;
        }
        if (TipsModCommon.CONFIG.ignoredTips.contains(id.toString())) {
            return false;
        }
        class_7417 contents = tip.getText().method_10851();
        return !(contents instanceof class_2588) || class_1074.method_4663((String)(key = ((class_2588)contents).method_11022()));
    }
}

