/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.chunk;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class PlayerChunkData {
    private static final class_1923 INVALID = new class_1923(0, 0){

        public boolean equals(Object other) {
            return other == INVALID;
        }
    };
    private class_1923 lastChunk = INVALID;
    private class_5321<class_1937> lastLevel = null;
    private Object2IntOpenHashMap<class_1923> lastTickets = new Object2IntOpenHashMap();
    private class_1923 playerChunkLoadCenter = null;
    private class_1923 playerChunkLoadLastPos = null;
    private int playerChunkLoadViewDistance = 0;
    private class_2338[] playerMovementTracker = new class_2338[6];
    private class_1923 playerMovementTrackerAvg = INVALID;
    private int playerMovementTrackerIndex = 0;
    private long lastPlayerMovementUpdate = 0L;
    private class_2338 lastPlayerPos = null;
    private double playerMovementSpeed = 0.0;
    private class_243 direction = class_243.field_1353;
    public boolean isFrozen = false;

    public void onChunkChanged(class_3222 player) {
        if (player == null || player.getClass() != class_3222.class) {
            return;
        }
        if (!player.method_37908().method_27983().equals(this.lastLevel)) {
            this.lastLevel = player.method_37908().method_27983();
            this.setPlayerViewDistTo(null, player.method_37908().method_8503().method_3847(this.lastLevel).method_14178(), 0);
            this.playerChunkLoadViewDistance = 4;
            this.playerChunkLoadCenter = null;
            this.playerMovementTracker = new class_2338[6];
            this.playerMovementTrackerAvg = INVALID;
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.lastChunk = null;
        }
        if (this.lastChunk != null && player.method_31476().method_24022(this.lastChunk) > 10) {
            this.setPlayerViewDistTo(player.method_31476(), (class_3215)player.method_37908().method_8398(), 0);
            this.playerChunkLoadViewDistance = 4;
            this.playerChunkLoadCenter = null;
            this.playerMovementTracker = new class_2338[6];
            this.playerMovementTrackerAvg = INVALID;
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
        }
        if (player.method_31476().equals((Object)this.lastChunk)) {
            if (System.currentTimeMillis() - this.lastPlayerMovementUpdate > 5000L) {
                this.trackPlayerMovement(player);
            }
            if (this.isFrozen && player.method_37908().method_8393((int)((double)player.method_24515().method_10263() + this.direction.method_1029().method_18805((double)32.0, (double)32.0, (double)32.0).field_1352) >> 4, (int)((double)player.method_24515().method_10260() + this.direction.method_1029().method_18805((double)32.0, (double)32.0, (double)32.0).field_1350) >> 4)) {
                this.isFrozen = false;
            }
            return;
        }
        this.trackPlayerMovement(player);
        this.lastChunk = player.method_31476();
    }

    private void trackPlayerMovement(class_3222 player) {
        int z;
        int x;
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos != null) {
            this.playerMovementSpeed -= this.playerMovementSpeed / 5.0;
            x = player.method_31477() - this.lastPlayerPos.method_10263();
            z = player.method_31479() - this.lastPlayerPos.method_10260();
            this.playerMovementSpeed += Math.sqrt(x * x + z * z) / ((double)(currentTime - this.lastPlayerMovementUpdate) / 1000.0) / 5.0;
        }
        this.lastPlayerPos = player.method_24515();
        this.lastPlayerMovementUpdate = currentTime;
        if (!player.method_31476().equals((Object)this.lastChunk)) {
            class_1923 newPos;
            this.playerMovementTrackerIndex = (this.playerMovementTrackerIndex + 1) % this.playerMovementTracker.length;
            this.playerMovementTracker[this.playerMovementTrackerIndex] = player.method_24515();
            x = 0;
            z = 0;
            int count = 0;
            for (int i = 0; i < this.playerMovementTracker.length; ++i) {
                class_2338 pos = this.playerMovementTracker[i];
                if (pos == null) continue;
                ++count;
                x += pos.method_10263();
                z += pos.method_10260();
            }
            this.playerMovementTrackerAvg = newPos = new class_1923(x / count >> 4, z / count >> 4);
            this.checkDirection(player);
        }
        this.chunkLoadForPlayer(player, this.playerMovementTrackerAvg);
    }

    private class_243 calculatePlayerMovementVec(class_3222 player) {
        int xOld = 0;
        int zOld = 0;
        int oldCounter = 0;
        int xNew = 0;
        int zNew = 0;
        int newCounter = 0;
        for (int i = 0; i < this.playerMovementTracker.length; ++i) {
            class_2338 pos = this.playerMovementTracker[(this.playerMovementTrackerIndex + 1 + i) % this.playerMovementTracker.length];
            if (pos == null) continue;
            if (i < this.playerMovementTracker.length / 2) {
                xOld += pos.method_10263();
                zOld += pos.method_10260();
                ++oldCounter;
                continue;
            }
            xNew += pos.method_10263();
            zNew += pos.method_10260();
            ++newCounter;
        }
        if (oldCounter == 0 || newCounter == 0) {
            return new class_243(48.0, 0.0, 0.0);
        }
        return new class_243((double)((xNew /= newCounter) - (xOld /= oldCounter)), 0.0, (double)((zNew /= newCounter) - (zOld /= oldCounter)));
    }

    private void chunkLoadForPlayer(class_3222 player, class_1923 newChunk) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        int viewDistance = this.calculateViewDistance(player);
        if (newChunk.equals((Object)this.playerChunkLoadCenter) && viewDistance == this.playerChunkLoadViewDistance) {
            return;
        }
        this.playerChunkLoadCenter = newChunk;
        this.setPlayerViewDistTo(this.playerChunkLoadCenter, ((class_3218)player.method_37908()).method_14178(), viewDistance);
    }

    private int calculateViewDistance(class_3222 player) {
        class_243 playerMovement = this.calculatePlayerMovementVec(player).method_18805(this.playerMovementSpeed / 4.3, 0.0, this.playerMovementSpeed / 4.3);
        class_3215 chunkSource = ((class_3218)player.method_37908()).method_14178();
        int viewDistance = 4;
        if (playerMovement.method_1033() < 120.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier) {
            viewDistance = playerMovement.method_1033() <= 40.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier ? chunkSource.field_17254.field_18243 : (int)((1.0 - (playerMovement.method_1033() - 40.0) / (80.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier)) * (double)chunkSource.field_17254.field_18243);
        }
        return Math.max(5, viewDistance);
    }

    private void setPlayerViewDistTo(class_1923 pos, class_3215 chunkSource, int viewDistance) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        if (this.playerChunkLoadLastPos != null) {
            chunkSource.method_17300(BetterChunkLoading.TICKET_PLAYER_CHUNK_AREA, this.playerChunkLoadLastPos, this.playerChunkLoadViewDistance, (Object)this.playerChunkLoadLastPos);
            this.playerChunkLoadLastPos = null;
        }
        if (pos == null) {
            return;
        }
        this.playerChunkLoadViewDistance = viewDistance;
        this.playerChunkLoadLastPos = pos;
        chunkSource.method_17297(BetterChunkLoading.TICKET_PLAYER_CHUNK_AREA, pos, viewDistance, (Object)pos);
        chunkSource.method_16155();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            BetterChunkLoading.LOGGER.info("Set player chunkloading chunk position to: " + pos + " size:" + viewDistance);
        }
    }

    public void onLogout(class_3222 player) {
        this.setPlayerViewDistTo(null, ((class_3218)player.method_37908()).method_14178(), 0);
    }

    private void checkDirection(class_3222 player) {
        this.direction = this.calculatePlayerMovementVec(player);
        class_243 currentpos = player.method_19538();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enablePrediction) {
            this.checkPrediction(this.direction, currentpos, player);
        }
        if (!player.method_37908().method_8393((int)((double)player.method_24515().method_10263() + this.direction.method_1029().method_18805((double)32.0, (double)32.0, (double)32.0).field_1352) >> 4, (int)((double)player.method_24515().method_10260() + this.direction.method_1029().method_18805((double)32.0, (double)32.0, (double)32.0).field_1350) >> 4)) {
            this.isFrozen = true;
        }
    }

    private void checkPrediction(class_243 direction, class_243 currentPos, class_3222 player) {
        int viewDist = ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading ? this.playerChunkLoadViewDistance : ((class_3215)player.method_37908().method_8398()).field_17254.field_18243;
        class_243 predictedPos = currentPos.method_1019(direction.method_1029().method_1021(16.0 * ((double)viewDist * 0.7)));
        for (int i = 0; i < 30 && !player.method_37908().method_8393((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4); ++i) {
            predictedPos = predictedPos.method_1019(direction.method_1029().method_22882().method_1021(16.0));
        }
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            class_1923 nextPredictedStartChunk = new class_1923((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4);
            BetterChunkLoading.LOGGER.info("Set predictive loading position with area:" + Math.min(((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea, viewDist + 1) + " to chunk: " + nextPredictedStartChunk + " player chunk:" + player.method_31476());
        }
        Object2IntOpenHashMap<class_1923> oldTickets = this.lastTickets;
        this.lastTickets = new Object2IntOpenHashMap();
        int repetition = (int)(Math.abs(direction.field_1352) + Math.abs(direction.field_1350)) / 16;
        for (int i = 0; i < repetition; ++i) {
            this.addpredictionChunkTicket(new class_1923((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4), Math.min(((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea, viewDist + 1), ((class_3218)player.method_37908()).method_14178());
            predictedPos = predictedPos.method_1019(direction.method_1029().method_1021(16.0));
        }
        for (Object2IntMap.Entry ticketEntry : oldTickets.object2IntEntrySet()) {
            ((class_3215)player.method_37908().method_8398()).method_17300(BetterChunkLoading.TICKET_PREDICTION, (class_1923)ticketEntry.getKey(), ticketEntry.getIntValue(), (Object)((class_1923)ticketEntry.getKey()));
        }
        ((class_3215)player.method_37908().method_8398()).method_16155();
    }

    private void addpredictionChunkTicket(class_1923 pos, int level, class_3215 chunkSource) {
        chunkSource.method_17297(BetterChunkLoading.TICKET_PREDICTION, pos, level, (Object)pos);
        this.lastTickets.put((Object)pos, level);
    }
}

