/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.google.common.collect.Sets;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.PlayerData;
import dev.tr7zw.skinlayers.versionless.util.wrapper.SolidPixelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;

public class CustomLayerFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private static final class_310 mc = class_310.method_1551();
    private final Set<class_1792> hideHeadLayers = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8470, class_1802.field_8681, class_1802.field_8712, class_1802.field_8398, class_1802.field_8791});
    private final List<Layer> bodyLayers = new ArrayList<Layer>();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.method_17165()).hasThinArms();

    public CustomLayerFeatureRenderer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
        this.bodyLayers.add(new Layer(PlayerData::getHeadMesh, false, class_1664.field_7563, Shape.HEAD, () -> ((class_591)this.method_17165()).field_3398, player -> {
            class_1799 itemStack = player.method_6118(class_1304.field_6169);
            if (itemStack != null && this.hideHeadLayers.contains(itemStack.method_7909())) {
                return false;
            }
            return SkinLayersModBase.config.enableHat;
        }));
        this.bodyLayers.add(new Layer(PlayerData::getLeftLegMesh, false, class_1664.field_7566, Shape.LEGS, () -> ((class_591)this.method_17165()).field_3397, player -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(PlayerData::getRightLegMesh, false, class_1664.field_7565, Shape.LEGS, () -> ((class_591)this.method_17165()).field_3392, player -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(PlayerData::getLeftArmMesh, false, class_1664.field_7568, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((class_591)this.method_17165()).field_27433, player -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getRightArmMesh, true, class_1664.field_7570, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((class_591)this.method_17165()).field_3401, player -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getTorsoMesh, false, class_1664.field_7564, Shape.BODY, () -> ((class_591)this.method_17165()).field_3391, player -> SkinLayersModBase.config.enableJacket));
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 player, float f, float g, float h, float j, float k, float l) {
        if (player.method_5767()) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.field_1687 == null) {
            return;
        }
        if (player.method_5707(CustomLayerFeatureRenderer.mc.field_1773.method_19418().method_19326()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms, (class_591<class_742>)((class_591)this.method_17165()))) {
            return;
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_24294((class_2960)player.method_3117(), (boolean)true));
        int m = class_922.method_23622((class_1309)player, (float)0.0f);
        this.renderLayers(player, settings, poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(class_742 abstractClientPlayer, PlayerSettings settings, class_4587 matrixStack, class_4588 vertices, int light, int overlay) {
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = 1.035f;
        float widthScaling = SkinLayersModBase.config.baseVoxelSize;
        for (Layer layer : this.bodyLayers) {
            Mesh mesh = layer.meshGetter.apply(settings);
            if (mesh == null || !abstractClientPlayer.method_7348(layer.modelPart) || !layer.vanillaGetter.get().field_3665 || !layer.configGetter.apply(abstractClientPlayer).booleanValue()) continue;
            matrixStack.method_22903();
            LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, matrixStack, layer.vanillaGetter.get());
            layer.vanillaGetter.get().method_22703(matrixStack);
            float x = 0.0f;
            float y = 0.0f;
            if (layer.shape == Shape.ARMS) {
                x = 0.998f;
            } else if (layer.shape == Shape.ARMS_SLIM) {
                x = 0.499f;
            }
            if (layer.shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (layer.mirrored) {
                x *= -1.0f;
            }
            if (layer.shape == Shape.HEAD) {
                float voxelSize = SkinLayersModBase.config.headVoxelSize;
                matrixStack.method_22904(0.0, -0.25, 0.0);
                matrixStack.method_22905(voxelSize, voxelSize, voxelSize);
                matrixStack.method_22904(0.0, 0.25, 0.0);
                matrixStack.method_22904(0.0, -0.04, 0.0);
            } else {
                matrixStack.method_22905(widthScaling, heightScaling, pixelScaling);
                y = layer.shape.yOffsetMagicValue;
            }
            mesh.setPosition(x, y, 0.0f);
            mesh.render(layer.vanillaGetter.get(), matrixStack, vertices, light, overlay, -1);
            matrixStack.method_22909();
        }
    }

    private static class Layer {
        private final Function<PlayerSettings, Mesh> meshGetter;
        private final boolean mirrored;
        private final class_1664 modelPart;
        private final Shape shape;
        private final Supplier<class_630> vanillaGetter;
        private final Function<class_742, Boolean> configGetter;

        public Layer(Function<PlayerSettings, Mesh> meshGetter, boolean mirrored, class_1664 modelPart, Shape shape, Supplier<class_630> vanillaGetter, Function<class_742, Boolean> configGetter) {
            this.meshGetter = meshGetter;
            this.mirrored = mirrored;
            this.modelPart = modelPart;
            this.shape = shape;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }

    private static enum Shape {
        HEAD(0.0f, new SolidPixelWrapper.Dimensions(8, 8, 8)),
        BODY(-0.2f, new SolidPixelWrapper.Dimensions(8, 12, 4)),
        LEGS(-0.2f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS(-0.1f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS_SLIM(-0.1f, new SolidPixelWrapper.Dimensions(3, 14, 4));

        private final float yOffsetMagicValue;
        private final SolidPixelWrapper.Dimensions dimensions;

        private Shape(float yOffsetMagicValue, SolidPixelWrapper.Dimensions dimensions) {
            this.dimensions = dimensions;
            this.yOffsetMagicValue = yOffsetMagicValue;
        }
    }
}

