/*
 * Decompiled with CFR 0.152.
 */
package net.trique.mythicupgrades.mixin;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.trique.mythicupgrades.MythicUpgradesDamageTypes;
import net.trique.mythicupgrades.effect.MUEffects;
import net.trique.mythicupgrades.item.BaseMythicItem;
import net.trique.mythicupgrades.item.MythicEffectsArmorItem;
import net.trique.mythicupgrades.util.CommonFunctions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private boolean has_damage_been_deflected = false;
    @Unique
    private float deflecting_damage = 0.0f;
    @Unique
    private BaseMythicItem lastUsed;
    @Unique
    private MythicEffectsArmorItem lastWorn;
    @Shadow
    @Nullable
    protected class_1657 field_6258;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract Map<class_1291, class_1293> method_6088();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void checkItemInHand(CallbackInfo ci) {
        class_1792 class_17922;
        if (!this.method_6118(class_1304.field_6173).method_7960() && (class_17922 = this.method_6118(class_1304.field_6173).method_7909()) instanceof BaseMythicItem) {
            BaseMythicItem item = (BaseMythicItem)class_17922;
            if (this.lastUsed != null && !item.equals(this.lastUsed)) {
                CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastUsed.getMainHandEffects());
            }
            if (CommonFunctions.checkStatusEffects((class_1309)this, item.getMainHandEffects())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getMainHandEffects());
            }
            this.lastUsed = item;
        } else if (this.lastUsed != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastUsed.getMainHandEffects());
            this.lastUsed = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyArmorBuffs(CallbackInfo ci) {
        class_1792 class_17922;
        class_1799 head = this.method_6118(class_1304.field_6169);
        if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem) {
            MythicEffectsArmorItem item = (MythicEffectsArmorItem)class_17922;
            if (this.lastWorn != null && !CommonFunctions.hasCorrectArmorOn((class_1309)this, item.method_7686())) {
                CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastWorn.getEquipmentBuffs());
            }
            if (CommonFunctions.hasCorrectArmorOn((class_1309)this, item.method_7686()) && CommonFunctions.checkStatusEffects((class_1309)this, item.getEquipmentBuffs())) {
                CommonFunctions.addStatusEffects((class_1309)this, item.getEquipmentBuffs());
            }
            this.lastWorn = item;
        } else if (this.lastWorn != null) {
            CommonFunctions.removeMythicInfiniteEffects((class_1309)this, this.lastWorn.getEquipmentBuffs());
            this.lastWorn = null;
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void applyArmorDebuffs(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker;
        boolean was_damaged = (Boolean)cir.getReturnValue();
        if (was_damaged && (attacker = source.method_5529()) instanceof class_1309) {
            MythicEffectsArmorItem item;
            class_1792 class_17922;
            class_1309 entity = (class_1309)attacker;
            class_1799 head = this.method_6118(class_1304.field_6169);
            if (!head.method_7960() && (class_17922 = head.method_7909()) instanceof MythicEffectsArmorItem && CommonFunctions.hasCorrectArmorOn((class_1309)this, (item = (MythicEffectsArmorItem)class_17922).method_7686())) {
                CommonFunctions.addStatusEffects(entity, item.getEquipmentDebuffs(), (class_1309)this);
            }
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float reduceIncomingDamage(float amount, class_1282 source, float am1) {
        if (!this.method_37908().method_8608()) {
            class_1293 deflection = this.method_6088().get(MUEffects.DAMAGE_DEFLECTION);
            if (deflection != null) {
                class_1297 attacker = source.method_5529();
                float defl_dmg_coef = (float)deflection.method_5578() / 10.0f;
                if (attacker != null) {
                    this.deflecting_damage = (0.1f + defl_dmg_coef) * amount;
                    amount *= 0.9f - defl_dmg_coef;
                }
            }
            return amount;
        }
        return 0.0f;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void deflectDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker;
        class_1293 deflection;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (deflection = this.method_6088().get(MUEffects.DAMAGE_DEFLECTION)) != null && (attacker = source.method_5529()) != null && attacker.method_5739((class_1297)this) <= 3.0f && !this.has_damage_been_deflected) {
            this.has_damage_been_deflected = true;
            attacker.method_5643(MythicUpgradesDamageTypes.create(attacker.method_37908(), MythicUpgradesDamageTypes.DEFLECTING_DAMAGE_TYPE, (class_1297)((class_1309)this)), this.deflecting_damage);
        }
        this.has_damage_been_deflected = false;
    }

    @WrapWithCondition(method={"tickFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V")})
    private <T extends class_1309> boolean applyChanceWithToolMasteryForTickFallFlying(class_1799 instance, int amount, T user, Consumer<T> breakCallback) {
        return CommonFunctions.checkForItemMastery(user);
    }
}

