/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.internal.shade.net.minecraftforge.fml;

import com.google.gson.Gson;
import info.u_team.u_team_core.internal.shade.net.hycrafthd.update_checker.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionChecker.class);
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static final int HTTP_TIMEOUT_SECS = Integer.getInteger("http.timeoutSecs", 15);
    private static Map<ModInfo, CheckResult> results = new ConcurrentHashMap<ModInfo, CheckResult>();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null);

    public static void startVersionCheck(final Collection<ModInfo> modInfo, final String minecraftVersion, final Function<String, Version<?>> versionMapper) {
        new Thread("Version Check"){
            private HttpClient client;

            @Override
            public void run() {
                this.client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(HTTP_TIMEOUT_SECS)).build();
                modInfo.forEach(this::process);
            }

            private String openUrlString(URL url) throws IOException, URISyntaxException, InterruptedException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    HttpRequest request = HttpRequest.newBuilder().uri(currentUrl.toURI()).timeout(Duration.ofSeconds(HTTP_TIMEOUT_SECS)).setHeader("Accept-Encoding", "gzip").GET().build();
                    HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    int responseCode = response.statusCode();
                    if (responseCode < 300 || responseCode > 399) {
                        String bodyStr;
                        boolean isGzipEncoded = response.headers().firstValue("Content-Encoding").orElse("").equals("gzip");
                        try (InputStream inStream = isGzipEncoded ? new GZIPInputStream(response.body()) : response.body();
                             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));){
                            bodyStr = bufferedReader.lines().collect(Collectors.joining("\n"));
                        }
                        return bodyStr;
                    }
                    String newLocation = response.headers().firstValue("Location").orElseThrow(() -> new IOException("Got a 3xx response code but Location header was null while trying to fetch " + url));
                    currentUrl = new URL(currentUrl, newLocation);
                }
                throw new IOException("Too many redirects while trying to fetch " + url);
            }

            private void process(ModInfo mod) {
                Status status = Status.PENDING;
                Version target = null;
                LinkedHashMap<Version, String> changes = null;
                String display_url = null;
                try {
                    if (mod.url == null) {
                        return;
                    }
                    URL url = mod.url;
                    LOGGER.info("[{}] Starting version check at {}", (Object)mod.modid, (Object)url.toString());
                    String data = this.openUrlString(url);
                    LOGGER.debug("[{}] Received version check data:\n{}", (Object)mod.modid, (Object)data);
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    display_url = (String)json.get("homepage");
                    String rec = (String)promos.get(minecraftVersion + "-recommended");
                    String lat = (String)promos.get(minecraftVersion + "-latest");
                    Version current = (Version)versionMapper.apply(mod.currentVersion.toString());
                    if (rec != null) {
                        Version recommended = (Version)versionMapper.apply(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            Version latest;
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(latest = (Version)versionMapper.apply(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        Version latest = (Version)versionMapper.apply(lat);
                        status = current.compareTo(latest) < 0 ? Status.BETA_OUTDATED : Status.BETA;
                        target = latest;
                    } else {
                        status = Status.BETA;
                    }
                    LOGGER.info("[{}] Found status: {} Current: {} Target: {}", new Object[]{mod.modid, status, current, target});
                    changes = new LinkedHashMap<Version, String>();
                    Map tmp = (Map)json.get(minecraftVersion);
                    if (tmp != null) {
                        ArrayList<Version> ordered = new ArrayList<Version>();
                        for (String key : tmp.keySet()) {
                            Version ver = (Version)versionMapper.apply(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (Version ver : ordered) {
                            changes.put(ver, (String)tmp.get(ver.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to process update information", (Throwable)e);
                    status = Status.FAILED;
                }
                results.put(mod, new CheckResult(status, target, changes, display_url));
            }
        }.start();
    }

    public static CheckResult getResult(ModInfo mod) {
        return results.getOrDefault(mod, PENDING_CHECK);
    }

    public record CheckResult(Status status, Version<?> target, Map<Version<?>, String> changes, String url) {
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD,
        BETA,
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean draw;
        final boolean animated;

        private Status() {
            this(0, false, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, true, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this(sheetOffset, true, animated);
        }

        private Status(int sheetOffset, boolean draw, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.draw = draw;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this.draw;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }

    public record ModInfo(String modid, String currentVersion, URL url) {
    }
}

