/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.util.ClassUtil;
import info.u_team.u_team_core.util.annotation.AnnotationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.impl.util.ExceptionUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FabricAnnotationScanner
implements AnnotationUtil.AnnotationScanner {
    private final Map<String, List<AnnotationUtil.AnnotationData>> data = new HashMap<String, List<AnnotationUtil.AnnotationData>>();

    @Override
    public List<AnnotationUtil.AnnotationData> findAnnotations(String modid) {
        return this.data.computeIfAbsent(modid, this::scanMod);
    }

    private List<AnnotationUtil.AnnotationData> scanMod(String modid) {
        Set<Path> paths = ClassUtil.findModClasses(modid);
        ArrayList<AnnotationUtil.AnnotationData> annotations = new ArrayList<AnnotationUtil.AnnotationData>();
        for (Path path : paths) {
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    ClassReader classReader = new ClassReader(inputStream);
                    AnnotationClassVisitor visitor = new AnnotationClassVisitor();
                    classReader.accept((ClassVisitor)visitor, 0);
                    annotations.addAll(visitor.annotations);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                throw ExceptionUtil.wrap((Throwable)ex);
            }
        }
        return annotations;
    }

    private static class AnnotationClassVisitor
    extends ClassVisitor {
        private final Set<AnnotationUtil.AnnotationData> annotations = new HashSet<AnnotationUtil.AnnotationData>();
        private Type type;

        private AnnotationClassVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.type = Type.getObjectType((String)name);
        }

        public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean visible) {
            return new OurAnnotationVisitor(annotationDescriptor, ElementType.TYPE, this.type, this.type.getClassName());
        }

        public FieldVisitor visitField(int access, final String name, String descriptor, String signature, Object value) {
            return new FieldVisitor(589824){

                public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean visible) {
                    return new OurAnnotationVisitor(annotationDescriptor, ElementType.FIELD, type, name);
                }
            };
        }

        public MethodVisitor visitMethod(int access, final String name, final String descriptor, String signature, String[] exceptions) {
            return new MethodVisitor(589824){

                public AnnotationVisitor visitAnnotation(String annotationDescriptor, boolean visible) {
                    return new OurAnnotationVisitor(annotationDescriptor, ElementType.METHOD, type, name + descriptor);
                }
            };
        }

        private class OurAnnotationVisitor
        extends AnnotationVisitor {
            private final DataHolder data;

            private OurAnnotationVisitor(String annotationDescriptor, ElementType targetType, Type type, String memberName) {
                super(589824);
                AnnotationUtil.AnnotationData annotationData = new AnnotationUtil.AnnotationData(Type.getType((String)annotationDescriptor), targetType, type, memberName, new HashMap<String, Object>());
                this.data = new DataHolder(annotationData.annotationData());
                AnnotationClassVisitor.this.annotations.add(annotationData);
            }

            private OurAnnotationVisitor(DataHolder data) {
                super(589824);
                this.data = data;
            }

            public void visit(String name, Object value) {
                this.data.add(name, value);
            }

            public void visitEnum(String name, String descriptor, String value) {
                this.data.add(name, new EnumValue(Type.getType((String)descriptor), value));
            }

            public AnnotationVisitor visitArray(String name) {
                return new OurAnnotationVisitor(this.data.addList(name));
            }

            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                return new OurAnnotationVisitor(this.data.addMap(name));
            }
        }

        private class DataHolder {
            private final Map<String, Object> map;
            private final List<Object> list;

            private DataHolder(Map<String, Object> map) {
                this.map = map;
                this.list = null;
            }

            private DataHolder(List<Object> list) {
                this.map = null;
                this.list = list;
            }

            private void add(String name, Object value) {
                if (this.map != null) {
                    this.map.put(name, value);
                }
                if (this.list != null) {
                    this.list.add(value);
                }
            }

            private DataHolder addList(String name) {
                ArrayList<Object> subList = new ArrayList<Object>();
                this.add(name, subList);
                return new DataHolder(subList);
            }

            private DataHolder addMap(String name) {
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                this.add(name, subMap);
                return new DataHolder(subMap);
            }
        }
    }

    public record EnumValue(Type clazz, String value) {
    }
}

