/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.reflect.Type;
import java.util.regex.Pattern;

public class ByteBufferTypeHandler<T>
implements JsonSerializer<ByteBuf>,
JsonDeserializer<ByteBuf> {
    public static final double HUMA_READABLE_THRESHOLD = 4.0;
    private static final Pattern pattern = Pattern.compile("(?<=\\d),\\d+");

    public ByteBuf deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return null;
    }

    public JsonElement serialize(ByteBuf src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray result = new JsonArray();
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            JsonElement element = context.serialize((Object)"Enable debugPrintMessages to print this");
            result.add(element);
        } else {
            src.resetReaderIndex();
            Object data = this.cleanupString(src.toString(Charsets.UTF_8)) + "\n";
            double entropy = ByteBufferTypeHandler.calculateEntropy((String)data);
            data = ((String)data).replaceAll("\\p{C}", "");
            data = ((String)data).replaceAll("\\?", "");
            if (entropy > 4.0) {
                JsonElement element = context.serialize((Object)this.cleanupString((String)data));
                result.add(element);
            } else {
                result.add("<partial numeric data>");
                StringBuilder arrayString = new StringBuilder();
                arrayString.append("[");
                for (int i = 0; i < src.array().length && i < 200; ++i) {
                    arrayString.append(src.array()[i]);
                    if (i >= src.array().length - 1) continue;
                    arrayString.append(", ");
                }
                arrayString.append("]");
                result.add(arrayString.toString());
            }
            src.resetReaderIndex();
        }
        return result;
    }

    public static double calculateEntropy(String input) {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        for (char c : input.toCharArray()) {
            map.put((int)c, map.get((int)c) + 1);
        }
        double entropy = 0.0;
        IntIterator intIterator = map.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            if (count <= 0) continue;
            double probability = (double)count / (double)input.length();
            entropy -= probability * (Math.log(probability) / Math.log(2.0));
        }
        return entropy;
    }

    private String cleanupString(String in) {
        in = ((String)in).replaceAll("\\\\n", System.getProperty("line.separator"));
        if (pattern.matcher((CharSequence)(in = ((String)in).replaceAll("\ufffd", " "))).find()) {
            in = "Printing reduced bytebuffer data:" + System.getProperty("line.separator") + (String)in;
        }
        in = pattern.matcher((CharSequence)in).replaceAll("") + System.getProperty("line.separator");
        return in;
    }
}

